/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.StaticUtils;
import java.io.Serializable;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.AbstractSASLBindRequest;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.PlainSASLBindRequest;
import org.forgerock.opendj.ldap.requests.SASLBindClientImpl;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.util.Reject;

final class PlainSASLBindRequestImpl
extends AbstractSASLBindRequest<PlainSASLBindRequest>
implements PlainSASLBindRequest {
    private String authenticationID;
    private String authorizationID;
    private byte[] password;

    PlainSASLBindRequestImpl(PlainSASLBindRequest plainSASLBindRequest) {
        super(plainSASLBindRequest);
        this.authenticationID = plainSASLBindRequest.getAuthenticationID();
        this.authorizationID = plainSASLBindRequest.getAuthorizationID();
        this.password = StaticUtils.copyOfBytes(plainSASLBindRequest.getPassword());
    }

    PlainSASLBindRequestImpl(String authenticationID, byte[] password) {
        Reject.ifNull((Object[])new Serializable[]{authenticationID, password});
        this.authenticationID = authenticationID;
        this.password = password;
    }

    @Override
    public BindClient createBindClient(String serverName) throws LdapException {
        return new Client(this, serverName);
    }

    @Override
    public String getAuthenticationID() {
        return this.authenticationID;
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    public byte[] getPassword() {
        return this.password;
    }

    @Override
    public String getSASLMechanism() {
        return "PLAIN";
    }

    @Override
    public PlainSASLBindRequest setAuthenticationID(String authenticationID) {
        Reject.ifNull((Object)authenticationID);
        this.authenticationID = authenticationID;
        return this;
    }

    @Override
    public PlainSASLBindRequest setAuthorizationID(String authorizationID) {
        this.authorizationID = authorizationID;
        return this;
    }

    @Override
    public PlainSASLBindRequest setPassword(byte[] password) {
        Reject.ifNull((Object)password);
        this.password = password;
        return this;
    }

    @Override
    public PlainSASLBindRequest setPassword(char[] password) {
        Reject.ifNull((Object)password);
        this.password = StaticUtils.getBytes(password);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PlainSASLBindRequest(bindDN=");
        builder.append(this.getName());
        builder.append(", authentication=SASL");
        builder.append(", saslMechanism=");
        builder.append(this.getSASLMechanism());
        builder.append(", authenticationID=");
        builder.append(this.authenticationID);
        builder.append(", authorizationID=");
        builder.append(this.authorizationID);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class Client
    extends SASLBindClientImpl {
        private final String authenticationID;
        private final ByteString password;
        private final SaslClient saslClient;

        private Client(PlainSASLBindRequestImpl initialBindRequest, String serverName) throws LdapException {
            super(initialBindRequest);
            this.authenticationID = initialBindRequest.getAuthenticationID();
            this.password = ByteString.wrap(initialBindRequest.getPassword());
            try {
                this.saslClient = Sasl.createSaslClient(new String[]{"PLAIN"}, initialBindRequest.getAuthorizationID(), "ldap", serverName, null, this);
                if (this.saslClient.hasInitialResponse()) {
                    this.setNextSASLCredentials(this.saslClient.evaluateChallenge(new byte[0]));
                } else {
                    this.setNextSASLCredentials((ByteString)null);
                }
            }
            catch (SaslException e) {
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_LOCAL_ERROR, e);
            }
        }

        @Override
        public void dispose() {
            try {
                this.saslClient.dispose();
            }
            catch (SaslException saslException) {
                // empty catch block
            }
        }

        @Override
        public boolean evaluateResult(BindResult result) {
            return this.saslClient.isComplete();
        }

        @Override
        void handle(NameCallback callback) throws UnsupportedCallbackException {
            callback.setName(this.authenticationID);
        }

        @Override
        void handle(PasswordCallback callback) throws UnsupportedCallbackException {
            callback.setPassword(this.password.toString().toCharArray());
        }
    }
}

