/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.responses.AbstractResultImpl;
import org.forgerock.opendj.ldap.responses.ExtendedResult;

public abstract class AbstractExtendedResult<S extends ExtendedResult>
extends AbstractResultImpl<S>
implements ExtendedResult {
    protected AbstractExtendedResult(ExtendedResult extendedResult) {
        super(extendedResult);
    }

    protected AbstractExtendedResult(ResultCode resultCode) {
        super(resultCode);
    }

    @Override
    public abstract String getOID();

    @Override
    public abstract ByteString getValue();

    @Override
    public abstract boolean hasValue();

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExtendedResult(resultCode=");
        builder.append(this.getResultCode());
        builder.append(", matchedDN=");
        builder.append(this.getMatchedDN());
        builder.append(", diagnosticMessage=");
        builder.append(this.getDiagnosticMessage());
        builder.append(", referrals=");
        builder.append(this.getReferralURIs());
        builder.append(", responseName=");
        builder.append(this.getOID() == null ? "" : this.getOID());
        if (this.hasValue()) {
            builder.append(", responseValue=");
            builder.append(this.getValue().toHexPlusAsciiString(4));
        }
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    final S getThis() {
        return (S)this;
    }
}

