/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class IntegerFirstComponentEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();

    IntegerFirstComponentEqualityMatchingRuleImpl() {
        super("integerFirstComponentMatch");
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
        try {
            String definition = assertionValue.toString();
            return this.defaultAssertion(this.normalizeRuleID(new SubstringReader(definition)));
        }
        catch (Exception e) {
            logger.debug(LocalizableMessage.raw((CharSequence)"%s", (Object[])new Object[]{e}));
            throw DecodeException.error(CoreMessages.ERR_EMR_INTFIRSTCOMP_FIRST_COMPONENT_NOT_INT.get((Object)assertionValue));
        }
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String definition = value.toString();
        SubstringReader reader = new SubstringReader(definition);
        reader.skipWhitespaces();
        if (reader.remaining() <= 0) {
            throw DecodeException.error(CoreMessages.ERR_ATTR_SYNTAX_EMPTY_VALUE.get());
        }
        char c = reader.read();
        if (c != '(') {
            throw DecodeException.error(CoreMessages.ERR_ATTR_SYNTAX_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)Character.valueOf(c)));
        }
        reader.skipWhitespaces();
        return this.normalizeRuleID(reader);
    }

    private ByteString normalizeRuleID(SubstringReader reader) throws DecodeException {
        return ByteString.valueOfInt(SchemaUtils.readRuleID(reader));
    }
}

