/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class PrintableStringSyntaxImpl
extends AbstractSyntaxImpl {
    PrintableStringSyntaxImpl() {
    }

    static boolean isPrintableCharacter(char c) {
        switch (c) {
            case ' ': 
            case '\'': 
            case '(': 
            case ')': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case ':': 
            case '=': 
            case '?': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getApproximateMatchingRule() {
        return "1.3.6.1.4.1.26027.1.4.1";
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.2";
    }

    @Override
    public String getName() {
        return "PrintableString";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.3";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.4";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        if (value == null) {
            invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_PRINTABLE_STRING_EMPTY_VALUE.get());
            return false;
        }
        String valueString = value.toString();
        int valueLength = valueString.length();
        if (valueLength == 0) {
            invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_PRINTABLE_STRING_EMPTY_VALUE.get());
            return false;
        }
        for (int i = 0; i < valueLength; ++i) {
            char c = valueString.charAt(i);
            if (PrintableStringSyntaxImpl.isPrintableCharacter(c)) continue;
            invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_PRINTABLE_STRING_ILLEGAL_CHARACTER.get((Object)valueString, (Object)String.valueOf(c), (Object)i));
            return false;
        }
        return true;
    }
}

