/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.util.Reject;

abstract class SchemaElement {
    private String definition;
    private final String description;
    private final Map<String, List<String>> extraProperties;

    SchemaElement() {
        this.description = "";
        this.extraProperties = Collections.emptyMap();
        this.definition = null;
    }

    SchemaElement(SchemaElementBuilder<?> builder) {
        this.description = ((SchemaElementBuilder)builder).description;
        this.extraProperties = SchemaUtils.unmodifiableCopyOfExtraProperties(((SchemaElementBuilder)builder).extraProperties);
        this.definition = ((SchemaElementBuilder)builder).definition;
    }

    SchemaElement(String description, Map<String, List<String>> extraProperties, String definition) {
        Reject.ifNull((Object[])new Object[]{description, extraProperties});
        this.description = description;
        this.extraProperties = extraProperties;
        this.definition = definition;
    }

    public abstract boolean equals(Object var1);

    public final String getDescription() {
        return this.description;
    }

    public final Map<String, List<String>> getExtraProperties() {
        return this.extraProperties;
    }

    public abstract int hashCode();

    public final String toString() {
        if (this.definition == null) {
            this.definition = this.buildDefinition();
        }
        return this.definition;
    }

    final void appendDescription(StringBuilder buffer) {
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
    }

    abstract void toStringContent(StringBuilder var1);

    private final String buildDefinition() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("( ");
        this.toStringContent(buffer);
        if (!this.extraProperties.isEmpty()) {
            for (Map.Entry<String, List<String>> e : this.extraProperties.entrySet()) {
                String property = e.getKey();
                List<String> valueList = e.getValue();
                buffer.append(" ");
                buffer.append(property);
                if (valueList.size() == 1) {
                    buffer.append(" '");
                    buffer.append(valueList.get(0));
                    buffer.append("'");
                    continue;
                }
                buffer.append(" ( ");
                for (String value : valueList) {
                    buffer.append("'");
                    buffer.append(value);
                    buffer.append("' ");
                }
                buffer.append(")");
            }
        }
        buffer.append(" )");
        return buffer.toString();
    }

    static abstract class SchemaElementBuilder<T extends SchemaElementBuilder<T>> {
        private String definition;
        private String description;
        private final Map<String, List<String>> extraProperties;
        private final SchemaBuilder schemaBuilder;

        SchemaElementBuilder(SchemaBuilder schemaBuilder) {
            this.schemaBuilder = schemaBuilder;
            this.description = "";
            this.extraProperties = new LinkedHashMap<String, List<String>>(1);
        }

        SchemaElementBuilder(SchemaBuilder schemaBuilder, SchemaElement copy) {
            this.schemaBuilder = schemaBuilder;
            this.description = copy.description;
            this.extraProperties = new LinkedHashMap<String, List<String>>(copy.extraProperties);
        }

        public abstract T description(String var1);

        public abstract T extraProperties(Map<String, List<String>> var1);

        public abstract T extraProperties(String var1, String ... var2);

        public T extraProperties(String extensionName, List<String> extensionValues) {
            return this.extraProperties(extensionName, extensionValues.toArray(new String[extensionValues.size()]));
        }

        public abstract T removeAllExtraProperties();

        public abstract T removeExtraProperty(String var1, String ... var2);

        T definition(String definition) {
            this.definition = definition;
            return this.getThis();
        }

        T description0(String description) {
            this.description = description == null ? "" : description;
            return this.getThis();
        }

        T extraProperties0(Map<String, List<String>> extraProperties) {
            this.extraProperties.putAll(extraProperties);
            return this.getThis();
        }

        T extraProperties0(String extensionName, String ... extensionValues) {
            if (this.extraProperties.get(extensionName) != null) {
                ArrayList<String> tempExtraProperties = new ArrayList<String>((Collection)this.extraProperties.get(extensionName));
                tempExtraProperties.addAll(Arrays.asList(extensionValues));
                this.extraProperties.put(extensionName, tempExtraProperties);
            } else {
                this.extraProperties.put(extensionName, Arrays.asList(extensionValues));
            }
            return this.getThis();
        }

        String getDescription() {
            return this.description;
        }

        Map<String, List<String>> getExtraProperties() {
            return this.extraProperties;
        }

        SchemaBuilder getSchemaBuilder() {
            return this.schemaBuilder;
        }

        abstract T getThis();

        T removeAllExtraProperties0() {
            this.extraProperties.clear();
            return this.getThis();
        }

        T removeExtraProperty0(String extensionName, String ... extensionValues) {
            if (this.extraProperties.get(extensionName) != null && extensionValues.length > 0) {
                ArrayList tempExtraProperties = new ArrayList(this.extraProperties.get(extensionName));
                tempExtraProperties.removeAll(Arrays.asList(extensionValues));
                this.extraProperties.put(extensionName, tempExtraProperties);
            } else if (this.extraProperties.get(extensionName) != null) {
                this.extraProperties.remove(extensionName);
            }
            return this.getThis();
        }
    }
}

