/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class UniqueMemberEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    UniqueMemberEqualityMatchingRuleImpl() {
        super("uniqueMemberMatch");
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String stringValue = value.toString().trim();
        int dnEndPosition = stringValue.length();
        String optionalUid = "";
        int sharpPosition = -1;
        if ((stringValue.endsWith("'B") || stringValue.endsWith("'b")) && (sharpPosition = stringValue.lastIndexOf("#'")) > 0) {
            dnEndPosition = sharpPosition;
            optionalUid = stringValue.substring(sharpPosition);
        }
        try {
            DN dn = DN.valueOf(stringValue.substring(0, dnEndPosition), schema.asNonStrictSchema());
            return new ByteStringBuilder().appendBytes(dn.toNormalizedByteString()).appendUtf8(optionalUid).toByteString();
        }
        catch (LocalizedIllegalArgumentException e) {
            throw DecodeException.error(e.getMessageObject());
        }
    }
}

