/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.UserPasswordSyntaxImpl;

final class UserPasswordExactEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    UserPasswordExactEqualityMatchingRuleImpl() {
        super("ds-mr-user-password-exact");
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        if (UserPasswordSyntaxImpl.isEncoded(value)) {
            StringBuilder builder = new StringBuilder(value.length());
            int closingBracePos = -1;
            for (int i = 1; i < value.length(); ++i) {
                if (value.byteAt(i) != 125) continue;
                closingBracePos = i;
                break;
            }
            ByteSequence seq1 = value.subSequence(0, closingBracePos + 1);
            ByteSequence seq2 = value.subSequence(closingBracePos + 1, value.length());
            StaticUtils.toLowerCase(seq1, builder);
            builder.append(seq2);
            return ByteString.valueOfUtf8(builder);
        }
        return value.toByteString();
    }

    @Override
    public String keyToHumanReadableString(ByteSequence key) {
        return key.toString();
    }
}

