/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.spi;

import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.spi.ResultLdapPromiseImpl;
import org.forgerock.util.promise.PromiseImpl;

public final class SearchResultLdapPromiseImpl
extends ResultLdapPromiseImpl<SearchRequest, Result>
implements SearchResultHandler {
    private SearchResultHandler searchResultHandler;
    private final boolean isPersistentSearch;

    SearchResultLdapPromiseImpl(PromiseImpl<Result, LdapException> impl, int requestID, SearchRequest request, SearchResultHandler resultHandler, IntermediateResponseHandler intermediateResponseHandler) {
        super(impl, requestID, request, intermediateResponseHandler);
        this.searchResultHandler = resultHandler;
        this.isPersistentSearch = request.containsControl("2.16.840.1.113730.3.4.3") || request.containsControl("1.2.840.113556.1.4.528");
    }

    @Override
    public boolean handleEntry(SearchResultEntry entry) {
        if (!this.isDone()) {
            this.updateTimestamp();
            if (this.searchResultHandler != null && !this.searchResultHandler.handleEntry(entry)) {
                this.searchResultHandler = null;
            }
        }
        return true;
    }

    @Override
    public boolean handleReference(SearchResultReference reference) {
        if (!this.isDone()) {
            this.updateTimestamp();
            if (this.searchResultHandler != null && !this.searchResultHandler.handleReference(reference)) {
                this.searchResultHandler = null;
            }
        }
        return true;
    }

    @Override
    Result newErrorResult(ResultCode resultCode, String diagnosticMessage, Throwable cause) {
        return Responses.newResult(resultCode).setDiagnosticMessage(diagnosticMessage).setCause(cause);
    }

    @Override
    public boolean checkForTimeout() {
        return !this.isPersistentSearch;
    }
}

