/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldif.AbstractLDIFWriter;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordVisitorWriter;
import org.forgerock.opendj.ldif.ChangeRecordWriter;
import org.forgerock.util.Reject;

public final class LDIFChangeRecordWriter
extends AbstractLDIFWriter
implements ChangeRecordWriter {
    public static String toString(ChangeRecord change) {
        StringWriter writer = new StringWriter(128);
        try {
            new LDIFChangeRecordWriter(writer).setAddUserFriendlyComments(true).writeChangeRecord(change).close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return writer.toString();
    }

    public LDIFChangeRecordWriter(List<String> ldifLines) {
        super(ldifLines);
    }

    public LDIFChangeRecordWriter(OutputStream out) {
        super(out);
    }

    public LDIFChangeRecordWriter(Writer writer) {
        super(writer);
    }

    @Override
    public void close() throws IOException {
        this.close0();
    }

    @Override
    public void flush() throws IOException {
        this.flush0();
    }

    public LDIFChangeRecordWriter setAddUserFriendlyComments(boolean addUserFriendlyComments) {
        this.addUserFriendlyComments = addUserFriendlyComments;
        return this;
    }

    public LDIFChangeRecordWriter setExcludeAllOperationalAttributes(boolean excludeOperationalAttributes) {
        this.excludeOperationalAttributes = excludeOperationalAttributes;
        return this;
    }

    public LDIFChangeRecordWriter setExcludeAllUserAttributes(boolean excludeUserAttributes) {
        this.excludeUserAttributes = excludeUserAttributes;
        return this;
    }

    public LDIFChangeRecordWriter setExcludeAttribute(AttributeDescription attributeDescription) {
        Reject.ifNull((Object)attributeDescription);
        this.excludeAttributes.add(attributeDescription);
        return this;
    }

    public LDIFChangeRecordWriter setExcludeBranch(DN excludeBranch) {
        Reject.ifNull((Object)excludeBranch);
        this.excludeBranches.add(excludeBranch);
        return this;
    }

    public LDIFChangeRecordWriter setIncludeAttribute(AttributeDescription attributeDescription) {
        Reject.ifNull((Object)attributeDescription);
        this.includeAttributes.add(attributeDescription);
        return this;
    }

    public LDIFChangeRecordWriter setIncludeBranch(DN includeBranch) {
        Reject.ifNull((Object)includeBranch);
        this.includeBranches.add(includeBranch);
        return this;
    }

    public LDIFChangeRecordWriter setWrapColumn(int wrapColumn) {
        this.wrapColumn = wrapColumn;
        return this;
    }

    @Override
    public LDIFChangeRecordWriter writeChangeRecord(AddRequest change) throws IOException {
        Reject.ifNull((Object)change);
        if (this.isBranchExcluded(change.getName())) {
            return this;
        }
        this.writeKeyAndValue((CharSequence)"dn", change.getName().toString());
        this.writeControls(change.getControls());
        this.writeLine("changetype: add");
        for (Attribute attribute : change.getAllAttributes()) {
            if (this.isAttributeExcluded(attribute.getAttributeDescription())) continue;
            String attributeDescription = attribute.getAttributeDescriptionAsString();
            for (ByteString value : attribute) {
                this.writeKeyAndValue((CharSequence)attributeDescription, value);
            }
        }
        this.impl.println();
        return this;
    }

    @Override
    public LDIFChangeRecordWriter writeChangeRecord(ChangeRecord change) throws IOException {
        Reject.ifNull((Object)change);
        if (this.isBranchExcluded(change.getName())) {
            return this;
        }
        IOException e = change.accept(ChangeRecordVisitorWriter.getInstance(), this);
        if (e != null) {
            throw e;
        }
        return this;
    }

    @Override
    public LDIFChangeRecordWriter writeChangeRecord(DeleteRequest change) throws IOException {
        Reject.ifNull((Object)change);
        if (this.isBranchExcluded(change.getName())) {
            return this;
        }
        this.writeKeyAndValue((CharSequence)"dn", change.getName().toString());
        this.writeControls(change.getControls());
        this.writeLine("changetype: delete");
        this.impl.println();
        return this;
    }

    @Override
    public LDIFChangeRecordWriter writeChangeRecord(ModifyDNRequest change) throws IOException {
        Reject.ifNull((Object)change);
        if (this.isBranchExcluded(change.getName())) {
            return this;
        }
        this.writeKeyAndValue((CharSequence)"dn", change.getName().toString());
        this.writeControls(change.getControls());
        if (change.getNewSuperior() != null) {
            this.writeLine("changetype: moddn");
        } else {
            this.writeLine("changetype: modrdn");
        }
        this.writeKeyAndValue((CharSequence)"newrdn", change.getNewRDN().toString());
        this.writeKeyAndValue((CharSequence)"deleteoldrdn", change.isDeleteOldRDN() ? "1" : "0");
        if (change.getNewSuperior() != null) {
            this.writeKeyAndValue((CharSequence)"newsuperior", change.getNewSuperior().toString());
        }
        this.impl.println();
        return this;
    }

    @Override
    public LDIFChangeRecordWriter writeChangeRecord(ModifyRequest change) throws IOException {
        Reject.ifNull((Object)change);
        if (change.getModifications().isEmpty()) {
            return this;
        }
        if (this.isBranchExcluded(change.getName())) {
            return this;
        }
        this.writeKeyAndValue((CharSequence)"dn", change.getName().toString());
        this.writeControls(change.getControls());
        this.writeLine("changetype: modify");
        for (Modification modification : change.getModifications()) {
            ModificationType type = modification.getModificationType();
            Attribute attribute = modification.getAttribute();
            String attributeDescription = attribute.getAttributeDescriptionAsString();
            if (this.isAttributeExcluded(attribute.getAttributeDescription())) continue;
            this.writeKeyAndValue((CharSequence)type.toString(), attributeDescription);
            for (ByteString value : attribute) {
                this.writeKeyAndValue((CharSequence)attributeDescription, value);
            }
            this.writeLine("-");
        }
        this.impl.println();
        return this;
    }

    @Override
    public LDIFChangeRecordWriter writeComment(CharSequence comment) throws IOException {
        this.writeComment0(comment);
        return this;
    }
}

