/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldif.TemplateFile;
import org.forgerock.util.Utils;

abstract class TemplateTag {
    TemplateTag() {
    }

    abstract String getName();

    abstract boolean allowedInBranch();

    void initializeForBranch(Schema schema, TemplateFile templateFile, TemplateFile.Branch branch, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
    }

    abstract void initializeForTemplate(Schema var1, TemplateFile var2, TemplateFile.Template var3, String[] var4, int var5, List<LocalizableMessage> var6) throws DecodeException;

    void initializeForParent(TemplateFile.TemplateEntry parentEntry) {
    }

    final boolean hasAttributeTypeInBranchOrTemplate(AttributeType attrType, TemplateFile.Branch branch, TemplateFile.Template template) {
        return branch != null && branch.hasAttribute(attrType) || template != null && template.hasAttribute(attrType);
    }

    abstract TagResult generateValue(TemplateFile.TemplateEntry var1, TemplateFile.TemplateValue var2);

    static class UnderscoreParentDNTag
    extends ParentTag {
        UnderscoreParentDNTag() {
        }

        @Override
        String getName() {
            return "_ParentDN";
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            DN parentDN = templateEntry.getParentDN();
            if (parentDN == null || parentDN.isRootDN()) {
                return TagResult.SUCCESS;
            }
            templateValue.append(parentDN.rdn());
            for (int i = 1; i < parentDN.size(); ++i) {
                templateValue.append("_");
                templateValue.append(parentDN.parent(i).rdn());
            }
            return TagResult.SUCCESS;
        }
    }

    static class UnderscoreDNTag
    extends DNTag {
        UnderscoreDNTag() {
        }

        @Override
        String getName() {
            return "_DN";
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            return this.generateValue(templateEntry, templateValue, "_");
        }
    }

    static class StaticTextTag
    extends TemplateTag {
        private String text = "";

        StaticTextTag() {
        }

        @Override
        String getName() {
            return "StaticText";
        }

        @Override
        boolean allowedInBranch() {
            return true;
        }

        @Override
        void initializeForBranch(Schema schema, TemplateFile templateFile, TemplateFile.Branch branch, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(arguments, lineNumber);
        }

        @Override
        void initializeForTemplate(Schema schema, TemplateFile templateFile, TemplateFile.Template template, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(arguments, lineNumber);
        }

        private void initialize(String[] arguments, int lineNumber) throws DecodeException {
            if (arguments.length != 1) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)1, (Object)arguments.length);
                throw DecodeException.fatalError(message);
            }
            this.text = arguments[0];
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            templateValue.append(this.text);
            return TagResult.SUCCESS;
        }
    }

    static class SequentialTag
    extends TemplateTag {
        private boolean resetOnNewParents = true;
        private int initialValue;
        private int nextValue;

        SequentialTag() {
        }

        @Override
        String getName() {
            return "Sequential";
        }

        @Override
        boolean allowedInBranch() {
            return true;
        }

        @Override
        void initializeForBranch(Schema schema, TemplateFile templateFile, TemplateFile.Branch branch, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(arguments, lineNumber);
        }

        @Override
        void initializeForTemplate(Schema schema, TemplateFile templateFile, TemplateFile.Template template, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(arguments, lineNumber);
        }

        private void initialize(String[] arguments, int lineNumber) throws DecodeException {
            if (arguments.length < 0 || arguments.length > 2) {
                throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_RANGE_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)0, (Object)2, (Object)arguments.length));
            }
            if (arguments.length > 0) {
                this.initializeValue(arguments[0], lineNumber);
                if (arguments.length > 1) {
                    this.initializeReset(arguments[1], lineNumber);
                }
            }
        }

        private void initializeReset(String resetValue, int lineNumber) throws DecodeException {
            if ("true".equalsIgnoreCase(resetValue)) {
                this.resetOnNewParents = true;
            } else if ("false".equalsIgnoreCase(resetValue)) {
                this.resetOnNewParents = false;
            } else {
                throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_PARSE_AS_BOOLEAN.get((Object)resetValue, (Object)this.getName(), (Object)lineNumber));
            }
        }

        private void initializeValue(String value, int lineNumber) throws DecodeException {
            try {
                this.initialValue = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_PARSE_AS_INTEGER.get((Object)value, (Object)this.getName(), (Object)lineNumber));
            }
            this.nextValue = this.initialValue;
        }

        @Override
        void initializeForParent(TemplateFile.TemplateEntry parentEntry) {
            if (this.resetOnNewParents) {
                this.nextValue = this.initialValue;
            }
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            templateValue.append(this.nextValue++);
            return TagResult.SUCCESS;
        }
    }

    static class RDNTag
    extends TemplateTag {
        RDNTag() {
        }

        @Override
        String getName() {
            return "RDN";
        }

        @Override
        boolean allowedInBranch() {
            return true;
        }

        @Override
        void initializeForBranch(Schema schema, TemplateFile templateFile, TemplateFile.Branch branch, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(arguments, lineNumber);
        }

        @Override
        void initializeForTemplate(Schema schema, TemplateFile templateFile, TemplateFile.Template template, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(arguments, lineNumber);
        }

        private void initialize(String[] arguments, int lineNumber) throws DecodeException {
            if (arguments.length != 0) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)0, (Object)arguments.length);
                throw DecodeException.fatalError(message);
            }
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            DN dn = templateEntry.getDN();
            if (dn != null && !dn.isRootDN()) {
                templateValue.append(dn.rdn());
            }
            return TagResult.SUCCESS;
        }
    }

    static class RandomTag
    extends TemplateTag {
        public static final char[] ALPHA_CHARS = "abcdefghijklmnopqrstuvwxyz".toCharArray();
        public static final char[] NUMERIC_CHARS = "01234567890".toCharArray();
        public static final char[] ALPHANUMERIC_CHARS = "abcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
        public static final char[] HEX_CHARS = "01234567890abcdef".toCharArray();
        public static final char[] BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz01234567890+/".toCharArray();
        public static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        private char[] characterSet;
        private DecimalFormat decimalFormat;
        private int lengthRange = 1;
        private int maxLength;
        private int minLength;
        private RandomType randomType;
        private long maxValue;
        private long minValue;
        private long valueRange = 1L;
        private Random random;

        RandomTag() {
        }

        @Override
        String getName() {
            return "Random";
        }

        @Override
        boolean allowedInBranch() {
            return true;
        }

        @Override
        void initializeForBranch(Schema schema, TemplateFile templateFile, TemplateFile.Branch branch, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(templateFile, arguments, lineNumber, warnings);
        }

        @Override
        void initializeForTemplate(Schema schema, TemplateFile templateFile, TemplateFile.Template template, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(templateFile, arguments, lineNumber, warnings);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void initialize(TemplateFile templateFile, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.random = templateFile.getRandom();
            if (arguments == null || arguments.length == 0) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_NO_RANDOM_TYPE_ARGUMENT.get((Object)lineNumber);
                throw DecodeException.fatalError(message);
            }
            int numArgs = arguments.length;
            String randomTypeString = arguments[0].toLowerCase();
            if ("alpha".equals(randomTypeString)) {
                this.characterSet = ALPHA_CHARS;
                this.decodeLength(arguments, 1, lineNumber, warnings);
                return;
            }
            if ("numeric".equals(randomTypeString)) {
                if (numArgs == 2) {
                    this.randomType = RandomType.CHARS_FIXED;
                    this.characterSet = NUMERIC_CHARS;
                    try {
                        this.minLength = Integer.parseInt(arguments[1]);
                        if (this.minLength < 0) {
                            LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INTEGER_BELOW_LOWER_BOUND.get((Object)this.minLength, (Object)0, (Object)this.getName(), (Object)lineNumber);
                            throw DecodeException.fatalError(message);
                        }
                        if (this.minLength != 0) return;
                        LocalizableMessage message = CoreMessages.WARN_ENTRY_GENERATOR_TAG_WARNING_EMPTY_VALUE.get((Object)lineNumber);
                        warnings.add(message);
                        return;
                    }
                    catch (NumberFormatException nfe) {
                        LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_PARSE_AS_INTEGER.get((Object)arguments[1], (Object)this.getName(), (Object)lineNumber);
                        throw DecodeException.fatalError(message, nfe);
                    }
                }
                if (numArgs != 3 && numArgs != 4) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_RANGE_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)2, (Object)4, (Object)numArgs);
                    throw DecodeException.fatalError(message);
                }
                this.randomType = RandomType.NUMERIC;
                if (numArgs == 4) {
                    try {
                        this.decimalFormat = new DecimalFormat(arguments[3]);
                    }
                    catch (Exception e) {
                        LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_FORMAT_STRING.get((Object)arguments[3], (Object)this.getName(), (Object)lineNumber);
                        throw DecodeException.fatalError(message, e);
                    }
                } else {
                    this.decimalFormat = null;
                }
                try {
                    this.minValue = Long.parseLong(arguments[1]);
                }
                catch (NumberFormatException nfe) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_PARSE_AS_INTEGER.get((Object)arguments[1], (Object)this.getName(), (Object)lineNumber);
                    throw DecodeException.fatalError(message, nfe);
                }
                try {
                    this.maxValue = Long.parseLong(arguments[2]);
                    if (this.maxValue < this.minValue) {
                        LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INTEGER_BELOW_LOWER_BOUND.get((Object)this.maxValue, (Object)this.minValue, (Object)this.getName(), (Object)lineNumber);
                        throw DecodeException.fatalError(message);
                    }
                    this.valueRange = this.maxValue - this.minValue + 1L;
                    return;
                }
                catch (NumberFormatException nfe) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_PARSE_AS_INTEGER.get((Object)arguments[2], (Object)this.getName(), (Object)lineNumber);
                    throw DecodeException.fatalError(message, nfe);
                }
            }
            if ("alphanumeric".equals(randomTypeString)) {
                this.characterSet = ALPHANUMERIC_CHARS;
                this.decodeLength(arguments, 1, lineNumber, warnings);
                return;
            }
            if ("chars".equals(randomTypeString)) {
                if (numArgs >= 3 && numArgs <= 4) {
                    this.characterSet = arguments[1].toCharArray();
                    this.decodeLength(arguments, 2, lineNumber, warnings);
                    return;
                }
                LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_RANGE_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)3, (Object)4, (Object)numArgs);
                throw DecodeException.fatalError(message);
            }
            if ("hex".equals(randomTypeString)) {
                this.characterSet = HEX_CHARS;
                this.decodeLength(arguments, 1, lineNumber, warnings);
                return;
            }
            if ("base64".equals(randomTypeString)) {
                this.characterSet = BASE64_CHARS;
                this.decodeLength(arguments, 1, lineNumber, warnings);
                return;
            }
            if ("month".equals(randomTypeString)) {
                this.randomType = RandomType.MONTH;
                if (numArgs == 1) {
                    this.maxLength = 0;
                    return;
                }
                if (numArgs != 2) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_RANGE_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)1, (Object)2, (Object)numArgs);
                    throw DecodeException.fatalError(message);
                }
                try {
                    this.maxLength = Integer.parseInt(arguments[1]);
                    if (this.maxLength > 0) return;
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INTEGER_BELOW_LOWER_BOUND.get((Object)this.maxLength, (Object)1, (Object)this.getName(), (Object)lineNumber);
                    throw DecodeException.fatalError(message);
                }
                catch (NumberFormatException nfe) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_PARSE_AS_INTEGER.get((Object)arguments[1], (Object)this.getName(), (Object)lineNumber);
                    throw DecodeException.fatalError(message, nfe);
                }
            }
            if ("telephone".equals(randomTypeString)) {
                this.randomType = RandomType.TELEPHONE;
                return;
            }
            LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_UNKNOWN_RANDOM_TYPE.get((Object)lineNumber, (Object)randomTypeString);
            throw DecodeException.fatalError(message);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void decodeLength(String[] arguments, int startPos, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            int numArgs = arguments.length - startPos + 1;
            if (numArgs == 2) {
                this.randomType = RandomType.CHARS_FIXED;
                try {
                    this.minLength = Integer.parseInt(arguments[startPos]);
                    if (this.minLength < 0) {
                        LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INTEGER_BELOW_LOWER_BOUND.get((Object)this.minLength, (Object)0, (Object)this.getName(), (Object)lineNumber);
                        throw DecodeException.fatalError(message);
                    }
                    if (this.minLength != 0) return;
                    LocalizableMessage message = CoreMessages.WARN_ENTRY_GENERATOR_TAG_WARNING_EMPTY_VALUE.get((Object)lineNumber);
                    warnings.add(message);
                    return;
                }
                catch (NumberFormatException nfe) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_PARSE_AS_INTEGER.get((Object)arguments[startPos], (Object)this.getName(), (Object)lineNumber);
                    throw DecodeException.fatalError(message, nfe);
                }
            }
            if (numArgs == 3) {
                this.randomType = RandomType.CHARS_VARIABLE;
                try {
                    this.minLength = Integer.parseInt(arguments[startPos]);
                    if (this.minLength < 0) {
                        LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INTEGER_BELOW_LOWER_BOUND.get((Object)this.minLength, (Object)0, (Object)this.getName(), (Object)lineNumber);
                        throw DecodeException.fatalError(message);
                    }
                }
                catch (NumberFormatException nfe) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_PARSE_AS_INTEGER.get((Object)arguments[startPos], (Object)this.getName(), (Object)lineNumber);
                    throw DecodeException.fatalError(message, nfe);
                }
                try {
                    this.maxLength = Integer.parseInt(arguments[startPos + 1]);
                    this.lengthRange = this.maxLength - this.minLength + 1;
                    if (this.maxLength < this.minLength) {
                        LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INTEGER_BELOW_LOWER_BOUND.get((Object)this.maxLength, (Object)this.minLength, (Object)this.getName(), (Object)lineNumber);
                        throw DecodeException.fatalError(message);
                    }
                    if (this.maxLength != 0) return;
                    LocalizableMessage message = CoreMessages.WARN_ENTRY_GENERATOR_TAG_WARNING_EMPTY_VALUE.get((Object)lineNumber);
                    warnings.add(message);
                    return;
                }
                catch (NumberFormatException nfe) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_PARSE_AS_INTEGER.get((Object)arguments[startPos + 1], (Object)this.getName(), (Object)lineNumber);
                    throw DecodeException.fatalError(message, nfe);
                }
            }
            LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_RANGE_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)(startPos + 1), (Object)(startPos + 2), (Object)numArgs);
            throw DecodeException.fatalError(message);
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            switch (this.randomType) {
                case CHARS_FIXED: {
                    for (int i = 0; i < this.minLength; ++i) {
                        templateValue.append(Character.valueOf(this.characterSet[this.random.nextInt(this.characterSet.length)]));
                    }
                    break;
                }
                case CHARS_VARIABLE: {
                    int numChars = this.random.nextInt(this.lengthRange) + this.minLength;
                    for (int i = 0; i < numChars; ++i) {
                        templateValue.append(Character.valueOf(this.characterSet[this.random.nextInt(this.characterSet.length)]));
                    }
                    break;
                }
                case NUMERIC: {
                    long randomValue = (this.random.nextLong() & Long.MAX_VALUE) % this.valueRange + this.minValue;
                    if (this.decimalFormat != null) {
                        templateValue.append(this.decimalFormat.format(randomValue));
                        break;
                    }
                    templateValue.append(randomValue);
                    break;
                }
                case MONTH: {
                    String month = MONTHS[this.random.nextInt(MONTHS.length)];
                    if (this.maxLength == 0 || month.length() <= this.maxLength) {
                        templateValue.append(month);
                        break;
                    }
                    templateValue.append(month.substring(0, this.maxLength));
                    break;
                }
                case TELEPHONE: {
                    int i;
                    templateValue.append("+1 ");
                    for (i = 0; i < 3; ++i) {
                        templateValue.append(Character.valueOf(NUMERIC_CHARS[this.random.nextInt(NUMERIC_CHARS.length)]));
                    }
                    templateValue.append(Character.valueOf(' '));
                    for (i = 0; i < 3; ++i) {
                        templateValue.append(Character.valueOf(NUMERIC_CHARS[this.random.nextInt(NUMERIC_CHARS.length)]));
                    }
                    templateValue.append(Character.valueOf(' '));
                    for (i = 0; i < 4; ++i) {
                        templateValue.append(Character.valueOf(NUMERIC_CHARS[this.random.nextInt(NUMERIC_CHARS.length)]));
                    }
                    break;
                }
            }
            return TagResult.SUCCESS;
        }

        static enum RandomType {
            CHARS_FIXED,
            CHARS_VARIABLE,
            NUMERIC,
            MONTH,
            TELEPHONE;

        }
    }

    static class PresenceTag
    extends TemplateTag {
        private int percentage;
        private Random random;

        PresenceTag() {
        }

        @Override
        String getName() {
            return "Presence";
        }

        @Override
        boolean allowedInBranch() {
            return true;
        }

        @Override
        void initializeForBranch(Schema schema, TemplateFile templateFile, TemplateFile.Branch branch, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(templateFile, arguments, lineNumber);
        }

        @Override
        void initializeForTemplate(Schema schema, TemplateFile templateFile, TemplateFile.Template template, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(templateFile, arguments, lineNumber);
        }

        private void initialize(TemplateFile templateFile, String[] arguments, int lineNumber) throws DecodeException {
            this.random = templateFile.getRandom();
            if (arguments.length != 1) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)1, (Object)arguments.length);
                throw DecodeException.fatalError(message);
            }
            try {
                this.percentage = Integer.parseInt(arguments[0]);
                if (this.percentage < 0) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INTEGER_BELOW_LOWER_BOUND.get((Object)this.percentage, (Object)0, (Object)this.getName(), (Object)lineNumber);
                    throw DecodeException.fatalError(message);
                }
                if (this.percentage > 100) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INTEGER_ABOVE_UPPER_BOUND.get((Object)this.percentage, (Object)100, (Object)this.getName(), (Object)lineNumber);
                    throw DecodeException.fatalError(message);
                }
            }
            catch (NumberFormatException nfe) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_PARSE_AS_INTEGER.get((Object)arguments[0], (Object)this.getName(), (Object)lineNumber);
                throw DecodeException.fatalError(message);
            }
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            int intValue = this.random.nextInt(100);
            if (intValue < this.percentage) {
                return TagResult.SUCCESS;
            }
            return TagResult.FAILURE;
        }
    }

    static class ParentDNTag
    extends ParentTag {
        ParentDNTag() {
        }

        @Override
        String getName() {
            return "ParentDN";
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            DN parentDN = templateEntry.getParentDN();
            if (parentDN == null || parentDN.isRootDN()) {
                return TagResult.SUCCESS;
            }
            templateValue.append(parentDN);
            return TagResult.SUCCESS;
        }
    }

    static abstract class ParentTag
    extends TemplateTag {
        ParentTag() {
        }

        @Override
        final boolean allowedInBranch() {
            return false;
        }

        @Override
        final void initializeForTemplate(Schema schema, TemplateFile templateFile, TemplateFile.Template template, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            if (arguments.length != 0) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)0, (Object)arguments.length);
                throw DecodeException.fatalError(message);
            }
        }
    }

    static abstract class NameTag
    extends TemplateTag {
        TemplateFile templateFile;

        NameTag() {
        }

        @Override
        final boolean allowedInBranch() {
            return false;
        }

        @Override
        final void initializeForTemplate(Schema schema, TemplateFile templateFile, TemplateFile.Template template, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.templateFile = templateFile;
            if (arguments.length != 0) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)0, (Object)arguments.length);
                throw DecodeException.fatalError(message);
            }
        }
    }

    static class ListTag
    extends TemplateTag {
        private int cumulativeWeight;
        private int[] valueWeights;
        private String[] valueStrings;
        private Random random;

        ListTag() {
        }

        @Override
        String getName() {
            return "List";
        }

        @Override
        boolean allowedInBranch() {
            return true;
        }

        @Override
        void initializeForBranch(Schema schema, TemplateFile templateFile, TemplateFile.Branch branch, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(templateFile, arguments, lineNumber, warnings);
        }

        @Override
        void initializeForTemplate(Schema schema, TemplateFile templateFile, TemplateFile.Template template, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(templateFile, arguments, lineNumber, warnings);
        }

        private void initialize(TemplateFile templateFile, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            if (arguments.length == 0) {
                throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_TAG_LIST_NO_ARGUMENTS.get((Object)lineNumber));
            }
            this.valueStrings = new String[arguments.length];
            this.valueWeights = new int[arguments.length];
            this.cumulativeWeight = 0;
            this.random = templateFile.getRandom();
            for (int i = 0; i < arguments.length; ++i) {
                String value = arguments[i];
                int weight = 1;
                int semicolonPos = value.lastIndexOf(59);
                if (semicolonPos >= 0) {
                    try {
                        weight = Integer.parseInt(value.substring(semicolonPos + 1));
                        value = value.substring(0, semicolonPos);
                    }
                    catch (NumberFormatException e) {
                        warnings.add(CoreMessages.WARN_ENTRY_GENERATOR_TAG_LIST_INVALID_WEIGHT.get((Object)lineNumber, (Object)value));
                    }
                }
                this.cumulativeWeight += weight;
                this.valueStrings[i] = value;
                this.valueWeights[i] = this.cumulativeWeight;
            }
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            int selectedWeight = this.random.nextInt(this.cumulativeWeight) + 1;
            for (int i = 0; i < this.valueWeights.length; ++i) {
                if (selectedWeight > this.valueWeights[i]) continue;
                templateValue.append(this.valueStrings[i]);
                break;
            }
            return TagResult.SUCCESS;
        }
    }

    static class LastNameTag
    extends NameTag {
        LastNameTag() {
        }

        @Override
        String getName() {
            return "Last";
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            templateValue.append(this.templateFile.getLastName());
            return TagResult.SUCCESS;
        }
    }

    static class IfPresentTag
    extends IfTag {
        IfPresentTag() {
        }

        @Override
        String getName() {
            return "IfPresent";
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            List<TemplateFile.TemplateValue> values = templateEntry.getValues(this.attributeType);
            if (values == null || values.isEmpty()) {
                return TagResult.FAILURE;
            }
            if (this.assertionValue == null) {
                return TagResult.SUCCESS;
            }
            for (TemplateFile.TemplateValue v : values) {
                if (!this.assertionValue.equals(v.getValueAsString())) continue;
                return TagResult.SUCCESS;
            }
            return TagResult.FAILURE;
        }
    }

    static class IfAbsentTag
    extends IfTag {
        IfAbsentTag() {
        }

        @Override
        String getName() {
            return "IfAbsent";
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            List<TemplateFile.TemplateValue> values = templateEntry.getValues(this.attributeType);
            if (values == null) {
                return TagResult.SUCCESS;
            }
            if (this.assertionValue == null) {
                return TagResult.FAILURE;
            }
            for (TemplateFile.TemplateValue v : values) {
                if (!this.assertionValue.equals(v.getValueAsString())) continue;
                return TagResult.FAILURE;
            }
            return TagResult.SUCCESS;
        }
    }

    static abstract class IfTag
    extends TemplateTag {
        AttributeType attributeType;
        String assertionValue;

        IfTag() {
        }

        @Override
        final boolean allowedInBranch() {
            return true;
        }

        @Override
        final void initializeForBranch(Schema schema, TemplateFile templateFile, TemplateFile.Branch branch, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(schema, branch, null, arguments, lineNumber);
        }

        @Override
        final void initializeForTemplate(Schema schema, TemplateFile templateFile, TemplateFile.Template template, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(schema, null, template, arguments, lineNumber);
        }

        private void initialize(Schema schema, TemplateFile.Branch branch, TemplateFile.Template template, String[] arguments, int lineNumber) throws DecodeException {
            if (arguments.length < 1 || arguments.length > 2) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_RANGE_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)1, (Object)2, (Object)arguments.length);
                throw DecodeException.fatalError(message);
            }
            this.attributeType = schema.getAttributeType(arguments[0].toLowerCase());
            if (!this.hasAttributeTypeInBranchOrTemplate(this.attributeType, branch, template)) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_UNDEFINED_ATTRIBUTE.get((Object)arguments[0], (Object)lineNumber);
                throw DecodeException.fatalError(message);
            }
            this.assertionValue = arguments.length == 2 ? arguments[1] : null;
        }
    }

    static class GUIDTag
    extends TemplateTag {
        GUIDTag() {
        }

        @Override
        String getName() {
            return "GUID";
        }

        @Override
        boolean allowedInBranch() {
            return true;
        }

        @Override
        void initializeForBranch(Schema schema, TemplateFile templateFile, TemplateFile.Branch branch, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(arguments, lineNumber);
        }

        @Override
        void initializeForTemplate(Schema schema, TemplateFile templateFile, TemplateFile.Template template, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(arguments, lineNumber);
        }

        private void initialize(String[] arguments, int lineNumber) throws DecodeException {
            if (arguments.length != 0) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)0, (Object)arguments.length);
                throw DecodeException.fatalError(message);
            }
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            templateValue.append(UUID.randomUUID().toString());
            return TagResult.SUCCESS;
        }
    }

    static class FirstNameTag
    extends NameTag {
        FirstNameTag() {
        }

        @Override
        String getName() {
            return "First";
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            templateValue.append(this.templateFile.getFirstName());
            return TagResult.SUCCESS;
        }
    }

    static class FileTag
    extends TemplateTag {
        private boolean isSequential;
        private int nextIndex;
        private Random random;
        private String[] fileLines;

        FileTag() {
        }

        @Override
        String getName() {
            return "File";
        }

        @Override
        boolean allowedInBranch() {
            return true;
        }

        @Override
        void initializeForBranch(Schema schema, TemplateFile templateFile, TemplateFile.Branch branch, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(templateFile, arguments, lineNumber);
        }

        @Override
        void initializeForTemplate(Schema schema, TemplateFile templateFile, TemplateFile.Template template, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(templateFile, arguments, lineNumber);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void initialize(TemplateFile templateFile, String[] arguments, int lineNumber) throws DecodeException {
            this.random = templateFile.getRandom();
            if (arguments.length < 1 || arguments.length > 2) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_RANGE_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)1, (Object)2, (Object)arguments.length);
                throw DecodeException.fatalError(message);
            }
            String filePath = arguments[0];
            BufferedReader dataReader = null;
            try {
                dataReader = templateFile.getReader(filePath);
                if (dataReader == null) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_FIND_FILE.get((Object)filePath, (Object)this.getName(), (Object)lineNumber);
                    throw DecodeException.fatalError(message);
                }
                try {
                    this.fileLines = templateFile.getLines(filePath, dataReader);
                }
                catch (IOException ioe) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_READ_FILE.get((Object)filePath, (Object)this.getName(), (Object)lineNumber, (Object)String.valueOf(ioe));
                    throw DecodeException.fatalError(message, ioe);
                }
            }
            catch (Throwable throwable) {
                Utils.closeSilently((Closeable[])new Closeable[]{dataReader});
                throw throwable;
            }
            Utils.closeSilently((Closeable[])new Closeable[]{dataReader});
            if (arguments.length == 2) {
                if ("sequential".equalsIgnoreCase(arguments[1])) {
                    this.isSequential = true;
                    this.nextIndex = 0;
                    return;
                } else {
                    if (!"random".equalsIgnoreCase(arguments[1])) throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_FILE_ACCESS_MODE.get((Object)arguments[1], (Object)this.getName(), (Object)lineNumber));
                    this.isSequential = false;
                }
                return;
            } else {
                this.isSequential = false;
            }
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            if (this.isSequential) {
                templateValue.append(this.fileLines[this.nextIndex++]);
                if (this.nextIndex >= this.fileLines.length) {
                    this.nextIndex = 0;
                }
            } else {
                templateValue.append(this.fileLines[this.random.nextInt(this.fileLines.length)]);
            }
            return TagResult.SUCCESS;
        }
    }

    static class DNTag
    extends TemplateTag {
        private int numComponents;

        DNTag() {
        }

        @Override
        String getName() {
            return "DN";
        }

        @Override
        final boolean allowedInBranch() {
            return true;
        }

        @Override
        final void initializeForBranch(Schema schema, TemplateFile templateFile, TemplateFile.Branch branch, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(arguments, lineNumber);
        }

        @Override
        final void initializeForTemplate(Schema schema, TemplateFile templateFile, TemplateFile.Template template, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(arguments, lineNumber);
        }

        private void initialize(String[] arguments, int lineNumber) throws DecodeException {
            if (arguments.length == 0) {
                this.numComponents = 0;
            } else if (arguments.length == 1) {
                try {
                    this.numComponents = Integer.parseInt(arguments[0]);
                }
                catch (NumberFormatException nfe) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_PARSE_AS_INTEGER.get((Object)arguments[0], (Object)this.getName(), (Object)lineNumber);
                    throw DecodeException.fatalError(message);
                }
            } else {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_RANGE_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)0, (Object)1, (Object)arguments.length);
                throw DecodeException.fatalError(message);
            }
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            return this.generateValue(templateEntry, templateValue, ",");
        }

        final TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue, String separator) {
            DN dn = templateEntry.getDN();
            if (dn == null || dn.isRootDN()) {
                return TagResult.SUCCESS;
            }
            String dnAsString = "";
            dnAsString = this.numComponents == 0 ? dn.toString() : (this.numComponents > 0 ? dn.localName(this.numComponents).toString() : dn.parent(dn.size() - Math.abs(this.numComponents)).toString());
            if (!separator.equals(",")) {
                dnAsString = dnAsString.replaceAll(",", separator);
            }
            templateValue.append(dnAsString);
            return TagResult.SUCCESS;
        }
    }

    static class AttributeValueTag
    extends TemplateTag {
        private AttributeType attributeType = null;
        private int numCharacters = 0;

        AttributeValueTag() {
        }

        @Override
        String getName() {
            return "AttributeValue";
        }

        @Override
        boolean allowedInBranch() {
            return true;
        }

        @Override
        void initializeForBranch(Schema schema, TemplateFile templateFile, TemplateFile.Branch branch, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(schema, branch, null, arguments, lineNumber);
        }

        @Override
        void initializeForTemplate(Schema schema, TemplateFile templateFile, TemplateFile.Template template, String[] arguments, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
            this.initialize(schema, null, template, arguments, lineNumber);
        }

        private void initialize(Schema schema, TemplateFile.Branch branch, TemplateFile.Template template, String[] arguments, int lineNumber) throws DecodeException {
            block6: {
                if (arguments.length < 1 || arguments.length > 2) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INVALID_ARGUMENT_RANGE_COUNT.get((Object)this.getName(), (Object)lineNumber, (Object)1, (Object)2, (Object)arguments.length);
                    throw DecodeException.fatalError(message);
                }
                this.attributeType = schema.getAttributeType(arguments[0].toLowerCase());
                if (!this.hasAttributeTypeInBranchOrTemplate(this.attributeType, branch, template)) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_UNDEFINED_ATTRIBUTE.get((Object)arguments[0], (Object)lineNumber);
                    throw DecodeException.fatalError(message);
                }
                if (arguments.length == 2) {
                    try {
                        this.numCharacters = Integer.parseInt(arguments[1]);
                        if (this.numCharacters < 0) {
                            LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_INTEGER_BELOW_LOWER_BOUND.get((Object)this.numCharacters, (Object)0, (Object)this.getName(), (Object)lineNumber);
                            throw DecodeException.fatalError(message);
                        }
                        break block6;
                    }
                    catch (NumberFormatException nfe) {
                        LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_TAG_CANNOT_PARSE_AS_INTEGER.get((Object)arguments[1], (Object)this.getName(), (Object)lineNumber);
                        throw DecodeException.fatalError(message);
                    }
                }
                this.numCharacters = 0;
            }
        }

        @Override
        TagResult generateValue(TemplateFile.TemplateEntry templateEntry, TemplateFile.TemplateValue templateValue) {
            TemplateFile.TemplateValue value = templateEntry.getValue(this.attributeType);
            if (value == null) {
                return TagResult.SUCCESS;
            }
            if (this.numCharacters > 0) {
                String valueString = value.getValueAsString();
                if (valueString.length() > this.numCharacters) {
                    templateValue.append(valueString.substring(0, this.numCharacters));
                } else {
                    templateValue.append(valueString);
                }
            } else {
                templateValue.append(value.getValueAsString());
            }
            return TagResult.SUCCESS;
        }
    }

    static enum TagResult {
        SUCCESS,
        FAILURE;

    }
}

