---
title: "Design Doc - ${title} - Use Cases"
sidebar: gerritdoc_sidebar
permalink: design-doc-${folder-name}-use-cases.html
hide_sidebar: true
hide_navtoggle: true
toc: false
folder: design-docs/${folder-name}
---

# Use Cases

In a few sentences, describe the use-cases as interactions between a
user and a system to attain particular goals.

Should be understandable by anyone who is familiar with using Gerrit.

Optionally, differentiate between primary and secondary use-cases.
Secondary use-cases are related to the primary use-cases, but
addressing them within the scope of this design is not mandatory. This
means they may not be covered by all proposed solutions. Secondary
use-cases that are not addressed by the concluded solution, may be
discussed in separate design docs. In this case links to these design
docs should be added here.

Optionally, define non-goals.

It is possible that use-cases are specific to custom setups (e.g. the
multi-master setup at Google). In this case, say so here.

## <a id="acceptance-criteria"> Acceptance Criteria

Describe conditions that must be satisfied to consider the feature as
done.

If a mentor is assigned, the mentorship ends when this state is reached.
Please note that a mentorship can also end earlier if the maximum time
frame for the mentorship has exceeded (see section 'Time Estimation'
in dev-design-doc-conclusion-template.txt).

## <a id="background"> Background

Stuff one needs to know to understand the use-cases (e.g. motivating
examples, previous versions and problems, links to related
changes/design docs, etc.).

Note: this is background; do not write about your design or ideas to
solve problems here.
