// Copyright (C) 2017 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.gerrit.extensions.api.projects;

import com.google.common.collect.Lists;
import java.util.List;

/** Commits that will forbidden to be uploaded. */
public class BanCommitInput {
  public List<String> commits;
  public String reason;

  public static BanCommitInput fromCommits(String firstCommit, String... moreCommits) {
    return fromCommits(Lists.asList(firstCommit, moreCommits));
  }

  public static BanCommitInput fromCommits(List<String> commits) {
    BanCommitInput in = new BanCommitInput();
    in.commits = commits;
    return in;
  }
}
