// Copyright (C) 2009 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.gerrit.httpd;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.servlet.RequestScoped;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;

@RequestScoped
class HttpRemotePeerProvider implements Provider<SocketAddress> {
  private final HttpServletRequest req;

  @Inject
  HttpRemotePeerProvider(HttpServletRequest r) {
    req = r;
  }

  @Override
  public SocketAddress get() {
    final String addr = req.getRemoteAddr();
    final int port = req.getRemotePort();
    try {
      return new InetSocketAddress(InetAddress.getByName(addr), port);
    } catch (UnknownHostException e) {
      throw new ProvisionException("Cannot get @RemotePeer", e);
    }
  }
}
