// Copyright (C) 2017 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.gerrit.server.project;

import com.google.gerrit.entities.Project;
import java.util.concurrent.locks.Lock;

/**
 * A per-repo lock mechanism.
 *
 * <p>This ensures that project creation (repo creation, config creation, first commit) is atomic,
 * and can be used to separate creation and deletion in the delete-project plugin.
 *
 * <p>This is an interface because distributed setup may need something beyond an in-memory lock.
 */
public interface ProjectNameLockManager {
  public Lock getLock(Project.NameKey name);
}
