/**
 * @license
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import {html} from '@polymer/polymer/lib/utils/html-tag';

export const htmlTemplate = html`
  <style include="shared-styles">
    :host {
      display: block;
      margin-bottom: var(--spacing-m);
    }
    .header {
      align-items: baseline;
      display: flex;
      justify-content: space-between;
      margin: var(--spacing-s) var(--spacing-m);
    }
    .rules {
      background: var(--table-header-background-color);
      border: 1px solid var(--border-color);
      border-bottom: 0;
    }
    .editing .rules {
      border-bottom: 1px solid var(--border-color);
    }
    .title {
      margin-bottom: var(--spacing-s);
    }
    #addRule,
    #removeBtn {
      display: none;
    }
    .right {
      display: flex;
      align-items: center;
    }
    .editing #removeBtn {
      display: block;
      margin-left: var(--spacing-xl);
    }
    .editing #addRule {
      display: block;
      padding: var(--spacing-m);
    }
    #deletedContainer,
    .deleted #mainContainer {
      display: none;
    }
    .deleted #deletedContainer {
      align-items: baseline;
      border: 1px solid var(--border-color);
      display: flex;
      justify-content: space-between;
      padding: var(--spacing-m);
    }
    #mainContainer {
      display: block;
    }
  </style>
  <style include="gr-form-styles">
    /* Workaround for empty style block - see https://github.com/Polymer/tools/issues/408 */
  </style>
  <style include="gr-menu-page-styles">
    /* Workaround for empty style block - see https://github.com/Polymer/tools/issues/408 */
  </style>
  <section
    id="permission"
    class$="gr-form-styles [[_computeSectionClass(editing, _deleted)]]"
  >
    <div id="mainContainer">
      <div class="header">
        <span class="title">[[name]]</span>
        <div class="right">
          <template
            is="dom-if"
            if="[[!_permissionIsOwnerOrGlobal(permission.id, section)]]"
          >
            <paper-toggle-button
              id="exclusiveToggle"
              checked="{{permission.value.exclusive}}"
              on-change="_handleValueChange"
              disabled$="[[!editing]]"
              on-click="_onTapExclusiveToggle"
            ></paper-toggle-button
            >Exclusive
          </template>
          <gr-button link="" id="removeBtn" on-click="_handleRemovePermission"
            >Remove</gr-button
          >
        </div>
      </div>
      <!-- end header -->
      <div class="rules">
        <template is="dom-repeat" items="{{_rules}}" as="rule">
          <gr-rule-editor
            has-range="[[_computeHasRange(name)]]"
            label="[[_label]]"
            editing="[[editing]]"
            group-id="[[rule.id]]"
            group-name="[[_computeGroupName(groups, rule.id)]]"
            permission="[[permission.id]]"
            rule="{{rule}}"
            section="[[section]]"
            on-added-rule-removed="_handleAddedRuleRemoved"
          ></gr-rule-editor>
        </template>
        <div id="addRule">
          <gr-autocomplete
            id="groupAutocomplete"
            text="{{_groupFilter}}"
            query="[[_query]]"
            placeholder="Add group"
            on-commit="_handleAddRuleItem"
          >
          </gr-autocomplete>
        </div>
        <!-- end addRule -->
      </div>
      <!-- end rules -->
    </div>
    <!-- end mainContainer -->
    <div id="deletedContainer">
      <span>[[name]] was deleted</span>
      <gr-button link="" id="undoRemoveBtn" on-click="_handleUndoRemove"
        >Undo</gr-button
      >
    </div>
    <!-- end deletedContainer -->
  </section>
`;
