/**
 * @license
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This plugin will +1 on Code-Review label if it detects that you have
 * LGTM as start of your reply.
 */
Gerrit.install(plugin => {
  const replyApi = plugin.changeReply();
  replyApi.addReplyTextChangedCallback(text => {
    const label = 'Code-Review';
    const labelValue = replyApi.getLabelValue(label);
    if (labelValue &&
      labelValue === ' 0' &&
      text.indexOf('LGTM') === 0) {
      replyApi.setLabelValue(label, '+1');
    }
  });
});
