/*
 * Decompiled with CFR 0.152.
 */
package com.marswin89.marsdaemon.strategy;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Process;
import android.os.SystemClock;
import com.marswin89.marsdaemon.DaemonConfigurations;
import com.marswin89.marsdaemon.IDaemonStrategy;
import com.marswin89.marsdaemon.nativ.NativeDaemonAPI21;
import java.io.File;
import java.io.IOException;

public class DaemonStrategy21
implements IDaemonStrategy {
    private static final String INDICATOR_DIR_NAME = "indicators";
    private static final String INDICATOR_PERSISTENT_FILENAME = "indicator_p";
    private static final String INDICATOR_DAEMON_ASSISTANT_FILENAME = "indicator_d";
    private static final String OBSERVER_PERSISTENT_FILENAME = "observer_p";
    private static final String OBSERVER_DAEMON_ASSISTANT_FILENAME = "observer_d";
    private AlarmManager mAlarmManager;
    private PendingIntent mPendingIntent;
    private DaemonConfigurations mConfigs;

    @Override
    public boolean onInitialization(Context context) {
        return this.initIndicators(context);
    }

    @Override
    public void onPersistentCreate(final Context context, DaemonConfigurations configs) {
        Intent intent = new Intent();
        ComponentName componentName = new ComponentName(context.getPackageName(), configs.DAEMON_ASSISTANT_CONFIG.SERVICE_NAME);
        intent.setComponent(componentName);
        context.startService(intent);
        this.initAlarm(context, configs.PERSISTENT_CONFIG.SERVICE_NAME);
        Thread t = new Thread(){

            @Override
            public void run() {
                File indicatorDir = context.getDir(DaemonStrategy21.INDICATOR_DIR_NAME, 0);
                new NativeDaemonAPI21(context).doDaemon(new File(indicatorDir, DaemonStrategy21.INDICATOR_PERSISTENT_FILENAME).getAbsolutePath(), new File(indicatorDir, DaemonStrategy21.INDICATOR_DAEMON_ASSISTANT_FILENAME).getAbsolutePath(), new File(indicatorDir, DaemonStrategy21.OBSERVER_PERSISTENT_FILENAME).getAbsolutePath(), new File(indicatorDir, DaemonStrategy21.OBSERVER_DAEMON_ASSISTANT_FILENAME).getAbsolutePath());
            }
        };
        t.setPriority(10);
        t.start();
        if (configs != null && configs.LISTENER != null) {
            this.mConfigs = configs;
            configs.LISTENER.onPersistentStart(context);
        }
    }

    @Override
    public void onDaemonAssistantCreate(final Context context, DaemonConfigurations configs) {
        Intent intent = new Intent();
        ComponentName componentName = new ComponentName(context.getPackageName(), configs.PERSISTENT_CONFIG.SERVICE_NAME);
        intent.setComponent(componentName);
        context.startService(intent);
        this.initAlarm(context, configs.PERSISTENT_CONFIG.SERVICE_NAME);
        Thread t = new Thread(){

            @Override
            public void run() {
                File indicatorDir = context.getDir(DaemonStrategy21.INDICATOR_DIR_NAME, 0);
                new NativeDaemonAPI21(context).doDaemon(new File(indicatorDir, DaemonStrategy21.INDICATOR_DAEMON_ASSISTANT_FILENAME).getAbsolutePath(), new File(indicatorDir, DaemonStrategy21.INDICATOR_PERSISTENT_FILENAME).getAbsolutePath(), new File(indicatorDir, DaemonStrategy21.OBSERVER_DAEMON_ASSISTANT_FILENAME).getAbsolutePath(), new File(indicatorDir, DaemonStrategy21.OBSERVER_PERSISTENT_FILENAME).getAbsolutePath());
            }
        };
        t.setPriority(10);
        t.start();
        if (configs != null && configs.LISTENER != null) {
            this.mConfigs = configs;
            configs.LISTENER.onDaemonAssistantStart(context);
        }
    }

    @Override
    public void onDaemonDead() {
        this.mAlarmManager.setRepeating(3, SystemClock.elapsedRealtime(), 100L, this.mPendingIntent);
        if (this.mConfigs != null && this.mConfigs.LISTENER != null) {
            this.mConfigs.LISTENER.onWatchDaemonDaed();
        }
        Process.killProcess((int)Process.myPid());
    }

    private void initAlarm(Context context, String serviceName) {
        if (this.mAlarmManager == null) {
            this.mAlarmManager = (AlarmManager)context.getSystemService("alarm");
        }
        if (this.mPendingIntent == null) {
            Intent intent = new Intent();
            ComponentName component = new ComponentName(context.getPackageName(), serviceName);
            intent.setComponent(component);
            intent.setFlags(16);
            this.mPendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0);
        }
        this.mAlarmManager.cancel(this.mPendingIntent);
    }

    private boolean initIndicators(Context context) {
        File dirFile = context.getDir(INDICATOR_DIR_NAME, 0);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        try {
            this.createNewFile(dirFile, INDICATOR_PERSISTENT_FILENAME);
            this.createNewFile(dirFile, INDICATOR_DAEMON_ASSISTANT_FILENAME);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void createNewFile(File dirFile, String fileName) throws IOException {
        File file = new File(dirFile, fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
    }
}

