/*
 * Decompiled with CFR 0.152.
 */
package com.marswin89.marsdaemon.strategy;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.marswin89.marsdaemon.DaemonConfigurations;
import com.marswin89.marsdaemon.IDaemonStrategy;
import com.marswin89.marsdaemon.nativ.NativeDaemonAPI21;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class DaemonStrategy23
implements IDaemonStrategy {
    private static final String INDICATOR_DIR_NAME = "indicators";
    private static final String INDICATOR_PERSISTENT_FILENAME = "indicator_p";
    private static final String INDICATOR_DAEMON_ASSISTANT_FILENAME = "indicator_d";
    private static final String OBSERVER_PERSISTENT_FILENAME = "observer_p";
    private static final String OBSERVER_DAEMON_ASSISTANT_FILENAME = "observer_d";
    private IBinder mRemote;
    private Parcel mBroadcastData;
    private DaemonConfigurations mConfigs;

    @Override
    public boolean onInitialization(Context context) {
        return this.initIndicatorFiles(context);
    }

    @Override
    public void onPersistentCreate(final Context context, DaemonConfigurations configs) {
        this.initAmsBinder();
        this.initBroadcastParcel(context, configs.DAEMON_ASSISTANT_CONFIG.RECEIVER_NAME);
        this.sendBroadcastByAmsBinder();
        Thread t = new Thread(){

            @Override
            public void run() {
                File indicatorDir = context.getDir(DaemonStrategy23.INDICATOR_DIR_NAME, 0);
                new NativeDaemonAPI21(context).doDaemon(new File(indicatorDir, DaemonStrategy23.INDICATOR_PERSISTENT_FILENAME).getAbsolutePath(), new File(indicatorDir, DaemonStrategy23.INDICATOR_DAEMON_ASSISTANT_FILENAME).getAbsolutePath(), new File(indicatorDir, DaemonStrategy23.OBSERVER_PERSISTENT_FILENAME).getAbsolutePath(), new File(indicatorDir, DaemonStrategy23.OBSERVER_DAEMON_ASSISTANT_FILENAME).getAbsolutePath());
            }
        };
        t.start();
        ComponentName componentName = new ComponentName(context.getPackageName(), configs.PERSISTENT_CONFIG.SERVICE_NAME);
        Intent intent = new Intent();
        intent.setComponent(componentName);
        context.startService(intent);
        if (configs != null && configs.LISTENER != null) {
            this.mConfigs = configs;
            configs.LISTENER.onPersistentStart(context);
        }
    }

    @Override
    public void onDaemonAssistantCreate(final Context context, DaemonConfigurations configs) {
        this.initAmsBinder();
        this.initBroadcastParcel(context, configs.PERSISTENT_CONFIG.RECEIVER_NAME);
        this.sendBroadcastByAmsBinder();
        Thread t = new Thread(){

            @Override
            public void run() {
                File indicatorDir = context.getDir(DaemonStrategy23.INDICATOR_DIR_NAME, 0);
                new NativeDaemonAPI21(context).doDaemon(new File(indicatorDir, DaemonStrategy23.INDICATOR_DAEMON_ASSISTANT_FILENAME).getAbsolutePath(), new File(indicatorDir, DaemonStrategy23.INDICATOR_PERSISTENT_FILENAME).getAbsolutePath(), new File(indicatorDir, DaemonStrategy23.OBSERVER_DAEMON_ASSISTANT_FILENAME).getAbsolutePath(), new File(indicatorDir, DaemonStrategy23.OBSERVER_PERSISTENT_FILENAME).getAbsolutePath());
            }
        };
        t.start();
        ComponentName componentName = new ComponentName(context.getPackageName(), configs.DAEMON_ASSISTANT_CONFIG.SERVICE_NAME);
        Intent intent = new Intent();
        intent.setComponent(componentName);
        context.startService(intent);
        if (configs != null && configs.LISTENER != null) {
            this.mConfigs = configs;
            configs.LISTENER.onDaemonAssistantStart(context);
        }
    }

    @Override
    public void onDaemonDead() {
        if (this.sendBroadcastByAmsBinder()) {
            if (this.mConfigs != null && this.mConfigs.LISTENER != null) {
                this.mConfigs.LISTENER.onWatchDaemonDaed();
            }
            Process.killProcess((int)Process.myPid());
        }
    }

    private void initAmsBinder() {
        try {
            Class<?> activityManagerNative = Class.forName("android.app.ActivityManagerNative");
            Object amn = activityManagerNative.getMethod("getDefault", new Class[0]).invoke(activityManagerNative, new Object[0]);
            Field mRemoteField = amn.getClass().getDeclaredField("mRemote");
            mRemoteField.setAccessible(true);
            this.mRemote = (IBinder)mRemoteField.get(amn);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"Recycle"})
    private void initBroadcastParcel(Context context, String broadcastName) {
        Intent intent = new Intent();
        ComponentName componentName = new ComponentName(context.getPackageName(), broadcastName);
        intent.setComponent(componentName);
        intent.setFlags(32);
        this.mBroadcastData = Parcel.obtain();
        this.mBroadcastData.writeInterfaceToken("android.app.IActivityManager");
        this.mBroadcastData.writeStrongBinder(null);
        intent.writeToParcel(this.mBroadcastData, 0);
        this.mBroadcastData.writeString(intent.resolveTypeIfNeeded(context.getContentResolver()));
        this.mBroadcastData.writeStrongBinder(null);
        this.mBroadcastData.writeInt(-1);
        this.mBroadcastData.writeString(null);
        this.mBroadcastData.writeBundle(null);
        this.mBroadcastData.writeString(null);
        this.mBroadcastData.writeInt(-1);
        this.mBroadcastData.writeInt(0);
        this.mBroadcastData.writeInt(0);
        this.mBroadcastData.writeInt(0);
    }

    private boolean sendBroadcastByAmsBinder() {
        try {
            if (this.mRemote == null || this.mBroadcastData == null) {
                Log.e((String)"Daemon", (String)"REMOTE IS NULL or PARCEL IS NULL !!!");
                return false;
            }
            this.mRemote.transact(14, this.mBroadcastData, null, 0);
            return true;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean initIndicatorFiles(Context context) {
        File dirFile = context.getDir(INDICATOR_DIR_NAME, 0);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        try {
            this.createNewFile(dirFile, INDICATOR_PERSISTENT_FILENAME);
            this.createNewFile(dirFile, INDICATOR_DAEMON_ASSISTANT_FILENAME);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void createNewFile(File dirFile, String fileName) throws IOException {
        File file = new File(dirFile, fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
    }
}

