/*
 * Decompiled with CFR 0.152.
 */
package com.marswin89.marsdaemon.strategy;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.marswin89.marsdaemon.DaemonConfigurations;
import com.marswin89.marsdaemon.IDaemonStrategy;
import com.marswin89.marsdaemon.nativ.NativeDaemonAPI20;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class DaemonStrategyXiaomi
implements IDaemonStrategy {
    private final String BINARY_DEST_DIR_NAME = "bin";
    private final String BINARY_FILE_NAME = "daemon";
    private IBinder mRemote;
    private Parcel mServiceData;
    private DaemonConfigurations mConfigs;

    @Override
    public boolean onInitialization(Context context) {
        return this.installBinary(context);
    }

    @Override
    public void onPersistentCreate(final Context context, final DaemonConfigurations configs) {
        this.initAmsBinder();
        this.initServiceParcel(context, configs.DAEMON_ASSISTANT_CONFIG.SERVICE_NAME);
        Thread t = new Thread(){

            @Override
            public void run() {
                File binaryFile = new File(context.getDir("bin", 0), "daemon");
                new NativeDaemonAPI20(context).doDaemon(context.getPackageName(), configs.DAEMON_ASSISTANT_CONFIG.SERVICE_NAME, binaryFile.getAbsolutePath());
            }
        };
        t.setPriority(10);
        t.start();
        if (configs != null && configs.LISTENER != null) {
            this.mConfigs = configs;
            configs.LISTENER.onPersistentStart(context);
        }
    }

    @Override
    public void onDaemonAssistantCreate(Context context, DaemonConfigurations configs) {
        Intent intent = new Intent();
        ComponentName component = new ComponentName(context.getPackageName(), configs.PERSISTENT_CONFIG.SERVICE_NAME);
        intent.setComponent(component);
        context.startService(intent);
        if (configs != null && configs.LISTENER != null) {
            configs.LISTENER.onWatchDaemonDaed();
        }
        Process.killProcess((int)Process.myPid());
    }

    @Override
    public void onDaemonDead() {
        if (this.startServiceByAmsBinder()) {
            if (this.mConfigs != null && this.mConfigs.LISTENER != null) {
                this.mConfigs.LISTENER.onWatchDaemonDaed();
            }
            Process.killProcess((int)Process.myPid());
        }
    }

    private void initAmsBinder() {
        try {
            Class<?> activityManagerNative = Class.forName("android.app.ActivityManagerNative");
            Object amn = activityManagerNative.getMethod("getDefault", new Class[0]).invoke(activityManagerNative, new Object[0]);
            Field mRemoteField = amn.getClass().getDeclaredField("mRemote");
            mRemoteField.setAccessible(true);
            this.mRemote = (IBinder)mRemoteField.get(amn);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"Recycle"})
    private void initServiceParcel(Context context, String serviceName) {
        Intent intent = new Intent();
        ComponentName component = new ComponentName(context.getPackageName(), serviceName);
        intent.setComponent(component);
        this.mServiceData = Parcel.obtain();
        this.mServiceData.writeInterfaceToken("android.app.IActivityManager");
        this.mServiceData.writeStrongBinder(null);
        intent.writeToParcel(this.mServiceData, 0);
        this.mServiceData.writeString(null);
        this.mServiceData.writeInt(0);
    }

    private boolean startServiceByAmsBinder() {
        try {
            if (this.mRemote == null || this.mServiceData == null) {
                Log.e((String)"Daemon", (String)"REMOTE IS NULL or PARCEL IS NULL !!!");
                return false;
            }
            this.mRemote.transact(34, this.mServiceData, null, 0);
            return true;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean installBinary(Context context) {
        String binaryDirName = null;
        return this.install(context, "bin", binaryDirName, "daemon");
    }

    private boolean install(Context context, String destDirName, String assetsDirName, String filename) {
        File file = new File(context.getDir(destDirName, 0), filename);
        if (file.exists()) {
            return true;
        }
        try {
            this.copyAssets(context, (TextUtils.isEmpty((CharSequence)assetsDirName) ? "" : assetsDirName + File.separator) + filename, file, "700");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void copyAssets(Context context, String assetsFilename, File file, String mode) throws IOException, InterruptedException {
        AssetManager manager = context.getAssets();
        InputStream is = manager.open(assetsFilename);
        this.copyFile(file, is, mode);
    }

    private void copyFile(File file, InputStream is, String mode) throws IOException, InterruptedException {
        int len;
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        String abspath = file.getAbsolutePath();
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.close();
        is.close();
        Runtime.getRuntime().exec("chmod " + mode + " " + abspath).waitFor();
    }
}

