/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.cache;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.CacheControl;
import cn.jmessage.support.okhttp3.Headers;
import cn.jmessage.support.okhttp3.Request;
import cn.jmessage.support.okhttp3.Response;
import cn.jmessage.support.okhttp3.internal.Internal;
import cn.jmessage.support.okhttp3.internal.http.HttpDate;
import cn.jmessage.support.okhttp3.internal.http.HttpHeaders;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class CacheStrategy {
    @Nullable
    public final Request networkRequest;
    @Nullable
    public final Response cacheResponse;
    private static final String z;

    CacheStrategy(Request request, Response response) {
        this.networkRequest = request;
        this.cacheResponse = response;
    }

    public static boolean isCacheable(Response response, Request request) {
        switch (response.code()) {
            case 200: 
            case 203: 
            case 204: 
            case 300: 
            case 301: 
            case 308: 
            case 404: 
            case 405: 
            case 410: 
            case 414: 
            case 501: {
                break;
            }
            case 302: 
            case 307: {
                if (response.header(z) != null || response.cacheControl().maxAgeSeconds() != -1 || response.cacheControl().isPublic() || response.cacheControl().isPrivate()) break;
            }
            default: {
                return false;
            }
        }
        return !response.cacheControl().noStore() && !request.cacheControl().noStore();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = ")@K\u000f!\tK".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 108;
                            break;
                        }
                        case 1: {
                            n7 = 56;
                            break;
                        }
                        case 2: {
                            n7 = 59;
                            break;
                        }
                        case 3: {
                            n7 = 102;
                            break;
                        }
                        default: {
                            n7 = 83;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        z = new String(cArray).intern();
    }

    public static class Factory {
        final long nowMillis;
        final Request request;
        final Response cacheResponse;
        private Date servedDate;
        private String servedDateString;
        private Date lastModified;
        private String lastModifiedString;
        private Date expires;
        private long sentRequestMillis;
        private long receivedResponseMillis;
        private String etag;
        private int ageSeconds = -1;
        private static final String[] z;

        public Factory(long l2, Request request, Response object) {
            this.nowMillis = l2;
            this.request = request;
            this.cacheResponse = object;
            if (object != null) {
                this.sentRequestMillis = ((Response)object).sentRequestAtMillis();
                this.receivedResponseMillis = ((Response)object).receivedResponseAtMillis();
                Headers headers = ((Response)object).headers();
                int n2 = headers.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    object = headers.name(i2);
                    String string = headers.value(i2);
                    if (z[9].equalsIgnoreCase((String)object)) {
                        this.servedDate = HttpDate.parse(string);
                        this.servedDateString = string;
                        continue;
                    }
                    if (z[8].equalsIgnoreCase((String)object)) {
                        this.expires = HttpDate.parse(string);
                        continue;
                    }
                    if (z[6].equalsIgnoreCase((String)object)) {
                        this.lastModified = HttpDate.parse(string);
                        this.lastModifiedString = string;
                        continue;
                    }
                    if (z[5].equalsIgnoreCase((String)object)) {
                        this.etag = string;
                        continue;
                    }
                    if (!z[7].equalsIgnoreCase((String)object)) continue;
                    this.ageSeconds = HttpHeaders.parseSeconds(string, -1);
                }
            }
        }

        public CacheStrategy get() {
            CacheStrategy cacheStrategy = this.getCandidate();
            if (cacheStrategy.networkRequest != null && this.request.cacheControl().onlyIfCached()) {
                return new CacheStrategy(null, null);
            }
            return cacheStrategy;
        }

        private CacheStrategy getCandidate() {
            if (this.cacheResponse == null) {
                return new CacheStrategy(this.request, null);
            }
            if (this.request.isHttps() && this.cacheResponse.handshake() == null) {
                return new CacheStrategy(this.request, null);
            }
            if (!CacheStrategy.isCacheable(this.cacheResponse, this.request)) {
                return new CacheStrategy(this.request, null);
            }
            Object object = this.request.cacheControl();
            if (((CacheControl)object).noCache() || Factory.hasConditions(this.request)) {
                return new CacheStrategy(this.request, null);
            }
            Object object2 = this.cacheResponse.cacheControl();
            if (((CacheControl)object2).immutable()) {
                return new CacheStrategy(null, this.cacheResponse);
            }
            long l2 = this.cacheResponseAge();
            long l3 = this.computeFreshnessLifetime();
            if (((CacheControl)object).maxAgeSeconds() != -1) {
                l3 = Math.min(l3, TimeUnit.SECONDS.toMillis(((CacheControl)object).maxAgeSeconds()));
            }
            long l4 = 0L;
            if (((CacheControl)object).minFreshSeconds() != -1) {
                l4 = TimeUnit.SECONDS.toMillis(((CacheControl)object).minFreshSeconds());
            }
            long l5 = 0L;
            if (!((CacheControl)object2).mustRevalidate() && ((CacheControl)object).maxStaleSeconds() != -1) {
                l5 = TimeUnit.SECONDS.toMillis(((CacheControl)object).maxStaleSeconds());
            }
            if (!((CacheControl)object2).noCache() && l2 + l4 < l3 + l5) {
                object = this.cacheResponse.newBuilder();
                if (l2 + l4 >= l3) {
                    ((Response.Builder)object).addHeader(z[0], z[1]);
                }
                if (l2 > 86400000L && this.isFreshnessLifetimeHeuristic()) {
                    ((Response.Builder)object).addHeader(z[0], z[3]);
                }
                return new CacheStrategy(null, ((Response.Builder)object).build());
            }
            if (this.etag != null) {
                object = z[4];
                object2 = this.etag;
            } else if (this.lastModified != null) {
                object = z[2];
                object2 = this.lastModifiedString;
            } else if (this.servedDate != null) {
                object = z[2];
                object2 = this.servedDateString;
            } else {
                return new CacheStrategy(this.request, null);
            }
            Headers.Builder builder = this.request.headers().newBuilder();
            Internal.instance.addLenient(builder, (String)object, (String)object2);
            object = this.request.newBuilder().headers(builder.build()).build();
            return new CacheStrategy((Request)object, this.cacheResponse);
        }

        private long computeFreshnessLifetime() {
            CacheControl cacheControl = this.cacheResponse.cacheControl();
            if (cacheControl.maxAgeSeconds() != -1) {
                return TimeUnit.SECONDS.toMillis(cacheControl.maxAgeSeconds());
            }
            if (this.expires != null) {
                long l2 = this.servedDate != null ? this.servedDate.getTime() : this.receivedResponseMillis;
                long l3 = this.expires.getTime() - l2;
                if (l3 > 0L) {
                    return l3;
                }
                return 0L;
            }
            if (this.lastModified != null && this.cacheResponse.request().url().query() == null) {
                long l4 = (this.servedDate != null ? this.servedDate.getTime() : this.sentRequestMillis) - this.lastModified.getTime();
                if (l4 > 0L) {
                    return l4 / 10L;
                }
                return 0L;
            }
            return 0L;
        }

        private long cacheResponseAge() {
            long l2 = this.servedDate != null ? Math.max(0L, this.receivedResponseMillis - this.servedDate.getTime()) : 0L;
            long l3 = this.ageSeconds != -1 ? Math.max(l2, TimeUnit.SECONDS.toMillis(this.ageSeconds)) : l2;
            long l4 = this.receivedResponseMillis - this.sentRequestMillis;
            long l5 = this.nowMillis - this.receivedResponseMillis;
            return l3 + l4 + l5;
        }

        private boolean isFreshnessLifetimeHeuristic() {
            return this.cacheResponse.cacheControl().maxAgeSeconds() == -1 && this.expires == null;
        }

        private static boolean hasConditions(Request request) {
            return request.header(z[2]) != null || request.header(z[4]) != null;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[10];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = " \u001b\u000f\u0012X\u0019\u001d";
            int n3 = -1;
            block17: while (true) {
                char[] cArray;
                block22: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block21: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block21;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block22;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 119;
                                    break;
                                }
                                case 1: {
                                    n9 = 122;
                                    break;
                                }
                                case 2: {
                                    n9 = 125;
                                    break;
                                }
                                case 3: {
                                    n9 = 124;
                                    break;
                                }
                                default: {
                                    n9 = 49;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "FKM\\y\u0003\u000e\r)c;9\u0012\u0012_\u0012\u0019\t\u0015^\u0019Z_.T\u0004\n\u0012\u0012B\u0012Z\u0014\u000f\u0011\u0004\u000e\u001c\u0010TU";
                        n3 = 0;
                        continue block17;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = ">\u001cP1^\u0013\u0013\u001b\u0015T\u0013W.\u0015_\u0014\u001f";
                        n3 = 1;
                        continue block17;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "FKN\\y\u0003\u000e\r)c;9\u0012\u0012_\u0012\u0019\t\u0015^\u0019Z_4T\u0002\b\u0014\u000fE\u001e\u0019]\u0019I\u0007\u0013\u000f\u001dE\u001e\u0015\u0013^";
                        n3 = 2;
                        continue block17;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = ">\u001cP2^\u0019\u001fP1P\u0003\u0019\u0015";
                        n3 = 3;
                        continue block17;
                    }
                    case 3: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 5;
                        string2 = "2.\u001c\u001b";
                        n3 = 4;
                        continue block17;
                    }
                    case 4: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 6;
                        string2 = ";\u001b\u000e\b\u001c:\u0015\u0019\u0015W\u001e\u001f\u0019";
                        n3 = 5;
                        continue block17;
                    }
                    case 5: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 7;
                        string2 = "6\u001d\u0018";
                        n3 = 6;
                        continue block17;
                    }
                    case 6: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 8;
                        string2 = "2\u0002\r\u0015C\u0012\t";
                        n3 = 7;
                        continue block17;
                    }
                    case 7: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 9;
                        string2 = "3\u001b\t\u0019";
                        n3 = 8;
                        continue block17;
                    }
                    case 8: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

