/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.cache;

import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.ForwardingSink;
import cn.jmessage.support.okio.Sink;
import java.io.IOException;

class FaultHidingSink
extends ForwardingSink {
    private boolean hasErrors;

    FaultHidingSink(Sink sink) {
        super(sink);
    }

    @Override
    public void write(Buffer buffer, long l2) throws IOException {
        if (this.hasErrors) {
            buffer.skip(l2);
            return;
        }
        try {
            super.write(buffer, l2);
            return;
        }
        catch (IOException iOException) {
            this.hasErrors = true;
            this.onException(iOException);
            return;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.hasErrors) {
            return;
        }
        try {
            super.flush();
            return;
        }
        catch (IOException iOException) {
            this.hasErrors = true;
            this.onException(iOException);
            return;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.hasErrors) {
            return;
        }
        try {
            super.close();
            return;
        }
        catch (IOException iOException) {
            this.hasErrors = true;
            this.onException(iOException);
            return;
        }
    }

    protected void onException(IOException iOException) {
    }
}

