/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okio;

import android.annotation.TargetApi;
import cn.jmessage.support.animal_sniffer.IgnoreJRERequirement;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSink;
import cn.jmessage.support.okio.Okio;
import cn.jmessage.support.okio.Segment;
import cn.jmessage.support.okio.SegmentPool;
import cn.jmessage.support.okio.Sink;
import cn.jmessage.support.okio.Timeout;
import cn.jmessage.support.okio.Util;
import java.io.IOException;
import java.util.zip.Deflater;

public final class DeflaterSink
implements Sink {
    private final BufferedSink sink;
    private final Deflater deflater;
    private boolean closed;
    private static final String[] z;

    public DeflaterSink(Sink sink, Deflater deflater) {
        this(Okio.buffer(sink), deflater);
    }

    DeflaterSink(BufferedSink bufferedSink, Deflater deflater) {
        if (bufferedSink == null) {
            throw new IllegalArgumentException(z[2]);
        }
        if (deflater == null) {
            throw new IllegalArgumentException(z[1]);
        }
        this.sink = bufferedSink;
        this.deflater = deflater;
    }

    @Override
    public final void write(Buffer buffer, long l2) throws IOException {
        Util.checkOffsetAndCount(buffer.size, 0L, l2);
        while (l2 > 0L) {
            Segment segment = buffer.head;
            int n2 = (int)Math.min(l2, (long)(segment.limit - segment.pos));
            this.deflater.setInput(segment.data, segment.pos, n2);
            this.deflate(false);
            buffer.size -= (long)n2;
            segment.pos += n2;
            if (segment.pos == segment.limit) {
                buffer.head = segment.pop();
                SegmentPool.recycle(segment);
            }
            l2 -= (long)n2;
        }
    }

    @TargetApi(value=19)
    @IgnoreJRERequirement
    private void deflate(boolean bl) throws IOException {
        Segment segment;
        Buffer buffer = this.sink.buffer();
        while (true) {
            segment = buffer.writableSegment(1);
            int n2 = bl ? this.deflater.deflate(segment.data, segment.limit, 8192 - segment.limit, 2) : this.deflater.deflate(segment.data, segment.limit, 8192 - segment.limit);
            if (n2 > 0) {
                segment.limit += n2;
                buffer.size += (long)n2;
                this.sink.emitCompleteSegments();
                continue;
            }
            if (this.deflater.needsInput()) break;
        }
        if (segment.pos == segment.limit) {
            buffer.head = segment.pop();
            SegmentPool.recycle(segment);
        }
    }

    @Override
    public final void flush() throws IOException {
        this.deflate(true);
        this.sink.flush();
    }

    final void finishDeflate() throws IOException {
        this.deflater.finish();
        this.deflate(false);
    }

    @Override
    public final void close() throws IOException {
        Throwable throwable;
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                throwable = null;
                try {
                    this.finishDeflate();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block8;
                    throwable = throwable3;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable throwable4) {
                if (throwable != null) break block9;
                throwable = throwable4;
            }
        }
        this.closed = true;
        if (throwable != null) {
            Util.sneakyRethrow(throwable);
        }
    }

    @Override
    public final Timeout timeout() {
        return this.sink.timeout();
    }

    public final String toString() {
        return z[0] + this.sink + ")";
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "8K*\u0003}\bK><u\u0012Ed";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 124;
                                break;
                            }
                            case 1: {
                                n9 = 46;
                                break;
                            }
                            case 2: {
                                n9 = 76;
                                break;
                            }
                            case 3: {
                                n9 = 111;
                                break;
                            }
                            default: {
                                n9 = 28;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0015@*\u0003}\bK>O!A\u000e\"\u001ap\u0010";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u000fA9\u001d\u007f\u0019\u000eqR<\u0012[ \u0003";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

