/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okio;

import android.annotation.TargetApi;
import cn.jmessage.support.animal_sniffer.IgnoreJRERequirement;
import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okio.AsyncTimeout;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSink;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.RealBufferedSink;
import cn.jmessage.support.okio.RealBufferedSource;
import cn.jmessage.support.okio.Segment;
import cn.jmessage.support.okio.SegmentPool;
import cn.jmessage.support.okio.Sink;
import cn.jmessage.support.okio.Source;
import cn.jmessage.support.okio.Timeout;
import cn.jmessage.support.okio.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Okio {
    static final Logger logger;
    private static final String[] z;

    private Okio() {
    }

    public static BufferedSource buffer(Source source) {
        return new RealBufferedSource(source);
    }

    public static BufferedSink buffer(Sink sink) {
        return new RealBufferedSink(sink);
    }

    public static Sink sink(OutputStream outputStream) {
        return Okio.sink(outputStream, new Timeout());
    }

    private static Sink sink(final OutputStream outputStream, final Timeout timeout) {
        if (outputStream == null) {
            throw new IllegalArgumentException(z[5]);
        }
        if (timeout == null) {
            throw new IllegalArgumentException(z[6]);
        }
        return new Sink(){
            private static final String z;

            @Override
            public final void write(Buffer buffer, long l2) throws IOException {
                Util.checkOffsetAndCount(buffer.size, 0L, l2);
                while (l2 > 0L) {
                    timeout.throwIfReached();
                    Segment segment = buffer.head;
                    int n2 = (int)Math.min(l2, (long)(segment.limit - segment.pos));
                    outputStream.write(segment.data, segment.pos, n2);
                    segment.pos += n2;
                    l2 -= (long)n2;
                    buffer.size -= (long)n2;
                    if (segment.pos != segment.limit) continue;
                    buffer.head = segment.pop();
                    SegmentPool.recycle(segment);
                }
            }

            @Override
            public final void flush() throws IOException {
                outputStream.flush();
            }

            @Override
            public final void close() throws IOException {
                outputStream.close();
            }

            @Override
            public final Timeout timeout() {
                return timeout;
            }

            public final String toString() {
                return z + outputStream + ")";
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                char[] cArray;
                block10: {
                    int n2;
                    int n3;
                    char[] cArray2;
                    int n4;
                    block9: {
                        char[] cArray3 = ";F\fAz".toCharArray();
                        n4 = 0;
                        int n5 = cArray3.length;
                        cArray2 = cArray3;
                        n3 = n5;
                        if (n5 <= 1) break block9;
                        cArray = cArray2;
                        n2 = n3;
                        if (n3 <= n4) break block10;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n6 = n4;
                        while (true) {
                            int n7;
                            char c2 = cArray4[n6];
                            switch (n4 % 5) {
                                case 0: {
                                    n7 = 72;
                                    break;
                                }
                                case 1: {
                                    n7 = 47;
                                    break;
                                }
                                case 2: {
                                    n7 = 98;
                                    break;
                                }
                                case 3: {
                                    n7 = 42;
                                    break;
                                }
                                default: {
                                    n7 = 82;
                                }
                            }
                            cArray4[n6] = (char)(c2 ^ n7);
                            ++n4;
                            cArray2 = cArray5;
                            n3 = n3;
                            if (n3 != 0) break;
                            cArray5 = cArray2;
                            n2 = n3;
                            n6 = n3;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n2 = n3;
                    } while (n3 > n4);
                }
                z = new String(cArray).intern();
            }
        };
    }

    public static Sink sink(Socket closeable) throws IOException {
        if (closeable == null) {
            throw new IllegalArgumentException(z[3]);
        }
        if (closeable.getOutputStream() == null) {
            throw new IOException(z[7]);
        }
        AsyncTimeout asyncTimeout = Okio.timeout(closeable);
        closeable = Okio.sink(closeable.getOutputStream(), asyncTimeout);
        return asyncTimeout.sink((Sink)closeable);
    }

    public static Source source(InputStream inputStream) {
        return Okio.source(inputStream, new Timeout());
    }

    private static Source source(final InputStream inputStream, final Timeout timeout) {
        if (inputStream == null) {
            throw new IllegalArgumentException(z[8]);
        }
        if (timeout == null) {
            throw new IllegalArgumentException(z[6]);
        }
        return new Source(){
            private static final String[] z;

            @Override
            public final long read(Buffer buffer, long l2) throws IOException {
                if (l2 < 0L) {
                    throw new IllegalArgumentException(z[1] + l2);
                }
                if (l2 == 0L) {
                    return 0L;
                }
                try {
                    timeout.throwIfReached();
                    Segment segment = buffer.writableSegment(1);
                    int n2 = (int)Math.min(l2, (long)(8192 - segment.limit));
                    n2 = inputStream.read(segment.data, segment.limit, n2);
                    if (n2 == -1) {
                        return -1L;
                    }
                    segment.limit += n2;
                    buffer.size += (long)n2;
                    return n2;
                }
                catch (AssertionError assertionError) {
                    AssertionError assertionError2 = assertionError;
                    if (Okio.isAndroidGetsocknameError(assertionError)) {
                        throw new IOException((Throwable)((Object)assertionError2));
                    }
                    throw assertionError2;
                }
            }

            @Override
            public final void close() throws IOException {
                inputStream.close();
            }

            @Override
            public final Timeout timeout() {
                return timeout;
            }

            public final String toString() {
                return z[0] + inputStream + ")";
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                String string;
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n2 = 0;
                String string2 = "k\u001cVS*}[";
                int n3 = -1;
                block9: while (true) {
                    char[] cArray;
                    block14: {
                        int n4;
                        int n5;
                        char[] cArray2;
                        int n6;
                        block13: {
                            char[] cArray3 = string2.toCharArray();
                            n6 = 0;
                            int n7 = cArray3.length;
                            cArray2 = cArray3;
                            n5 = n7;
                            if (n7 <= 1) break block13;
                            cArray = cArray2;
                            n4 = n5;
                            if (n5 <= n6) break block14;
                        }
                        do {
                            char[] cArray4 = cArray2;
                            char[] cArray5 = cArray2;
                            int n8 = n6;
                            while (true) {
                                int n9;
                                char c2 = cArray4[n8];
                                switch (n6 % 5) {
                                    case 0: {
                                        n9 = 24;
                                        break;
                                    }
                                    case 1: {
                                        n9 = 115;
                                        break;
                                    }
                                    case 2: {
                                        n9 = 35;
                                        break;
                                    }
                                    case 3: {
                                        n9 = 33;
                                        break;
                                    }
                                    default: {
                                        n9 = 73;
                                    }
                                }
                                cArray4[n8] = (char)(c2 ^ n9);
                                ++n6;
                                cArray2 = cArray5;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray5 = cArray2;
                                n4 = n5;
                                n8 = n5;
                                cArray4 = cArray2;
                            }
                            cArray = cArray2;
                            n4 = n5;
                        } while (n5 > n6);
                    }
                    string = new String(cArray);
                    switch (n3) {
                        default: {
                            stringArray2[n2] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n2 = 1;
                            string2 = "z\nWD\nw\u0006MUi$S\u0013\u001bi";
                            n3 = 0;
                            continue block9;
                        }
                        case 0: 
                    }
                    break;
                }
                stringArray2[n2] = string.intern();
                z = stringArray3;
            }
        };
    }

    public static Source source(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException(z[1]);
        }
        return Okio.source(new FileInputStream(file));
    }

    @TargetApi(value=26)
    @IgnoreJRERequirement
    public static Source source(Path path, OpenOption ... openOptionArray) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(z[0]);
        }
        return Okio.source(Files.newInputStream(path, openOptionArray));
    }

    public static Sink sink(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException(z[1]);
        }
        return Okio.sink(new FileOutputStream(file));
    }

    public static Sink appendingSink(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException(z[1]);
        }
        return Okio.sink(new FileOutputStream(file, true));
    }

    @TargetApi(value=26)
    @IgnoreJRERequirement
    public static Sink sink(Path path, OpenOption ... openOptionArray) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(z[0]);
        }
        return Okio.sink(Files.newOutputStream(path, openOptionArray));
    }

    public static Sink blackhole() {
        return new Sink(){

            @Override
            public final void write(Buffer buffer, long l2) throws IOException {
                buffer.skip(l2);
            }

            @Override
            public final void flush() throws IOException {
            }

            @Override
            public final Timeout timeout() {
                return Timeout.NONE;
            }

            @Override
            public final void close() throws IOException {
            }
        };
    }

    public static Source source(Socket closeable) throws IOException {
        if (closeable == null) {
            throw new IllegalArgumentException(z[3]);
        }
        if (closeable.getInputStream() == null) {
            throw new IOException(z[2]);
        }
        AsyncTimeout asyncTimeout = Okio.timeout(closeable);
        closeable = Okio.source(closeable.getInputStream(), asyncTimeout);
        return asyncTimeout.source((Source)closeable);
    }

    private static AsyncTimeout timeout(final Socket socket) {
        return new AsyncTimeout(){
            private static final String[] z;

            @Override
            protected final IOException newTimeoutException(@Nullable IOException iOException) {
                SocketTimeoutException socketTimeoutException = new SocketTimeoutException(z[1]);
                if (iOException != null) {
                    socketTimeoutException.initCause(iOException);
                }
                return socketTimeoutException;
            }

            @Override
            protected final void timedOut() {
                try {
                    socket.close();
                    return;
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, z[0] + socket, exception);
                    return;
                }
                catch (AssertionError assertionError) {
                    AssertionError assertionError2 = assertionError;
                    if (Okio.isAndroidGetsocknameError(assertionError)) {
                        logger.log(Level.WARNING, z[0] + socket, (Throwable)((Object)assertionError2));
                        return;
                    }
                    throw assertionError2;
                }
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                String string;
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n2 = 0;
                String string2 = "*t)!\u000e\b54\"K\u000fy/>\u000eLa) \u000e\b5/8\u001fLf/.\u0000\ta`";
                int n3 = -1;
                block9: while (true) {
                    char[] cArray;
                    block14: {
                        int n4;
                        int n5;
                        char[] cArray2;
                        int n6;
                        block13: {
                            char[] cArray3 = string2.toCharArray();
                            n6 = 0;
                            int n7 = cArray3.length;
                            cArray2 = cArray3;
                            n5 = n7;
                            if (n7 <= 1) break block13;
                            cArray = cArray2;
                            n4 = n5;
                            if (n5 <= n6) break block14;
                        }
                        do {
                            char[] cArray4 = cArray2;
                            char[] cArray5 = cArray2;
                            int n8 = n6;
                            while (true) {
                                int n9;
                                char c2 = cArray4[n8];
                                switch (n6 % 5) {
                                    case 0: {
                                        n9 = 108;
                                        break;
                                    }
                                    case 1: {
                                        n9 = 21;
                                        break;
                                    }
                                    case 2: {
                                        n9 = 64;
                                        break;
                                    }
                                    case 3: {
                                        n9 = 77;
                                        break;
                                    }
                                    default: {
                                        n9 = 107;
                                    }
                                }
                                cArray4[n8] = (char)(c2 ^ n9);
                                ++n6;
                                cArray2 = cArray5;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray5 = cArray2;
                                n4 = n5;
                                n8 = n5;
                                cArray4 = cArray2;
                            }
                            cArray = cArray2;
                            n4 = n5;
                        } while (n5 > n6);
                    }
                    string = new String(cArray);
                    switch (n3) {
                        default: {
                            stringArray2[n2] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n2 = 1;
                            string2 = "\u0018|-(\u0004\u0019a";
                            n3 = 0;
                            continue block9;
                        }
                        case 0: 
                    }
                    break;
                }
                stringArray2[n2] = string.intern();
                z = stringArray3;
            }
        };
    }

    static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        return ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains(z[4]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "RU#\u0005e\u001f\tw\u00030NX";
        int n3 = -1;
        block16: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block20: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block20;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block21;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 34;
                                break;
                            }
                            case 1: {
                                n9 = 52;
                                break;
                            }
                            case 2: {
                                n9 = 87;
                                break;
                            }
                            case 3: {
                                n9 = 109;
                                break;
                            }
                            default: {
                                n9 = 69;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "D];\be\u001f\tw\u00030NX";
                    n3 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "Q[4\u0006 V\u0013$M,LD\"\u0019eQ@%\b$O\u0014jPeLA;\u0001";
                    n3 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "Q[4\u0006 V\u0014jPeLA;\u0001";
                    n3 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "EQ#\u001e*A_9\f(G\u00141\f,NQ3";
                    n3 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "MA#Mx\u001f\u00149\u0018)N";
                    n3 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "V]:\b*W@wPx\u0002Z\"\u0001)";
                    n3 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "Q[4\u0006 V\u0013$M*W@'\u00181\u0002G#\u001f CYwPx\u0002Z\"\u0001)";
                    n3 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "KZwPx\u0002Z\"\u0001)";
                    n3 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        logger = Logger.getLogger(Okio.class.getName());
    }
}

