/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.qiniu.android.dns.local;

import cn.jmessage.support.qiniu.android.dns.Domain;
import cn.jmessage.support.qiniu.android.dns.NetworkInfo;
import java.util.AbstractSequentialList;
import java.util.Hashtable;
import java.util.LinkedList;

public final class Hosts {
    private final Hashtable<String, LinkedList<Value>> hosts = new Hashtable();

    public final synchronized String[] query(Domain linkedList, NetworkInfo networkInfo) {
        linkedList = this.hosts.get(((Domain)((Object)linkedList)).domain);
        if (linkedList == null || linkedList.isEmpty()) {
            return null;
        }
        if (linkedList.size() > 1) {
            Value value = (Value)linkedList.get(0);
            linkedList.remove(0);
            linkedList.add(value);
        }
        linkedList = this.filter(linkedList, networkInfo);
        return this.toIps(linkedList);
    }

    private LinkedList<Value> filter(LinkedList<Value> object, NetworkInfo networkInfo) {
        LinkedList<Value> linkedList = new LinkedList<Value>();
        LinkedList<Value> linkedList2 = new LinkedList<Value>();
        object = ((AbstractSequentialList)object).iterator();
        while (object.hasNext()) {
            Value value = (Value)object.next();
            if (value.provider == 0) {
                linkedList.add(value);
            }
            if (networkInfo.provider == 0 || value.provider != networkInfo.provider) continue;
            linkedList2.add(value);
        }
        if (linkedList2.size() != 0) {
            return linkedList2;
        }
        return linkedList;
    }

    public final synchronized String[] toIps(LinkedList<Value> linkedList) {
        int n2 = linkedList.size();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Value value = linkedList.get(i2);
            stringArray[i2] = value.ip;
        }
        return stringArray;
    }

    public final synchronized Hosts put(String string, Value value) {
        LinkedList<Value> linkedList = this.hosts.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList();
        }
        linkedList.add(value);
        this.hosts.put(string, linkedList);
        return this;
    }

    public final Hosts put(String string, String string2) {
        this.put(string, new Value(string2));
        return this;
    }

    public static class Value {
        public final String ip;
        public final int provider;

        public Value(String string, int n2) {
            this.ip = string;
            this.provider = n2;
        }

        public Value(String string) {
            this(string, 0);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof Value)) {
                return false;
            }
            object = (Value)object;
            return this.ip.equals(((Value)object).ip) && this.provider == ((Value)object).provider;
        }
    }
}

