/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush.internal.bind;

import com.google.gson.jpush.Gson;
import com.google.gson.jpush.TypeAdapter;
import com.google.gson.jpush.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.jpush.reflect.TypeToken;
import com.google.gson.jpush.stream.JsonReader;
import com.google.gson.jpush.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

final class TypeAdapterRuntimeTypeWrapper<T>
extends TypeAdapter<T> {
    private final Gson context;
    private final TypeAdapter<T> delegate;
    private final Type type;

    TypeAdapterRuntimeTypeWrapper(Gson gson, TypeAdapter<T> typeAdapter, Type type) {
        this.context = gson;
        this.delegate = typeAdapter;
        this.type = type;
    }

    @Override
    public final T read(JsonReader jsonReader) throws IOException {
        return this.delegate.read(jsonReader);
    }

    @Override
    public final void write(JsonWriter jsonWriter, T t2) throws IOException {
        TypeAdapter<Object> typeAdapter = this.delegate;
        Type type = this.getRuntimeTypeIfMoreSpecific(this.type, t2);
        if (type != this.type && (typeAdapter = this.context.getAdapter(TypeToken.get(type))) instanceof ReflectiveTypeAdapterFactory.Adapter && !(this.delegate instanceof ReflectiveTypeAdapterFactory.Adapter)) {
            typeAdapter = this.delegate;
        }
        typeAdapter.write(jsonWriter, t2);
    }

    private Type getRuntimeTypeIfMoreSpecific(Type clazz, Object object) {
        if (object != null && (clazz == Object.class || clazz instanceof TypeVariable || clazz instanceof Class)) {
            clazz = object.getClass();
        }
        return clazz;
    }
}

