/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush.stream;

import com.google.gson.jpush.internal.JsonReaderInternalAccess;
import com.google.gson.jpush.internal.bind.JsonTreeReader;
import com.google.gson.jpush.stream.JsonToken;
import com.google.gson.jpush.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class JsonReader
implements Closeable {
    private static final char[] NON_EXECUTE_PREFIX;
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_EOF = 17;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    private final Reader in;
    private boolean lenient = false;
    private final char[] buffer = new char[1024];
    private int pos = 0;
    private int limit = 0;
    private int lineNumber = 0;
    private int lineStart = 0;
    private int peeked = 0;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String[] pathNames;
    private int[] pathIndices;
    private static final String[] z;

    public JsonReader(Reader reader) {
        this.stack[this.stackSize++] = 6;
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
        if (reader == null) {
            throw new NullPointerException(z[18]);
        }
        this.in = reader;
    }

    public final void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    public void beginArray() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 3) {
            this.push(1);
            this.pathIndices[this.stackSize - 1] = 0;
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException(z[5] + (Object)((Object)this.peek()) + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
    }

    public void endArray() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 4) {
            --this.stackSize;
            int n3 = this.stackSize - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException(z[9] + (Object)((Object)this.peek()) + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
    }

    public void beginObject() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 1) {
            this.push(3);
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException(z[6] + (Object)((Object)this.peek()) + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
    }

    public void endObject() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 2) {
            --this.stackSize;
            this.pathNames[this.stackSize] = null;
            int n3 = this.stackSize - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException(z[4] + (Object)((Object)this.peek()) + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
    }

    public boolean hasNext() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        return n2 != 2 && n2 != 4;
    }

    public JsonToken peek() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        switch (n2) {
            case 1: {
                return JsonToken.BEGIN_OBJECT;
            }
            case 2: {
                return JsonToken.END_OBJECT;
            }
            case 3: {
                return JsonToken.BEGIN_ARRAY;
            }
            case 4: {
                return JsonToken.END_ARRAY;
            }
            case 12: 
            case 13: 
            case 14: {
                return JsonToken.NAME;
            }
            case 5: 
            case 6: {
                return JsonToken.BOOLEAN;
            }
            case 7: {
                return JsonToken.NULL;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonToken.STRING;
            }
            case 15: 
            case 16: {
                return JsonToken.NUMBER;
            }
            case 17: {
                return JsonToken.END_DOCUMENT;
            }
        }
        throw new AssertionError();
    }

    private int doPeek() throws IOException {
        int n2;
        block47: {
            block49: {
                block48: {
                    block46: {
                        n2 = this.stack[this.stackSize - 1];
                        if (n2 != 1) break block46;
                        this.stack[this.stackSize - 1] = 2;
                        break block47;
                    }
                    if (n2 != 2) break block48;
                    switch (this.nextNonWhitespace(true)) {
                        case 93: {
                            this.peeked = 4;
                            return 4;
                        }
                        case 59: {
                            this.checkLenient();
                        }
                        case 44: {
                            break block47;
                        }
                        default: {
                            throw this.syntaxError(z[21]);
                        }
                    }
                }
                if (n2 == 3 || n2 == 5) {
                    this.stack[this.stackSize - 1] = 4;
                    if (n2 == 5) {
                        switch (this.nextNonWhitespace(true)) {
                            case 125: {
                                this.peeked = 2;
                                return 2;
                            }
                            case 59: {
                                this.checkLenient();
                            }
                            case 44: {
                                break;
                            }
                            default: {
                                throw this.syntaxError(z[24]);
                            }
                        }
                    }
                    int n3 = this.nextNonWhitespace(true);
                    switch (n3) {
                        case 34: {
                            this.peeked = 13;
                            return 13;
                        }
                        case 39: {
                            this.checkLenient();
                            this.peeked = 12;
                            return 12;
                        }
                        case 125: {
                            if (n2 != 5) {
                                this.peeked = 2;
                                return 2;
                            }
                            throw this.syntaxError(z[26]);
                        }
                    }
                    this.checkLenient();
                    --this.pos;
                    if (this.isLiteral((char)n3)) {
                        this.peeked = 14;
                        return 14;
                    }
                    throw this.syntaxError(z[26]);
                }
                if (n2 != 4) break block49;
                this.stack[this.stackSize - 1] = 5;
                switch (this.nextNonWhitespace(true)) {
                    case 58: {
                        break block47;
                    }
                    case 61: {
                        this.checkLenient();
                        if ((this.pos < this.limit || this.fillBuffer(1)) && this.buffer[this.pos] == '>') {
                            ++this.pos;
                        }
                        break block47;
                    }
                    default: {
                        throw this.syntaxError(z[20]);
                    }
                }
            }
            if (n2 == 6) {
                if (this.lenient) {
                    this.consumeNonExecutePrefix();
                }
                this.stack[this.stackSize - 1] = 7;
            } else if (n2 == 7) {
                if (this.nextNonWhitespace(false) == -1) {
                    this.peeked = 17;
                    return 17;
                }
                this.checkLenient();
                --this.pos;
            } else if (n2 == 8) {
                throw new IllegalStateException(z[23]);
            }
        }
        switch (this.nextNonWhitespace(true)) {
            case 93: {
                if (n2 == 1) {
                    this.peeked = 4;
                    return 4;
                }
            }
            case 44: 
            case 59: {
                if (n2 == 1 || n2 == 2) {
                    this.checkLenient();
                    --this.pos;
                    this.peeked = 7;
                    return 7;
                }
                throw this.syntaxError(z[25]);
            }
            case 39: {
                this.checkLenient();
                this.peeked = 8;
                return 8;
            }
            case 34: {
                if (this.stackSize == 1) {
                    this.checkLenient();
                }
                this.peeked = 9;
                return 9;
            }
            case 91: {
                this.peeked = 3;
                return 3;
            }
            case 123: {
                this.peeked = 1;
                return 1;
            }
        }
        --this.pos;
        if (this.stackSize == 1) {
            this.checkLenient();
        }
        if ((n2 = this.peekKeyword()) != 0) {
            return n2;
        }
        n2 = this.peekNumber();
        if (n2 != 0) {
            return n2;
        }
        if (!this.isLiteral(this.buffer[this.pos])) {
            throw this.syntaxError(z[22]);
        }
        this.checkLenient();
        this.peeked = 10;
        return 10;
    }

    private int peekKeyword() throws IOException {
        int n2;
        String string;
        String string2;
        char c2 = this.buffer[this.pos];
        if (c2 == 't' || c2 == 'T') {
            string2 = z[13];
            string = z[15];
            n2 = 5;
        } else if (c2 == 'f' || c2 == 'F') {
            string2 = z[16];
            string = z[14];
            n2 = 6;
        } else if (c2 == 'n' || c2 == 'N') {
            string2 = z[17];
            string = z[12];
            n2 = 7;
        } else {
            return 0;
        }
        int n3 = string2.length();
        for (int i2 = 1; i2 < n3; ++i2) {
            if (this.pos + i2 >= this.limit && !this.fillBuffer(i2 + 1)) {
                return 0;
            }
            c2 = this.buffer[this.pos + i2];
            if (c2 == string2.charAt(i2) || c2 == string.charAt(i2)) continue;
            return 0;
        }
        if ((this.pos + n3 < this.limit || this.fillBuffer(n3 + 1)) && this.isLiteral(this.buffer[this.pos + n3])) {
            return 0;
        }
        this.pos += n3;
        this.peeked = n2;
        return this.peeked;
    }

    private int peekNumber() throws IOException {
        char[] cArray = this.buffer;
        int n2 = this.pos;
        int n3 = this.limit;
        long l2 = 0L;
        boolean bl = false;
        boolean bl2 = true;
        int n4 = 0;
        int n5 = 0;
        block6: while (true) {
            if (n2 + n5 == n3) {
                if (n5 == cArray.length) {
                    return 0;
                }
                if (!this.fillBuffer(n5 + 1)) break;
                n2 = this.pos;
                n3 = this.limit;
            }
            char c2 = cArray[n2 + n5];
            switch (c2) {
                case '-': {
                    if (n4 == 0) {
                        bl = true;
                        n4 = 1;
                        break;
                    }
                    if (n4 == 5) {
                        n4 = 6;
                        break;
                    }
                    return 0;
                }
                case '+': {
                    if (n4 == 5) {
                        n4 = 6;
                        break;
                    }
                    return 0;
                }
                case 'E': 
                case 'e': {
                    if (n4 == 2 || n4 == 4) {
                        n4 = 5;
                        break;
                    }
                    return 0;
                }
                case '.': {
                    if (n4 == 2) {
                        n4 = 3;
                        break;
                    }
                    return 0;
                }
                default: {
                    if (c2 < '0' || c2 > '9') {
                        if (!this.isLiteral(c2)) break block6;
                        return 0;
                    }
                    if (n4 == 1 || n4 == 0) {
                        l2 = -(c2 - 48);
                        n4 = 2;
                        break;
                    }
                    if (n4 == 2) {
                        if (l2 == 0L) {
                            return 0;
                        }
                        long l3 = l2 * 10L - (long)(c2 - 48);
                        bl2 &= l2 > -922337203685477580L || l2 == -922337203685477580L && l3 < l2;
                        l2 = l3;
                        break;
                    }
                    if (n4 == 3) {
                        n4 = 4;
                        break;
                    }
                    if (n4 != 5 && n4 != 6) break;
                    n4 = 7;
                }
            }
            ++n5;
        }
        if (n4 == 2 && bl2 && (l2 != Long.MIN_VALUE || bl)) {
            this.peekedLong = bl ? l2 : -l2;
            this.pos += n5;
            this.peeked = 15;
            return 15;
        }
        if (n4 == 2 || n4 == 4 || n4 == 7) {
            this.peekedNumberLength = n5;
            this.peeked = 16;
            return 16;
        }
        return 0;
    }

    private boolean isLiteral(char c2) throws IOException {
        switch (c2) {
            case '#': 
            case '/': 
            case ';': 
            case '=': 
            case '\\': {
                this.checkLenient();
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    public String nextName() throws IOException {
        String string;
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 14) {
            string = this.nextUnquotedValue();
        } else if (n2 == 12) {
            string = this.nextQuotedValue('\'');
        } else if (n2 == 13) {
            string = this.nextQuotedValue('\"');
        } else {
            throw new IllegalStateException(z[34] + (Object)((Object)this.peek()) + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
        }
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = string;
        return string;
    }

    public String nextString() throws IOException {
        String string;
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 10) {
            string = this.nextUnquotedValue();
        } else if (n2 == 8) {
            string = this.nextQuotedValue('\'');
        } else if (n2 == 9) {
            string = this.nextQuotedValue('\"');
        } else if (n2 == 11) {
            string = this.peekedString;
            this.peekedString = null;
        } else if (n2 == 15) {
            string = Long.toString(this.peekedLong);
        } else if (n2 == 16) {
            string = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else {
            throw new IllegalStateException(z[11] + (Object)((Object)this.peek()) + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
        }
        this.peeked = 0;
        int n3 = this.stackSize - 1;
        this.pathIndices[n3] = this.pathIndices[n3] + 1;
        return string;
    }

    public boolean nextBoolean() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 5) {
            this.peeked = 0;
            int n3 = this.stackSize - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
            return true;
        }
        if (n2 == 6) {
            this.peeked = 0;
            int n4 = this.stackSize - 1;
            this.pathIndices[n4] = this.pathIndices[n4] + 1;
            return false;
        }
        throw new IllegalStateException(z[19] + (Object)((Object)this.peek()) + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
    }

    public void nextNull() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 7) {
            this.peeked = 0;
            int n3 = this.stackSize - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
            return;
        }
        throw new IllegalStateException(z[3] + (Object)((Object)this.peek()) + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
    }

    public double nextDouble() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 15) {
            this.peeked = 0;
            int n3 = this.stackSize - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
            return this.peekedLong;
        }
        if (n2 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n2 == 8 || n2 == 9) {
            this.peekedString = this.nextQuotedValue(n2 == 8 ? (char)'\'' : '\"');
        } else if (n2 == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (n2 != 11) {
            throw new IllegalStateException(z[7] + (Object)((Object)this.peek()) + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
        }
        this.peeked = 11;
        double d2 = Double.parseDouble(this.peekedString);
        if (!this.lenient && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            throw new MalformedJsonException(z[8] + d2 + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n4 = this.stackSize - 1;
        this.pathIndices[n4] = this.pathIndices[n4] + 1;
        return d2;
    }

    public long nextLong() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 15) {
            this.peeked = 0;
            int n3 = this.stackSize - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
            return this.peekedLong;
        }
        if (n2 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n2 == 8 || n2 == 9) {
            this.peekedString = this.nextQuotedValue(n2 == 8 ? (char)'\'' : '\"');
            try {
                long l2 = Long.parseLong(this.peekedString);
                this.peeked = 0;
                int n4 = this.stackSize - 1;
                this.pathIndices[n4] = this.pathIndices[n4] + 1;
                return l2;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            throw new IllegalStateException(z[10] + (Object)((Object)this.peek()) + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
        }
        this.peeked = 11;
        double d2 = Double.parseDouble(this.peekedString);
        long l3 = (long)d2;
        if ((double)l3 != d2) {
            throw new NumberFormatException(z[10] + this.peekedString + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n5 = this.stackSize - 1;
        this.pathIndices[n5] = this.pathIndices[n5] + 1;
        return l3;
    }

    private String nextQuotedValue(char c2) throws IOException {
        char[] cArray = this.buffer;
        StringBuilder stringBuilder = new StringBuilder();
        block0: while (true) {
            int n2 = this.pos;
            int n3 = this.limit;
            int n4 = n2;
            while (n2 < n3) {
                char c3;
                if ((c3 = cArray[n2++]) == c2) {
                    this.pos = n2;
                    stringBuilder.append(cArray, n4, n2 - n4 - 1);
                    return stringBuilder.toString();
                }
                if (c3 == '\\') {
                    this.pos = n2;
                    stringBuilder.append(cArray, n4, n2 - n4 - 1);
                    stringBuilder.append(this.readEscapeCharacter());
                    continue block0;
                }
                if (c3 != '\n') continue;
                ++this.lineNumber;
                this.lineStart = n2;
            }
            stringBuilder.append(cArray, n4, n2 - n4);
            this.pos = n2;
            if (!this.fillBuffer(1)) break;
        }
        throw this.syntaxError(z[33]);
    }

    private String nextUnquotedValue() throws IOException {
        CharSequence charSequence = null;
        int n2 = 0;
        block4: while (true) {
            if (this.pos + n2 < this.limit) {
                switch (this.buffer[this.pos + n2]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        break block4;
                    }
                    default: {
                        ++n2;
                        break;
                    }
                }
                continue;
            }
            if (n2 < this.buffer.length) {
                if (!this.fillBuffer(n2 + 1)) break;
                continue;
            }
            if (charSequence == null) {
                charSequence = new StringBuilder();
            }
            ((StringBuilder)charSequence).append(this.buffer, this.pos, n2);
            this.pos += n2;
            n2 = 0;
            if (!this.fillBuffer(1)) break;
        }
        if (charSequence == null) {
            charSequence = new String(this.buffer, this.pos, n2);
        } else {
            ((StringBuilder)charSequence).append(this.buffer, this.pos, n2);
            charSequence = ((StringBuilder)charSequence).toString();
        }
        this.pos += n2;
        return charSequence;
    }

    private void skipQuotedValue(char c2) throws IOException {
        char[] cArray = this.buffer;
        block0: while (true) {
            int n2 = this.pos;
            int n3 = this.limit;
            while (n2 < n3) {
                char c3;
                if ((c3 = cArray[n2++]) == c2) {
                    this.pos = n2;
                    return;
                }
                if (c3 == '\\') {
                    this.pos = n2;
                    this.readEscapeCharacter();
                    continue block0;
                }
                if (c3 != '\n') continue;
                ++this.lineNumber;
                this.lineStart = n2;
            }
            this.pos = n2;
            if (!this.fillBuffer(1)) break;
        }
        throw this.syntaxError(z[33]);
    }

    private void skipUnquotedValue() throws IOException {
        do {
            int n2 = 0;
            while (this.pos + n2 < this.limit) {
                switch (this.buffer[this.pos + n2]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        this.pos += n2;
                        return;
                    }
                }
                ++n2;
            }
            this.pos += n2;
        } while (this.fillBuffer(1));
    }

    public int nextInt() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 15) {
            n2 = (int)this.peekedLong;
            if (this.peekedLong != (long)n2) {
                throw new NumberFormatException(z[30] + this.peekedLong + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
            }
            this.peeked = 0;
            int n3 = this.stackSize - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
            return n2;
        }
        if (n2 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n2 == 8 || n2 == 9) {
            this.peekedString = this.nextQuotedValue(n2 == 8 ? (char)'\'' : '\"');
            try {
                n2 = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                int n4 = this.stackSize - 1;
                this.pathIndices[n4] = this.pathIndices[n4] + 1;
                return n2;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            throw new IllegalStateException(z[30] + (Object)((Object)this.peek()) + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
        }
        this.peeked = 11;
        double d2 = Double.parseDouble(this.peekedString);
        n2 = (int)d2;
        if ((double)n2 != d2) {
            throw new NumberFormatException(z[30] + this.peekedString + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n5 = this.stackSize - 1;
        this.pathIndices[n5] = this.pathIndices[n5] + 1;
        return n2;
    }

    @Override
    public void close() throws IOException {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.in.close();
    }

    public void skipValue() throws IOException {
        int n2 = 0;
        do {
            int n3;
            if ((n3 = this.peeked) == 0) {
                n3 = this.doPeek();
            }
            if (n3 == 3) {
                this.push(1);
                ++n2;
            } else if (n3 == 1) {
                this.push(3);
                ++n2;
            } else if (n3 == 4) {
                --this.stackSize;
                --n2;
            } else if (n3 == 2) {
                --this.stackSize;
                --n2;
            } else if (n3 == 14 || n3 == 10) {
                this.skipUnquotedValue();
            } else if (n3 == 8 || n3 == 12) {
                this.skipQuotedValue('\'');
            } else if (n3 == 9 || n3 == 13) {
                this.skipQuotedValue('\"');
            } else if (n3 == 16) {
                this.pos += this.peekedNumberLength;
            }
            this.peeked = 0;
        } while (n2 != 0);
        int n4 = this.stackSize - 1;
        this.pathIndices[n4] = this.pathIndices[n4] + 1;
        this.pathNames[this.stackSize - 1] = z[17];
    }

    private void push(int n2) {
        if (this.stackSize == this.stack.length) {
            int[] nArray = new int[this.stackSize * 2];
            int[] nArray2 = new int[this.stackSize * 2];
            String[] stringArray = new String[this.stackSize * 2];
            System.arraycopy(this.stack, 0, nArray, 0, this.stackSize);
            System.arraycopy(this.pathIndices, 0, nArray2, 0, this.stackSize);
            System.arraycopy(this.pathNames, 0, stringArray, 0, this.stackSize);
            this.stack = nArray;
            this.pathIndices = nArray2;
            this.pathNames = stringArray;
        }
        this.stack[this.stackSize++] = n2;
    }

    private boolean fillBuffer(int n2) throws IOException {
        int n3;
        char[] cArray = this.buffer;
        this.lineStart -= this.pos;
        if (this.limit != this.pos) {
            this.limit -= this.pos;
            System.arraycopy(cArray, this.pos, cArray, 0, this.limit);
        } else {
            this.limit = 0;
        }
        this.pos = 0;
        while ((n3 = this.in.read(cArray, this.limit, cArray.length - this.limit)) != -1) {
            this.limit += n3;
            if (this.lineNumber == 0 && this.lineStart == 0 && this.limit > 0 && cArray[0] == '\ufeff') {
                ++this.pos;
                ++this.lineStart;
                ++n2;
            }
            if (this.limit < n2) continue;
            return true;
        }
        return false;
    }

    private int getLineNumber() {
        return this.lineNumber + 1;
    }

    private int getColumnNumber() {
        return this.pos - this.lineStart + 1;
    }

    private int nextNonWhitespace(boolean bl) throws IOException {
        block12: {
            char c2;
            char[] cArray = this.buffer;
            int n2 = this.pos;
            int n3 = this.limit;
            block4: while (true) {
                if (n2 == n3) {
                    this.pos = n2;
                    if (!this.fillBuffer(1)) break block12;
                    n2 = this.pos;
                    n3 = this.limit;
                }
                if ((c2 = cArray[n2++]) == '\n') {
                    ++this.lineNumber;
                    this.lineStart = n2;
                    continue;
                }
                if (c2 == ' ' || c2 == '\r' || c2 == '\t') continue;
                if (c2 == '/') {
                    this.pos = n2;
                    if (n2 == n3) {
                        --this.pos;
                        n2 = this.fillBuffer(2) ? 1 : 0;
                        ++this.pos;
                        if (n2 == 0) {
                            return c2;
                        }
                    }
                    this.checkLenient();
                    switch (cArray[this.pos]) {
                        case '*': {
                            ++this.pos;
                            if (!this.skipTo(z[29])) {
                                throw this.syntaxError(z[28]);
                            }
                            n2 = this.pos + 2;
                            n3 = this.limit;
                            continue block4;
                        }
                        case '/': {
                            ++this.pos;
                            this.skipToEndOfLine();
                            n2 = this.pos;
                            n3 = this.limit;
                            continue block4;
                        }
                    }
                    return c2;
                }
                if (c2 != '#') break;
                this.pos = n2;
                this.checkLenient();
                this.skipToEndOfLine();
                n2 = this.pos;
                n3 = this.limit;
            }
            this.pos = n2;
            return c2;
        }
        if (bl) {
            throw new EOFException(z[27] + this.getLineNumber() + z[1] + this.getColumnNumber());
        }
        return -1;
    }

    private void checkLenient() throws IOException {
        if (!this.lenient) {
            throw this.syntaxError(z[35]);
        }
    }

    private void skipToEndOfLine() throws IOException {
        while (this.pos < this.limit || this.fillBuffer(1)) {
            char c2;
            if ((c2 = this.buffer[this.pos++]) == '\n') {
                ++this.lineNumber;
                this.lineStart = this.pos;
                return;
            }
            if (c2 != '\r') continue;
        }
    }

    private boolean skipTo(String string) throws IOException {
        while (this.pos + string.length() <= this.limit || this.fillBuffer(string.length())) {
            block5: {
                if (this.buffer[this.pos] == '\n') {
                    ++this.lineNumber;
                    this.lineStart = this.pos + 1;
                } else {
                    for (int i2 = 0; i2 < string.length(); ++i2) {
                        if (this.buffer[this.pos + i2] == string.charAt(i2)) {
                            continue;
                        }
                        break block5;
                    }
                    return true;
                }
            }
            ++this.pos;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber();
    }

    public String getPath() {
        StringBuilder stringBuilder = new StringBuilder("$");
        int n2 = this.stackSize;
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            switch (this.stack[i2]) {
                case 1: 
                case 2: {
                    stringBuilder.append('[').append(this.pathIndices[i2]).append(']');
                    continue block4;
                }
                case 3: 
                case 4: 
                case 5: {
                    stringBuilder.append('.');
                    if (this.pathNames[i2] == null) continue block4;
                    stringBuilder.append(this.pathNames[i2]);
                }
            }
        }
        return stringBuilder.toString();
    }

    private char readEscapeCharacter() throws IOException {
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            throw this.syntaxError(z[32]);
        }
        char c2 = this.buffer[this.pos++];
        switch (c2) {
            case 'u': {
                int n2;
                if (this.pos + 4 > this.limit && !this.fillBuffer(4)) {
                    throw this.syntaxError(z[32]);
                }
                c2 = '\u0000';
                int n3 = n2 + 4;
                for (n2 = this.pos; n2 < n3; ++n2) {
                    char c3 = this.buffer[n2];
                    c2 = (char)(c2 << 4);
                    if (c3 >= '0' && c3 <= '9') {
                        c2 = (char)(c2 + (c3 - 48));
                        continue;
                    }
                    if (c3 >= 'a' && c3 <= 'f') {
                        c2 = (char)(c2 + (c3 - 97 + 10));
                        continue;
                    }
                    if (c3 >= 'A' && c3 <= 'F') {
                        c2 = (char)(c2 + (c3 - 65 + 10));
                        continue;
                    }
                    throw new NumberFormatException(z[31] + new String(this.buffer, this.pos, 4));
                }
                this.pos += 4;
                return c2;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case '\n': {
                ++this.lineNumber;
                this.lineStart = this.pos;
            }
        }
        return c2;
    }

    private IOException syntaxError(String string) throws IOException {
        throw new MalformedJsonException(string + z[2] + this.getLineNumber() + z[1] + this.getColumnNumber() + z[0] + this.getPath());
    }

    private void consumeNonExecutePrefix() throws IOException {
        this.nextNonWhitespace(true);
        --this.pos;
        if (this.pos + NON_EXECUTE_PREFIX.length > this.limit && !this.fillBuffer(NON_EXECUTE_PREFIX.length)) {
            return;
        }
        for (int i2 = 0; i2 < NON_EXECUTE_PREFIX.length; ++i2) {
            if (this.buffer[this.pos + i2] == NON_EXECUTE_PREFIX[i2]) continue;
            return;
        }
        this.pos += NON_EXECUTE_PREFIX.length;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block59: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block58: {
                String string;
                String[] stringArray = new String[36];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n5 = 0;
                String string2 = "2!\u0012p\r2";
                int n6 = -1;
                block49: while (true) {
                    char[] cArray3;
                    block57: {
                        int n7;
                        int n8;
                        char[] cArray4;
                        block56: {
                            char[] cArray5 = string2.toCharArray();
                            n4 = 0;
                            int n9 = cArray5.length;
                            cArray4 = cArray5;
                            n8 = n9;
                            if (n9 <= 1) break block56;
                            cArray3 = cArray4;
                            n7 = n8;
                            if (n8 <= n4) break block57;
                        }
                        do {
                            char[] cArray6 = cArray4;
                            char[] cArray7 = cArray4;
                            int n10 = n4;
                            while (true) {
                                int n11;
                                char c2 = cArray6[n10];
                                switch (n4 % 5) {
                                    case 0: {
                                        n11 = 18;
                                        break;
                                    }
                                    case 1: {
                                        n11 = 81;
                                        break;
                                    }
                                    case 2: {
                                        n11 = 115;
                                        break;
                                    }
                                    case 3: {
                                        n11 = 4;
                                        break;
                                    }
                                    default: {
                                        n11 = 101;
                                    }
                                }
                                cArray6[n10] = (char)(c2 ^ n11);
                                ++n4;
                                cArray4 = cArray7;
                                n8 = n8;
                                if (n8 != 0) break;
                                cArray7 = cArray4;
                                n7 = n8;
                                n10 = n8;
                                cArray6 = cArray4;
                            }
                            cArray3 = cArray4;
                            n7 = n8;
                        } while (n8 > n4);
                    }
                    string = new String(cArray3);
                    switch (n6) {
                        default: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 1;
                            string2 = "22\u001ch\u0010\u007f?S";
                            n6 = 0;
                            continue block49;
                        }
                        case 0: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 2;
                            string2 = "20\u0007$\t{?\u0016$";
                            n6 = 1;
                            continue block49;
                        }
                        case 1: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 3;
                            string2 = "W)\u0003a\u0006f4\u0017$\u000bg=\u001f$\u0007g%Ss\u0004aq";
                            n6 = 2;
                            continue block49;
                        }
                        case 2: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 4;
                            string2 = "W)\u0003a\u0006f4\u0017$ \\\u0015,K'X\u00140PEp$\u0007$\u0012s\"S";
                            n6 = 3;
                            continue block49;
                        }
                        case 3: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 5;
                            string2 = "W)\u0003a\u0006f4\u0017$'W\u0016:J:S\u0003!E<23\u0006pEe0\u0000$";
                            n6 = 4;
                            continue block49;
                        }
                        case 4: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 6;
                            string2 = "W)\u0003a\u0006f4\u0017$'W\u0016:J:]\u00139A&Fq\u0011q\u00112&\u0012wE";
                            n6 = 5;
                            continue block49;
                        }
                        case 5: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 7;
                            string2 = "W)\u0003a\u0006f4\u0017$\u000425\u001cq\u0007~4Sf\u0010fq\u0004e\u00162";
                            n6 = 6;
                            continue block49;
                        }
                        case 6: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 8;
                            string2 = "X\u0002<JEt>\u0001f\fv\"SJ\u0004\\q\u0012j\u000128\u001db\f|8\u0007m\u0000akS";
                            n6 = 7;
                            continue block49;
                        }
                        case 7: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 9;
                            string2 = "W)\u0003a\u0006f4\u0017$ \\\u0015,E7@\u0010*$\u0007g%Ss\u0004aq";
                            n6 = 8;
                            continue block49;
                        }
                        case 8: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 10;
                            string2 = "W)\u0003a\u0006f4\u0017$\u00042=\u001cj\u000223\u0006pEe0\u0000$";
                            n6 = 9;
                            continue block49;
                        }
                        case 9: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 11;
                            string2 = "W)\u0003a\u0006f4\u0017$\u00042\"\u0007v\f|6Sf\u0010fq\u0004e\u00162";
                            n6 = 10;
                            continue block49;
                        }
                        case 10: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 12;
                            string2 = "\\\u0004?H";
                            n6 = 11;
                            continue block49;
                        }
                        case 11: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 13;
                            string2 = "f#\u0006a";
                            n6 = 12;
                            continue block49;
                        }
                        case 12: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 14;
                            string2 = "T\u0010?W ";
                            n6 = 13;
                            continue block49;
                        }
                        case 13: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 15;
                            string2 = "F\u0003&A";
                            n6 = 14;
                            continue block49;
                        }
                        case 14: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 16;
                            string2 = "t0\u001fw\u0000";
                            n6 = 15;
                            continue block49;
                        }
                        case 15: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 17;
                            string2 = "|$\u001fh";
                            n6 = 16;
                            continue block49;
                        }
                        case 16: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 18;
                            string2 = "{?S9X2?\u0006h\t";
                            n6 = 17;
                            continue block49;
                        }
                        case 17: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 19;
                            string2 = "W)\u0003a\u0006f4\u0017$\u000423\u001ck\tw0\u001d$\u0007g%Ss\u0004aq";
                            n6 = 18;
                            continue block49;
                        }
                        case 18: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 20;
                            string2 = "W)\u0003a\u0006f4\u0017$B(v";
                            n6 = 19;
                            continue block49;
                        }
                        case 19: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 21;
                            string2 = "G?\u0007a\u0017\u007f8\u001de\u0011w5Se\u0017`0\n";
                            n6 = 20;
                            continue block49;
                        }
                        case 20: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 22;
                            string2 = "W)\u0003a\u0006f4\u0017$\u0013s=\u0006a";
                            n6 = 21;
                            continue block49;
                        }
                        case 21: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 23;
                            string2 = "X\"\u001cj7w0\u0017a\u001728\u0000$\u0006~>\u0000a\u0001";
                            n6 = 22;
                            continue block49;
                        }
                        case 22: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 24;
                            string2 = "G?\u0007a\u0017\u007f8\u001de\u0011w5Sk\u0007x4\u0010p";
                            n6 = 23;
                            continue block49;
                        }
                        case 23: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 25;
                            string2 = "G?\u0016|\u0015w2\u0007a\u00012'\u0012h\u0010w";
                            n6 = 24;
                            continue block49;
                        }
                        case 24: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 26;
                            string2 = "W)\u0003a\u0006f4\u0017$\u000bs<\u0016";
                            n6 = 25;
                            continue block49;
                        }
                        case 25: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 27;
                            string2 = "W?\u0017$\ntq\u001aj\u0015g%Se\u00112=\u001aj\u00002";
                            n6 = 26;
                            continue block49;
                        }
                        case 26: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 28;
                            string2 = "G?\u0007a\u0017\u007f8\u001de\u0011w5Sg\n\u007f<\u0016j\u0011";
                            n6 = 27;
                            continue block49;
                        }
                        case 27: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 29;
                            string2 = "8~";
                            n6 = 28;
                            continue block49;
                        }
                        case 28: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 30;
                            string2 = "W)\u0003a\u0006f4\u0017$\u0004|q\u001aj\u001123\u0006pEe0\u0000$";
                            n6 = 29;
                            continue block49;
                        }
                        case 29: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 31;
                            string2 = "N$";
                            n6 = 30;
                            continue block49;
                        }
                        case 30: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 32;
                            string2 = "G?\u0007a\u0017\u007f8\u001de\u0011w5Sa\u0016q0\u0003aEa4\u0002q\u0000|2\u0016";
                            n6 = 31;
                            continue block49;
                        }
                        case 31: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 33;
                            string2 = "G?\u0007a\u0017\u007f8\u001de\u0011w5Sw\u0011`8\u001dc";
                            n6 = 32;
                            continue block49;
                        }
                        case 32: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 34;
                            string2 = "W)\u0003a\u0006f4\u0017$\u00042?\u0012i\u000023\u0006pEe0\u0000$";
                            n6 = 33;
                            continue block49;
                        }
                        case 33: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 35;
                            string2 = "G\"\u0016$/a>\u001dV\u0000s5\u0016vKa4\u0007H\u0000|8\u0016j\u0011:%\u0001q\u0000;q\u0007kEs2\u0010a\u0015fq\u001ee\tt>\u0001i\u0000vq9W*\\";
                            n6 = 34;
                            continue block49;
                        }
                        case 34: 
                    }
                    break;
                }
                stringArray2[n5] = string.intern();
                z = stringArray3;
                char[] cArray8 = ";\f\u000e#o".toCharArray();
                n4 = 0;
                int n12 = cArray8.length;
                cArray2 = cArray8;
                n3 = n12;
                if (n12 <= 1) break block58;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block59;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n13 = n4;
                while (true) {
                    int n14;
                    char c3 = cArray9[n13];
                    switch (n4 % 5) {
                        case 0: {
                            n14 = 18;
                            break;
                        }
                        case 1: {
                            n14 = 81;
                            break;
                        }
                        case 2: {
                            n14 = 115;
                            break;
                        }
                        case 3: {
                            n14 = 4;
                            break;
                        }
                        default: {
                            n14 = 101;
                        }
                    }
                    cArray9[n13] = (char)(c3 ^ n14);
                    ++n4;
                    cArray2 = cArray10;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray10 = cArray2;
                    n2 = n3;
                    n13 = n3;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        NON_EXECUTE_PREFIX = new String(cArray).intern().toCharArray();
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){
            private static final String[] z;

            @Override
            public final void promoteNameToValue(JsonReader jsonReader) throws IOException {
                if (jsonReader instanceof JsonTreeReader) {
                    ((JsonTreeReader)jsonReader).promoteNameToValue();
                    return;
                }
                int n2 = jsonReader.peeked;
                if (n2 == 0) {
                    n2 = jsonReader.doPeek();
                }
                if (n2 == 13) {
                    jsonReader.peeked = 9;
                    return;
                }
                if (n2 == 12) {
                    jsonReader.peeked = 8;
                    return;
                }
                if (n2 == 14) {
                    jsonReader.peeked = 10;
                    return;
                }
                throw new IllegalStateException(z[3] + (Object)((Object)jsonReader.peek()) + z[1] + jsonReader.getLineNumber() + z[0] + jsonReader.getColumnNumber() + z[2] + jsonReader.getPath());
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                String string;
                String[] stringArray = new String[4];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n2 = 0;
                String string2 = "NU\u000e\u000bi\u0003XA";
                int n3 = -1;
                block11: while (true) {
                    char[] cArray;
                    block16: {
                        int n4;
                        int n5;
                        char[] cArray2;
                        int n6;
                        block15: {
                            char[] cArray3 = string2.toCharArray();
                            n6 = 0;
                            int n7 = cArray3.length;
                            cArray2 = cArray3;
                            n5 = n7;
                            if (n7 <= 1) break block15;
                            cArray = cArray2;
                            n4 = n5;
                            if (n5 <= n6) break block16;
                        }
                        do {
                            char[] cArray4 = cArray2;
                            char[] cArray5 = cArray2;
                            int n8 = n6;
                            while (true) {
                                int n9;
                                char c2 = cArray4[n8];
                                switch (n6 % 5) {
                                    case 0: {
                                        n9 = 110;
                                        break;
                                    }
                                    case 1: {
                                        n9 = 54;
                                        break;
                                    }
                                    case 2: {
                                        n9 = 97;
                                        break;
                                    }
                                    case 3: {
                                        n9 = 103;
                                        break;
                                    }
                                    default: {
                                        n9 = 28;
                                    }
                                }
                                cArray4[n8] = (char)(c2 ^ n9);
                                ++n6;
                                cArray2 = cArray5;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray5 = cArray2;
                                n4 = n5;
                                n8 = n5;
                                cArray4 = cArray2;
                            }
                            cArray = cArray2;
                            n4 = n5;
                        } while (n5 > n6);
                    }
                    string = new String(cArray);
                    switch (n3) {
                        default: {
                            stringArray2[n2] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n2 = 1;
                            string2 = "N\u0016\u0000\u0013<\u0002_\u000f\u0002<";
                            n3 = 0;
                            continue block11;
                        }
                        case 0: {
                            stringArray2[n2] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n2 = 2;
                            string2 = "NF\u0000\u0013tN";
                            n3 = 1;
                            continue block11;
                        }
                        case 1: {
                            stringArray2[n2] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n2 = 3;
                            string2 = "+N\u0011\u0002\u007f\u001aS\u0005G}NX\u0000\nyNT\u0014\u0013<\u0019W\u0012G";
                            n3 = 2;
                            continue block11;
                        }
                        case 2: 
                    }
                    break;
                }
                stringArray2[n2] = string.intern();
                z = stringArray3;
            }
        };
    }
}

