/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.jpush;

import com.google.protobuf.jpush.ByteString;
import com.google.protobuf.jpush.MessageLite;
import com.google.protobuf.jpush.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class CodedOutputStream {
    private final byte[] buffer;
    private final int limit;
    private int position;
    private final OutputStream output;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int LITTLE_ENDIAN_64_SIZE = 8;
    private static final String[] z;

    static int computePreferredBufferSize(int n2) {
        if (n2 > 4096) {
            return 4096;
        }
        return n2;
    }

    private CodedOutputStream(byte[] byArray, int n2, int n3) {
        this.output = null;
        this.buffer = byArray;
        this.position = n2;
        this.limit = n2 + n3;
    }

    private CodedOutputStream(OutputStream outputStream, byte[] byArray) {
        this.output = outputStream;
        this.buffer = byArray;
        this.position = 0;
        this.limit = byArray.length;
    }

    public static CodedOutputStream newInstance(OutputStream outputStream) {
        return CodedOutputStream.newInstance(outputStream, 4096);
    }

    public static CodedOutputStream newInstance(OutputStream outputStream, int n2) {
        return new CodedOutputStream(outputStream, new byte[n2]);
    }

    public static CodedOutputStream newInstance(byte[] byArray) {
        return CodedOutputStream.newInstance(byArray, 0, byArray.length);
    }

    public static CodedOutputStream newInstance(byte[] byArray, int n2, int n3) {
        return new CodedOutputStream(byArray, n2, n3);
    }

    public final void writeDouble(int n2, double d2) throws IOException {
        this.writeTag(n2, 1);
        this.writeDoubleNoTag(d2);
    }

    public final void writeFloat(int n2, float f2) throws IOException {
        this.writeTag(n2, 5);
        this.writeFloatNoTag(f2);
    }

    public final void writeUInt64(int n2, long l2) throws IOException {
        this.writeTag(n2, 0);
        this.writeUInt64NoTag(l2);
    }

    public final void writeInt64(int n2, long l2) throws IOException {
        this.writeTag(n2, 0);
        this.writeInt64NoTag(l2);
    }

    public final void writeInt32(int n2, int n3) throws IOException {
        this.writeTag(n2, 0);
        this.writeInt32NoTag(n3);
    }

    public final void writeFixed64(int n2, long l2) throws IOException {
        this.writeTag(n2, 1);
        this.writeFixed64NoTag(l2);
    }

    public final void writeFixed32(int n2, int n3) throws IOException {
        this.writeTag(n2, 5);
        this.writeFixed32NoTag(n3);
    }

    public final void writeBool(int n2, boolean bl) throws IOException {
        this.writeTag(n2, 0);
        this.writeBoolNoTag(bl);
    }

    public final void writeString(int n2, String string) throws IOException {
        this.writeTag(n2, 2);
        this.writeStringNoTag(string);
    }

    public final void writeGroup(int n2, MessageLite messageLite) throws IOException {
        this.writeTag(n2, 3);
        this.writeGroupNoTag(messageLite);
        this.writeTag(n2, 4);
    }

    @Deprecated
    public final void writeUnknownGroup(int n2, MessageLite messageLite) throws IOException {
        this.writeGroup(n2, messageLite);
    }

    public final void writeMessage(int n2, MessageLite messageLite) throws IOException {
        this.writeTag(n2, 2);
        this.writeMessageNoTag(messageLite);
    }

    public final void writeBytes(int n2, ByteString byteString) throws IOException {
        this.writeTag(n2, 2);
        this.writeBytesNoTag(byteString);
    }

    public final void writeUInt32(int n2, int n3) throws IOException {
        this.writeTag(n2, 0);
        this.writeUInt32NoTag(n3);
    }

    public final void writeEnum(int n2, int n3) throws IOException {
        this.writeTag(n2, 0);
        this.writeEnumNoTag(n3);
    }

    public final void writeSFixed32(int n2, int n3) throws IOException {
        this.writeTag(n2, 5);
        this.writeSFixed32NoTag(n3);
    }

    public final void writeSFixed64(int n2, long l2) throws IOException {
        this.writeTag(n2, 1);
        this.writeSFixed64NoTag(l2);
    }

    public final void writeSInt32(int n2, int n3) throws IOException {
        this.writeTag(n2, 0);
        this.writeSInt32NoTag(n3);
    }

    public final void writeSInt64(int n2, long l2) throws IOException {
        this.writeTag(n2, 0);
        this.writeSInt64NoTag(l2);
    }

    public final void writeMessageSetExtension(int n2, MessageLite messageLite) throws IOException {
        this.writeTag(1, 3);
        this.writeUInt32(2, n2);
        this.writeMessage(3, messageLite);
        this.writeTag(1, 4);
    }

    public final void writeRawMessageSetExtension(int n2, ByteString byteString) throws IOException {
        this.writeTag(1, 3);
        this.writeUInt32(2, n2);
        this.writeBytes(3, byteString);
        this.writeTag(1, 4);
    }

    public final void writeDoubleNoTag(double d2) throws IOException {
        this.writeRawLittleEndian64(Double.doubleToRawLongBits(d2));
    }

    public final void writeFloatNoTag(float f2) throws IOException {
        this.writeRawLittleEndian32(Float.floatToRawIntBits(f2));
    }

    public final void writeUInt64NoTag(long l2) throws IOException {
        this.writeRawVarint64(l2);
    }

    public final void writeInt64NoTag(long l2) throws IOException {
        this.writeRawVarint64(l2);
    }

    public final void writeInt32NoTag(int n2) throws IOException {
        if (n2 >= 0) {
            this.writeRawVarint32(n2);
            return;
        }
        this.writeRawVarint64(n2);
    }

    public final void writeFixed64NoTag(long l2) throws IOException {
        this.writeRawLittleEndian64(l2);
    }

    public final void writeFixed32NoTag(int n2) throws IOException {
        this.writeRawLittleEndian32(n2);
    }

    public final void writeBoolNoTag(boolean bl) throws IOException {
        this.writeRawByte(bl ? 1 : 0);
    }

    public final void writeStringNoTag(String object) throws IOException {
        object = ((String)object).getBytes(z[1]);
        this.writeRawVarint32(((Object)object).length);
        this.writeRawBytes((byte[])object);
    }

    public final void writeGroupNoTag(MessageLite messageLite) throws IOException {
        messageLite.writeTo(this);
    }

    @Deprecated
    public final void writeUnknownGroupNoTag(MessageLite messageLite) throws IOException {
        this.writeGroupNoTag(messageLite);
    }

    public final void writeMessageNoTag(MessageLite messageLite) throws IOException {
        this.writeRawVarint32(messageLite.getSerializedSize());
        messageLite.writeTo(this);
    }

    public final void writeBytesNoTag(ByteString byteString) throws IOException {
        this.writeRawVarint32(byteString.size());
        this.writeRawBytes(byteString);
    }

    public final void writeUInt32NoTag(int n2) throws IOException {
        this.writeRawVarint32(n2);
    }

    public final void writeEnumNoTag(int n2) throws IOException {
        this.writeInt32NoTag(n2);
    }

    public final void writeSFixed32NoTag(int n2) throws IOException {
        this.writeRawLittleEndian32(n2);
    }

    public final void writeSFixed64NoTag(long l2) throws IOException {
        this.writeRawLittleEndian64(l2);
    }

    public final void writeSInt32NoTag(int n2) throws IOException {
        this.writeRawVarint32(CodedOutputStream.encodeZigZag32(n2));
    }

    public final void writeSInt64NoTag(long l2) throws IOException {
        this.writeRawVarint64(CodedOutputStream.encodeZigZag64(l2));
    }

    public static int computeDoubleSize(int n2, double d2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeDoubleSizeNoTag(d2);
    }

    public static int computeFloatSize(int n2, float f2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeFloatSizeNoTag(f2);
    }

    public static int computeUInt64Size(int n2, long l2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeUInt64SizeNoTag(l2);
    }

    public static int computeInt64Size(int n2, long l2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeInt64SizeNoTag(l2);
    }

    public static int computeInt32Size(int n2, int n3) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeInt32SizeNoTag(n3);
    }

    public static int computeFixed64Size(int n2, long l2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeFixed64SizeNoTag(l2);
    }

    public static int computeFixed32Size(int n2, int n3) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeFixed32SizeNoTag(n3);
    }

    public static int computeBoolSize(int n2, boolean bl) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeBoolSizeNoTag(bl);
    }

    public static int computeStringSize(int n2, String string) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeStringSizeNoTag(string);
    }

    public static int computeGroupSize(int n2, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(n2) * 2 + CodedOutputStream.computeGroupSizeNoTag(messageLite);
    }

    @Deprecated
    public static int computeUnknownGroupSize(int n2, MessageLite messageLite) {
        return CodedOutputStream.computeGroupSize(n2, messageLite);
    }

    public static int computeMessageSize(int n2, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeMessageSizeNoTag(messageLite);
    }

    public static int computeBytesSize(int n2, ByteString byteString) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeBytesSizeNoTag(byteString);
    }

    public static int computeUInt32Size(int n2, int n3) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeUInt32SizeNoTag(n3);
    }

    public static int computeEnumSize(int n2, int n3) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeEnumSizeNoTag(n3);
    }

    public static int computeSFixed32Size(int n2, int n3) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeSFixed32SizeNoTag(n3);
    }

    public static int computeSFixed64Size(int n2, long l2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeSFixed64SizeNoTag(l2);
    }

    public static int computeSInt32Size(int n2, int n3) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeSInt32SizeNoTag(n3);
    }

    public static int computeSInt64Size(int n2, long l2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeSInt64SizeNoTag(l2);
    }

    public static int computeMessageSetExtensionSize(int n2, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, n2) + CodedOutputStream.computeMessageSize(3, messageLite);
    }

    public static int computeRawMessageSetExtensionSize(int n2, ByteString byteString) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, n2) + CodedOutputStream.computeBytesSize(3, byteString);
    }

    public static int computeDoubleSizeNoTag(double d2) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float f2) {
        return 4;
    }

    public static int computeUInt64SizeNoTag(long l2) {
        return CodedOutputStream.computeRawVarint64Size(l2);
    }

    public static int computeInt64SizeNoTag(long l2) {
        return CodedOutputStream.computeRawVarint64Size(l2);
    }

    public static int computeInt32SizeNoTag(int n2) {
        if (n2 >= 0) {
            return CodedOutputStream.computeRawVarint32Size(n2);
        }
        return 10;
    }

    public static int computeFixed64SizeNoTag(long l2) {
        return 8;
    }

    public static int computeFixed32SizeNoTag(int n2) {
        return 4;
    }

    public static int computeBoolSizeNoTag(boolean bl) {
        return 1;
    }

    public static int computeStringSizeNoTag(String object) {
        try {
            byte[] byArray = ((String)object).getBytes(z[1]);
            object = byArray;
            return CodedOutputStream.computeRawVarint32Size(byArray.length) + ((Object)object).length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(z[0], unsupportedEncodingException);
        }
    }

    public static int computeGroupSizeNoTag(MessageLite messageLite) {
        return messageLite.getSerializedSize();
    }

    @Deprecated
    public static int computeUnknownGroupSizeNoTag(MessageLite messageLite) {
        return CodedOutputStream.computeGroupSizeNoTag(messageLite);
    }

    public static int computeMessageSizeNoTag(MessageLite messageLite) {
        int n2 = messageLite.getSerializedSize();
        return CodedOutputStream.computeRawVarint32Size(n2) + n2;
    }

    public static int computeBytesSizeNoTag(ByteString byteString) {
        return CodedOutputStream.computeRawVarint32Size(byteString.size()) + byteString.size();
    }

    public static int computeUInt32SizeNoTag(int n2) {
        return CodedOutputStream.computeRawVarint32Size(n2);
    }

    public static int computeEnumSizeNoTag(int n2) {
        return CodedOutputStream.computeInt32SizeNoTag(n2);
    }

    public static int computeSFixed32SizeNoTag(int n2) {
        return 4;
    }

    public static int computeSFixed64SizeNoTag(long l2) {
        return 8;
    }

    public static int computeSInt32SizeNoTag(int n2) {
        return CodedOutputStream.computeRawVarint32Size(CodedOutputStream.encodeZigZag32(n2));
    }

    public static int computeSInt64SizeNoTag(long l2) {
        return CodedOutputStream.computeRawVarint64Size(CodedOutputStream.encodeZigZag64(l2));
    }

    private void refreshBuffer() throws IOException {
        if (this.output == null) {
            throw new OutOfSpaceException();
        }
        this.output.write(this.buffer, 0, this.position);
        this.position = 0;
    }

    public final void flush() throws IOException {
        if (this.output != null) {
            this.refreshBuffer();
        }
    }

    public final int spaceLeft() {
        if (this.output == null) {
            return this.limit - this.position;
        }
        throw new UnsupportedOperationException(z[5]);
    }

    public final void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException(z[2]);
        }
    }

    public final void writeRawByte(byte by) throws IOException {
        if (this.position == this.limit) {
            this.refreshBuffer();
        }
        this.buffer[this.position++] = by;
    }

    public final void writeRawByte(int n2) throws IOException {
        this.writeRawByte((byte)n2);
    }

    public final void writeRawBytes(ByteString byteString) throws IOException {
        this.writeRawBytes(byteString, 0, byteString.size());
    }

    public final void writeRawBytes(byte[] byArray) throws IOException {
        this.writeRawBytes(byArray, 0, byArray.length);
    }

    public final void writeRawBytes(byte[] byArray, int n2, int n3) throws IOException {
        if (this.limit - this.position >= n3) {
            System.arraycopy(byArray, n2, this.buffer, this.position, n3);
            this.position += n3;
            return;
        }
        int n4 = this.limit - this.position;
        System.arraycopy(byArray, n2, this.buffer, this.position, n4);
        n2 += n4;
        this.position = this.limit;
        this.refreshBuffer();
        if ((n3 -= n4) <= this.limit) {
            System.arraycopy(byArray, n2, this.buffer, 0, n3);
            this.position = n3;
            return;
        }
        this.output.write(byArray, n2, n3);
    }

    public final void writeRawBytes(ByteString object, int n2, int n3) throws IOException {
        if (this.limit - this.position >= n3) {
            ((ByteString)object).copyTo(this.buffer, n2, this.position, n3);
            this.position += n3;
            return;
        }
        int n4 = this.limit - this.position;
        ((ByteString)object).copyTo(this.buffer, n2, this.position, n4);
        n2 += n4;
        this.position = this.limit;
        this.refreshBuffer();
        if ((n3 -= n4) <= this.limit) {
            ((ByteString)object).copyTo(this.buffer, n2, 0, n3);
            this.position = n3;
            return;
        }
        if ((long)n2 != ((InputStream)(object = ((ByteString)object).newInput())).skip(n2)) {
            throw new IllegalStateException(z[4]);
        }
        while (n3 > 0) {
            n2 = Math.min(n3, this.limit);
            n4 = ((InputStream)object).read(this.buffer, 0, n2);
            if (n4 != n2) {
                throw new IllegalStateException(z[3]);
            }
            this.output.write(this.buffer, 0, n4);
            n3 -= n4;
        }
    }

    public final void writeTag(int n2, int n3) throws IOException {
        this.writeRawVarint32(WireFormat.makeTag(n2, n3));
    }

    public static int computeTagSize(int n2) {
        return CodedOutputStream.computeRawVarint32Size(WireFormat.makeTag(n2, 0));
    }

    public final void writeRawVarint32(int n2) throws IOException {
        while (true) {
            if ((n2 & 0xFFFFFF80) == 0) {
                this.writeRawByte(n2);
                return;
            }
            this.writeRawByte(n2 & 0x7F | 0x80);
            n2 >>>= 7;
        }
    }

    public static int computeRawVarint32Size(int n2) {
        if ((n2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public final void writeRawVarint64(long l2) throws IOException {
        while (true) {
            if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)l2);
                return;
            }
            this.writeRawByte((int)l2 & 0x7F | 0x80);
            l2 >>>= 7;
        }
    }

    public static int computeRawVarint64Size(long l2) {
        if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l2 & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l2 & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l2 & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l2 & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l2 & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l2 & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l2 & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l2 & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public final void writeRawLittleEndian32(int n2) throws IOException {
        this.writeRawByte(n2 & 0xFF);
        this.writeRawByte(n2 >> 8 & 0xFF);
        this.writeRawByte(n2 >> 16 & 0xFF);
        this.writeRawByte(n2 >> 24 & 0xFF);
    }

    public final void writeRawLittleEndian64(long l2) throws IOException {
        this.writeRawByte((int)l2 & 0xFF);
        this.writeRawByte((int)(l2 >> 8) & 0xFF);
        this.writeRawByte((int)(l2 >> 16) & 0xFF);
        this.writeRawByte((int)(l2 >> 24) & 0xFF);
        this.writeRawByte((int)(l2 >> 32) & 0xFF);
        this.writeRawByte((int)(l2 >> 40) & 0xFF);
        this.writeRawByte((int)(l2 >> 48) & 0xFF);
        this.writeRawByte((int)(l2 >> 56) & 0xFF);
    }

    public static int encodeZigZag32(int n2) {
        return n2 << 1 ^ n2 >> 31;
    }

    public static long encodeZigZag64(long l2) {
        return l2 << 1 ^ l2 >> 63;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "|\u007f\u001b&I\tE2\u007fQZ^-{\u001e[_8o_";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 41;
                                break;
                            }
                            case 1: {
                                n9 = 43;
                                break;
                            }
                            case 2: {
                                n9 = 93;
                                break;
                            }
                            case 3: {
                                n9 = 11;
                                break;
                            }
                            default: {
                                n9 = 113;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "|\u007f\u001b&I";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "mB9+\u001fF_}|\u0003@_8+\u0010Z\u000b0~\u0012A\u000b9j\u0005H\u000b<xQLS-n\u0012]N9%";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "{N<oQOJ4g\u0014M\u0014}X\u0019F^1oQGN+n\u0003\tC<{\u0001LE";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "z@4{QOJ4g\u0014M\u0014}X\u0019F^1oQGN+n\u0003\tC<{\u0001LEs";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "Z[<h\u0014eN;\u007fY\u0000\u000b>j\u001f\tD3g\b\tI8+\u0012HG1n\u0015\tD3+2FO8o>\\_-~\u0005z_/n\u0010DX}\u007f\u0019H_}j\u0003L\u000b*y\u0018]B3lQ]D}jQOG<\u007fQHY/j\b\u0007";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;
        private static final String z;

        OutOfSpaceException() {
            super(z);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "<\tPy\u00130\u0013@l\u0002\u000b5@n\u0012\u001e\u000b\u0014k\u0016\fFCn\u001e\u000b\u000fZ{W\u000b\t\u0014}W\u0019\nUhW\u001d\u001f@yW\u001e\u0014F}\u000e_\u0007ZxW\r\u0007Z<\u0018\n\u0012\u0014s\u0011_\u0015D}\u0014\u001aH".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 127;
                                break;
                            }
                            case 1: {
                                n7 = 102;
                                break;
                            }
                            case 2: {
                                n7 = 52;
                                break;
                            }
                            case 3: {
                                n7 = 28;
                                break;
                            }
                            default: {
                                n7 = 119;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }
}

