/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils;

import android.util.Log;

public class LogUtil {
    private static final boolean DEBUG_MODE = false;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int OFF = 7;
    private static final String TAG = "LogUtil";
    private static final String PREFIX = "[BDASR_LOG] ";
    public static final String LOGTAG = "BDSPEECH";
    public static int logLevel = 7;

    public static void setLogLevel(int n) {
        logLevel = n;
    }

    public static void setLogLevel(String string) {
        if ("VERBOSE".equals(string)) {
            logLevel = 2;
        } else if ("DEBUG".equals(string)) {
            logLevel = 3;
        } else if ("INFO".equals(string)) {
            logLevel = 4;
        } else if ("WARN".equals(string)) {
            logLevel = 5;
        } else if ("ERROR".equals(string)) {
            logLevel = 6;
        } else if ("OFF".equals(string)) {
            logLevel = 7;
        }
        Log.i((String)TAG, (String)("Changing log level to " + logLevel + "(" + string + ")"));
    }

    public static boolean isLoggable(int n) {
        return logLevel >= n;
    }

    public static void Test(String string) {
        if (3 < logLevel) {
            return;
        }
        Log.d((String)TAG, (String)string);
    }

    public static void v(String string, String ... stringArray) {
        if (Log.isLoggable((String)LOGTAG, (int)2) || Log.isLoggable((String)string, (int)2) || 2 >= logLevel) {
            Log.v((String)(PREFIX + string), (String)LogUtil.argsToString(stringArray));
        }
    }

    private static String argsToString(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : stringArray) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void d(String string, String ... stringArray) {
        if (null == stringArray || stringArray.length == 0) {
            stringArray = new String[]{string};
            string = TAG;
        }
        if (Log.isLoggable((String)LOGTAG, (int)3) || Log.isLoggable((String)string, (int)3) || 3 >= logLevel) {
            Log.d((String)(PREFIX + string), (String)LogUtil.argsToString(stringArray));
        }
    }

    public static void i(String string, String ... stringArray) {
        if (null == stringArray || stringArray.length == 0) {
            stringArray = new String[]{string};
            string = TAG;
        }
        if (Log.isLoggable((String)LOGTAG, (int)4) || Log.isLoggable((String)string, (int)4) || 4 >= logLevel) {
            Log.i((String)(PREFIX + string), (String)LogUtil.argsToString(stringArray));
        }
    }

    public static void w(String string, String ... stringArray) {
        if (null == stringArray || stringArray.length == 0) {
            stringArray = new String[]{string};
            string = TAG;
        }
        if (Log.isLoggable((String)LOGTAG, (int)5) || Log.isLoggable((String)string, (int)5) || 5 >= logLevel) {
            Log.w((String)(PREFIX + string), (String)LogUtil.argsToString(stringArray));
        }
    }

    public static void e(String string, String ... stringArray) {
        if (null == stringArray || stringArray.length == 0) {
            stringArray = new String[]{string};
            string = TAG;
        }
        if (Log.isLoggable((String)LOGTAG, (int)6) || Log.isLoggable((String)string, (int)6) || 6 >= logLevel) {
            Log.e((String)(PREFIX + string), (String)LogUtil.argsToString(stringArray));
        }
    }

    public static void v(String string, Throwable throwable, String ... stringArray) {
        if (Log.isLoggable((String)LOGTAG, (int)2) || Log.isLoggable((String)string, (int)2) || 2 >= logLevel) {
            Log.v((String)(PREFIX + string), (String)LogUtil.argsToString(stringArray), (Throwable)throwable);
        }
    }

    public static void d(String string, Throwable throwable, String ... stringArray) {
        if (Log.isLoggable((String)LOGTAG, (int)3) || Log.isLoggable((String)string, (int)3) || 3 >= logLevel) {
            Log.d((String)(PREFIX + string), (String)LogUtil.argsToString(stringArray), (Throwable)throwable);
        }
    }

    public static void i(String string, Throwable throwable, String ... stringArray) {
        if (Log.isLoggable((String)LOGTAG, (int)4) || Log.isLoggable((String)string, (int)4) || 4 >= logLevel) {
            Log.i((String)(PREFIX + string), (String)LogUtil.argsToString(stringArray), (Throwable)throwable);
        }
    }

    public static void w(String string, Throwable throwable, String ... stringArray) {
        if (Log.isLoggable((String)LOGTAG, (int)5) || Log.isLoggable((String)string, (int)5) || 5 >= logLevel) {
            Log.w((String)(PREFIX + string), (String)LogUtil.argsToString(stringArray), (Throwable)throwable);
        }
    }

    public static void e(String string, Throwable throwable, String ... stringArray) {
        if (Log.isLoggable((String)LOGTAG, (int)6) || Log.isLoggable((String)string, (int)6) || 6 >= logLevel) {
            Log.e((String)(PREFIX + string), (String)LogUtil.argsToString(stringArray), (Throwable)throwable);
        }
    }

    public static void v(String string, String string2, Object ... objectArray) {
        if (Log.isLoggable((String)LOGTAG, (int)2) || Log.isLoggable((String)string, (int)2) || 2 >= logLevel) {
            Log.v((String)(PREFIX + string), (String)String.format(string2, objectArray));
        }
    }

    public static void d(String string, String string2, Object ... objectArray) {
        if (Log.isLoggable((String)LOGTAG, (int)3) || Log.isLoggable((String)string, (int)3) || 3 >= logLevel) {
            Log.d((String)(PREFIX + string), (String)String.format(string2, objectArray));
        }
    }

    public static void i(String string, String string2, Object ... objectArray) {
        if (Log.isLoggable((String)LOGTAG, (int)4) || Log.isLoggable((String)string, (int)4) || 4 >= logLevel) {
            Log.i((String)(PREFIX + string), (String)String.format(string2, objectArray));
        }
    }

    public static void w(String string, String string2, Object ... objectArray) {
        if (Log.isLoggable((String)LOGTAG, (int)5) || Log.isLoggable((String)string, (int)5) || 5 >= logLevel) {
            Log.w((String)(PREFIX + string), (String)String.format(string2, objectArray));
        }
    }

    public static void e(String string, String string2, Object ... objectArray) {
        if (Log.isLoggable((String)LOGTAG, (int)6) || Log.isLoggable((String)string, (int)6) || 6 >= logLevel) {
            Log.e((String)(PREFIX + string), (String)String.format(string2, objectArray));
        }
    }

    public static void e(Throwable throwable) {
        if (Log.isLoggable((String)LOGTAG, (int)6) || 6 >= logLevel) {
            LogUtil.printStrackTrace(throwable);
        }
    }

    private static boolean isFilteredLog(int n, String string) {
        return string.contains("") && n == 3;
    }

    private static void printStrackTrace(Throwable throwable) {
        if (throwable != null && throwable.getStackTrace() != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n").append(throwable.getLocalizedMessage());
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                stringBuffer.append("\n").append(stackTraceElement.toString());
            }
        }
    }

    static {
        LogUtil.setLogLevel(7);
    }
}

