/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.transport;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.ksoap2.HeaderProperty;
import org.ksoap2.SoapEnvelope;
import org.ksoap2.transport.ServiceConnection;
import org.ksoap2.transport.ServiceConnectionSE;
import org.ksoap2.transport.Transport;
import org.xmlpull.v1.XmlPullParserException;

public class HttpTransportSE
extends Transport {
    private ServiceConnection serviceConnection;

    public HttpTransportSE(String url) {
        super(null, url);
    }

    public HttpTransportSE(Proxy proxy, String url) {
        super(proxy, url);
    }

    public HttpTransportSE(String url, int timeout) {
        super(url, timeout);
    }

    public HttpTransportSE(Proxy proxy, String url, int timeout) {
        super(proxy, url, timeout);
    }

    public HttpTransportSE(String url, int timeout, int contentLength) {
        super(url, timeout);
    }

    public HttpTransportSE(Proxy proxy, String url, int timeout, int contentLength) {
        super(proxy, url, timeout);
    }

    public void call(String soapAction, SoapEnvelope envelope) throws IOException, XmlPullParserException {
        this.call(soapAction, envelope, null);
    }

    public List call(String soapAction, SoapEnvelope envelope, List headers) throws IOException, XmlPullParserException {
        InputStream is;
        int contentLength;
        byte[] buf;
        List retHeaders;
        OutputStream os;
        block14: {
            if (soapAction == null) {
                soapAction = "\"\"";
            }
            byte[] requestData = this.createRequestData(envelope, "UTF-8");
            this.requestDump = this.debug ? new String(requestData) : null;
            this.responseDump = null;
            ServiceConnection connection = this.getServiceConnection();
            connection.setRequestProperty("User-Agent", "ksoap2-android/2.6.0+");
            if (envelope.version != 120) {
                connection.setRequestProperty("SOAPAction", soapAction);
            }
            if (envelope.version == 120) {
                connection.setRequestProperty("Content-Type", "application/soap+xml;charset=utf-8");
            } else {
                connection.setRequestProperty("Content-Type", "text/xml;charset=utf-8");
            }
            connection.setRequestProperty("Connection", "close");
            connection.setRequestProperty("Accept-Encoding", "gzip");
            connection.setRequestProperty("Content-Length", "" + requestData.length);
            connection.setFixedLengthStreamingMode(requestData.length);
            if (headers != null) {
                for (int i = 0; i < headers.size(); ++i) {
                    HeaderProperty hp = (HeaderProperty)headers.get(i);
                    connection.setRequestProperty(hp.getKey(), hp.getValue());
                }
            }
            connection.setRequestMethod("POST");
            os = connection.openOutputStream();
            os.write(requestData, 0, requestData.length);
            os.flush();
            os.close();
            requestData = null;
            retHeaders = null;
            buf = null;
            contentLength = 8192;
            boolean gZippedContent = false;
            try {
                retHeaders = connection.getResponseProperties();
                for (int i = 0; i < retHeaders.size(); ++i) {
                    HeaderProperty hp = (HeaderProperty)retHeaders.get(i);
                    if (null == hp.getKey()) continue;
                    if (hp.getKey().equalsIgnoreCase("content-length") && hp.getValue() != null) {
                        try {
                            contentLength = Integer.parseInt(hp.getValue());
                        }
                        catch (NumberFormatException nfe) {
                            contentLength = 8192;
                        }
                    }
                    if (!hp.getKey().equalsIgnoreCase("Content-Encoding") || !hp.getValue().equalsIgnoreCase("gzip")) continue;
                    gZippedContent = true;
                    break;
                }
                is = gZippedContent ? this.getUnZippedInputStream(new BufferedInputStream(connection.openInputStream(), contentLength)) : new BufferedInputStream(connection.openInputStream(), contentLength);
            }
            catch (IOException e) {
                is = gZippedContent ? this.getUnZippedInputStream(new BufferedInputStream(connection.getErrorStream(), contentLength)) : new BufferedInputStream(connection.getErrorStream(), contentLength);
                if (is != null) break block14;
                connection.disconnect();
                throw e;
            }
        }
        if (this.debug) {
            int rd;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(contentLength > 0 ? contentLength : 262144);
            buf = new byte[256];
            while ((rd = is.read(buf, 0, 256)) != -1) {
                bos.write(buf, 0, rd);
            }
            bos.flush();
            buf = bos.toByteArray();
            bos = null;
            this.responseDump = new String(buf);
            is.close();
            is = new ByteArrayInputStream(buf);
        }
        this.parseResponse(envelope, is);
        os = null;
        buf = null;
        return retHeaders;
    }

    private InputStream getUnZippedInputStream(InputStream inputStream) throws IOException {
        try {
            return (GZIPInputStream)inputStream;
        }
        catch (ClassCastException e) {
            return new GZIPInputStream(inputStream);
        }
    }

    public ServiceConnection getServiceConnection() throws IOException {
        if (this.serviceConnection == null) {
            this.serviceConnection = new ServiceConnectionSE(this.proxy, this.url, this.timeout);
        }
        return this.serviceConnection;
    }

    public String getHost() {
        String retVal = null;
        try {
            retVal = new URL(this.url).getHost();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public int getPort() {
        int retVal = -1;
        try {
            retVal = new URL(this.url).getPort();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public String getPath() {
        String retVal = null;
        try {
            retVal = new URL(this.url).getPath();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return retVal;
    }
}

