package cn.ccy.test_weather;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

import org.ksoap2.serialization.SoapObject;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;
import cn.ccy.test_weather.adapter.ListAdapter;
import cn.ccy.test_weather.location.AutoLocation;
import cn.ccy.test_weather.utils.GetProvinceOrCity;
import cn.ccy.test_weather.utils.ParseDetail;
import cn.ccy.test_weather.utils.SaveProvinceOrCityMsg;
import cn.ccy.test_weather_model.WeatherDetail;
import cn.ccy.text_weather.services.GetWeatherService;

public class MainActivity extends Activity {

	public static TextView ShowWeatherCurrent;
	public static TextView ShowWeatherToday;
	public static TextView ShowupdateTime;
	private Spinner ProcinceSpinner;
	private Spinner CitySpinner;
	private Button manual;
	private Button location;
	private static String city;
	private static List<String> provinces = null;
	private ListAdapter CityAdapter;
	private ListAdapter ProvinceAdapter;
	public static Handler handler;
	public static Runnable runnable;
	public static Runnable runnable2;
	public static Runnable runnable3;
	public static SoapObject detail;
	private Intent i;
	private Intent intent;
	private static ProgressDialog progressBar;
	static AlertDialog.Builder builder;
	public static LinearLayout SelectView;
	static WeatherDetail detailContent;
	static ParseDetail pd;
	private boolean flag = true;
	private FileInputStream fis;
	private long lastClickTime = 0;

	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		System.out.println("--- onCreate---");

		// save = (Button) findViewById(R.id.save);
		manual = (Button) findViewById(R.id.Manual);
		location = (Button) findViewById(R.id.location);
		manual.setOnClickListener(new ManualClickListerner());

		location.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				progressBar = new ProgressDialog(MainActivity.this);
				handler.post(runnable3);
				FutureTask<SoapObject> task = new FutureTask<SoapObject>(
						new Callable<SoapObject>() {
							@Override
							public SoapObject call() throws Exception {
								intent = new Intent();
								intent.setClass(MainActivity.this,
										AutoLocation.class);
								startService(intent);

								return null;
							}
						});
				new Thread(task).start();

			}
		});

		runnable = new Runnable() {
			@Override
			public void run() {
				progressBar.setCancelable(false);
				progressBar.setMessage("ڼʡݺͳ...");
				progressBar.setIndeterminate(false);
				progressBar.setCanceledOnTouchOutside(false);
				progressBar.show();
			}
		};
		runnable2 = new Runnable() {
			@Override
			public void run() {
				progressBar.setCancelable(false);
				progressBar.setMessage("...");
				progressBar.setIndeterminate(false);
				progressBar.setCanceledOnTouchOutside(false);
				progressBar.show();
			}
		};
		runnable3 = new Runnable() {
			@Override
			public void run() {
				progressBar.setCancelable(false);
				progressBar.setMessage("λ...");
				progressBar.setIndeterminate(false);
				progressBar.setCanceledOnTouchOutside(false);
				progressBar.show();
			}
		};

		handler = new Handler() {
			public void handleMessage(Message msg) {
				if (msg.what == 0x1233) {
					handler.postDelayed(new Runnable() {
						@Override
						public void run() {
							progressBar.dismiss();
							finish();
							if (intent != null)
								stopService(intent);
						}
					}, 700);

					i = new Intent(MainActivity.this, ShowWeatherView.class);
					// i.setFlags(BIND_AUTO_CREATE);
					startActivity(i);
				}
				if (msg.what == 0x1234) {
					handler.postDelayed(new Runnable() {
						@Override
						public void run() {
							progressBar.dismiss();
						}
					}, 700);

					try {
						provinces = GetProvinceOrCity
								.getProvinceMsg(MainActivity.this);
					} catch (IOException e) {
						Log.v("Exception", "GetProvinceMsgʧ");
						e.printStackTrace();
					}
					ProvinceAdapter = new ListAdapter(MainActivity.this,
							provinces);
					ProcinceSpinner.setAdapter(ProvinceAdapter);

					ProcinceSpinner
							.setOnItemSelectedListener(new OnItemSelectedListener() {

								public void onItemSelected(AdapterView<?> arg0,
										View arg1, int arg2, long arg3) {
									List<String> cities = null;
									try {
										cities = GetProvinceOrCity
												.getCityMsg(ProcinceSpinner
														.getSelectedItem()
														.toString());
									} catch (IOException e) {
										Log.v("Exception", "GetCityMsgʧ");
										e.printStackTrace();
									}
									// ʾб
									CityAdapter = new ListAdapter(
											MainActivity.this, cities);
									CitySpinner.setAdapter(CityAdapter);
								}

								@Override
								public void onNothingSelected(
										AdapterView<?> arg0) {
								}

							});

					// ʾʵ
					CitySpinner
							.setOnItemSelectedListener(new OnItemSelectedListener() {

								public void onItemSelected(AdapterView<?> arg0,
										View arg1, int arg2, long arg3) {
									city = CitySpinner.getSelectedItem()
											.toString();

								}

								public void onNothingSelected(
										AdapterView<?> arg0) {
								}
							});

					builder = new AlertDialog.Builder(MainActivity.this)
					// öԻ
							.setTitle("ڵĵλã")
							// ͼ
							.setIcon(R.drawable.ic_launcher)
							// ü򵥵б
							.setView(SelectView);
					// ΪAlertDialog.Builderӡȷť
					setPositiveButton(builder, MainActivity.this);
					// ΪAlertDialog.Builderӡȡť
					setNegativeButton(builder, MainActivity.this).create()
							.show();

				}
			};
		};
	}

	class ManualClickListerner implements View.OnClickListener {

		@Override
		public void onClick(View v) {

			SelectView = (LinearLayout) getLayoutInflater().inflate(
					R.layout.select_spinner_view, null);
			ProcinceSpinner = (Spinner) SelectView
					.findViewById(R.id.ProvinceSpinner);
			CitySpinner = (Spinner) SelectView.findViewById(R.id.CitySpinner);

			progressBar = new ProgressDialog(MainActivity.this);

			try {
				fis = openFileInput("ProvinceOrCityMsg");

			} catch (FileNotFoundException e) {
				flag = false;
				
				e.printStackTrace();
			}

			if (!flag) {
				System.out.println("һֶλ");
				handler.post(runnable);

				Toast.makeText(MainActivity.this, "һμؿܱȽĵȴ",
						Toast.LENGTH_LONG).show();

				FutureTask<Properties> task = new FutureTask<Properties>(
						new Callable<Properties>() {
							public Properties call() throws Exception {
								return SaveProvinceOrCityMsg
										.saveProAndCityMsg(MainActivity.this);
							}
						});
				new Thread(task).start();

			} else
				handler.sendEmptyMessage(0x1234);
		}

	}

	public static AlertDialog.Builder setPositiveButton(
			AlertDialog.Builder builder, final Context context) {
		// setPositiveButtonȷť
		return builder.setPositiveButton("ȷ",
				new android.content.DialogInterface.OnClickListener() {

					@Override
					public void onClick(DialogInterface dialog, int which) {
						progressBar = new ProgressDialog(context);
						handler.post(runnable2);
						FutureTask<SoapObject> task = new FutureTask<SoapObject>(
								new Callable<SoapObject>() {
									@Override
									public SoapObject call() throws Exception {
										detail = GetWeatherService
												.getWeatherByCity(city, handler);

										pd = new ParseDetail(detail);
										detailContent = new WeatherDetail();
										detailContent.setContent(pd.getList());
										ShowWeatherView.wd = detailContent;
										return null;
									}
								});
						new Thread(task).start();

					}

				});
	}

	public static AlertDialog.Builder setNegativeButton(
			final AlertDialog.Builder builder, final Context context) {
		// setNegativeButtonȡť
		return builder.setNegativeButton("ȡ",
				new android.content.DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
					}
				});
	}

	public void onBackPressed() {

		if (lastClickTime <= 0) {
			Toast.makeText(this, "ٰһκ˼˳Ӧ", Toast.LENGTH_SHORT).show();
			lastClickTime = System.currentTimeMillis();
		} else {
			long currentClickTime = System.currentTimeMillis();
			if (currentClickTime - lastClickTime < 1500) {
				finish();
			} else {
				Toast.makeText(this, "ٰһκ˼˳Ӧ", Toast.LENGTH_SHORT).show();
				lastClickTime = currentClickTime;
			}
		}
	}

	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

}
