package cn.ccy.test_weather.location;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

import org.ksoap2.serialization.SoapObject;

import android.content.Context;
import android.widget.TextView;
import android.widget.Toast;
import cn.ccy.test_weather.MainActivity;
import cn.ccy.test_weather.ShowWeatherView;
import cn.ccy.test_weather.utils.ParseDetail;
import cn.ccy.test_weather_model.WeatherDetail;
import cn.ccy.text_weather.services.GetWeatherService;

import com.baidu.location.BDLocation;
import com.baidu.location.BDLocationListener;

public class MyLocationListenner implements BDLocationListener {
	public static TextView mTv;
	private String city;
	Context context;
	WeatherDetail detailContent;
	ParseDetail pd;

	public MyLocationListenner(Context context) {
		this.context = context;
	}

	@Override
	public void onReceiveLocation(BDLocation location) {
		if (location == null)
			return;
		StringBuffer sb = new StringBuffer(256);
		sb.append("time : ");
		sb.append(location.getTime());
		sb.append("\nerror code : ");
		sb.append(location.getLocType());
		sb.append("\nlatitude : ");
		sb.append(location.getLatitude());
		sb.append("\nlontitude : ");
		sb.append(location.getLongitude());
		sb.append("\nradius : ");
		sb.append(location.getRadius());
		if (location.getLocType() == BDLocation.TypeGpsLocation) {
			sb.append("\nspeed : ");
			sb.append(location.getSpeed());
			sb.append("\nsatellite : ");
			sb.append(location.getSatelliteNumber());
		} else if (location.getLocType() == BDLocation.TypeNetWorkLocation) {
			sb.append("\nʡ");
			sb.append(location.getProvince());
			// ֻõһȡԤ
			sb.append("\nУ");
			city = location.getCity();
			// ȡкȡԤ
			System.out.println(setCity(city));

			FutureTask<SoapObject> task = new FutureTask<SoapObject>(
					new Callable<SoapObject>() {
						@Override
						public SoapObject call() throws Exception {
							if (city == null) {
								Toast.makeText(context, "λʧܣѡֶģʽ",
										Toast.LENGTH_SHORT).show();

							}
							pd= new ParseDetail( GetWeatherService
									.getWeatherByCity(setCity(city),MainActivity.handler));
							detailContent = new  WeatherDetail();
							detailContent.setContent(pd.getList());
							ShowWeatherView.wd = detailContent;
							return null;
						}
					});
			new Thread(task).start();

			// Toast.makeText(context, "λʧܣѡֶģʽ",
			// Toast.LENGTH_SHORT).show();
			sb.append(city);
			sb.append("\n/أ");
			sb.append(location.getDistrict());
			sb.append("\naddr : ");
			sb.append(location.getAddrStr());
		}
		sb.append("\nsdk version : ");
		sb.append("\nisCellChangeFlag : ");
		sb.append(location.isCellChangeFlag());
		//System.out.println(sb.toString());
		// ȥ

	}

	public String setCity(String city) {
		// ȥ
		if (city != null)
			return city.substring(0, city.length() - 1);
		return null;
	}

	// ʾγ
	public void onReceivePoi(BDLocation poiLocation) {
		// if (poiLocation == null) {
		// return;
		// }
		// StringBuffer sb = new StringBuffer(256);
		// sb.append("Poi time : ");
		// sb.append(poiLocation.getTime());
		// sb.append("\nerror code : ");
		// sb.append(poiLocation.getLocType());
		// sb.append("\nlatitude : ");
		// sb.append(poiLocation.getLatitude());
		// sb.append("\nlontitude : ");
		// sb.append(poiLocation.getLongitude());
		// sb.append("\nradius : ");
		// sb.append(poiLocation.getRadius());
		// if (poiLocation.getLocType() == BDLocation.TypeNetWorkLocation) {
		// sb.append("\naddr : ");
		// sb.append(poiLocation.getAddrStr());
		// }
		// if (poiLocation.hasPoi()) {
		// sb.append("\nPoi:");
		// sb.append(poiLocation.getPoi());
		// } else {
		// sb.append("noPoi information");
		// }
		// System.out.println(sb.toString());
		//
		// }

	}
}
