package cn.ccy.test_weather.ui;

import cn.ccy.test_weather.R;
import cn.ccy.test_weather.ShowWeatherView;
import cn.ccy.test_weather.utils.ParseIcon;
import cn.ccy.test_weather_model.WeatherDetail;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

public class ForthDayFragment extends Fragment {
	public static TextView ShowWeatherT;
	public static TextView ShowWeatherWindPower;
	public static TextView ShowWeatherFouthDay;
	public static TextView ShowupdateTime;
	public static ImageView Icon1;
	public static ImageView Icon2;

	private static String updateTime = "";
	WeatherDetail info;
	private static String weatherFourthDay = "";
	private static String FourthDayT = "";
	private static String FourthDayWindPower = "";

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		info = ShowWeatherView.wd;
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {

		View parentView = inflater.inflate(R.layout.forth_day_fragment,
				container, false);
		LinearLayout weatherView = (LinearLayout) parentView
				.findViewById(R.id.weatherView4);
		ShowupdateTime = (TextView) parentView.findViewById(R.id.updateTime);
		ShowWeatherFouthDay = (TextView) parentView
				.findViewById(R.id.weatherFourthDay);
		ShowWeatherT = (TextView) parentView.findViewById(R.id.FourthDayT);
		ShowWeatherWindPower = (TextView) parentView
				.findViewById(R.id.FourthDayWindPower);
		Icon1 = (ImageView) parentView.findViewById(R.id.Icon1);
		Icon2 = (ImageView) parentView.findViewById(R.id.Icon2);

		Resources resources = this.getResources();
		if (info != null) {
			if (info.getWeatherFourthDay().indexOf("") != -1) {
				Drawable drawable = resources.getDrawable(R.drawable.rain);
				weatherView.setBackground(drawable);
				ShowupdateTime.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherT.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherWindPower.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherFouthDay.setTextColor(this.getResources().getColor(
						R.color.white));

			} else if (info.getWeatherFourthDay().indexOf("") != -1) {
				Drawable drawable = resources.getDrawable(R.drawable.cloud);
				weatherView.setBackground(drawable);
				ShowupdateTime.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherT.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherWindPower.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherFouthDay.setTextColor(this.getResources().getColor(
						R.color.white));
			} else if (info.getWeatherFourthDay().indexOf("") != -1) {
				Drawable drawable = resources.getDrawable(R.drawable.sunny);
				weatherView.setBackground(drawable);
				ShowupdateTime.setTextColor(this.getResources().getColor(
						R.color.sunny));
				ShowWeatherT.setTextColor(this.getResources().getColor(
						R.color.sunny));
				ShowWeatherWindPower.setTextColor(this.getResources().getColor(
						R.color.sunny));
				ShowWeatherFouthDay.setTextColor(this.getResources().getColor(
						R.color.sunny));

			} else if (info.getWeatherFourthDay().indexOf("") != -1) {
				Drawable drawable = resources.getDrawable(R.drawable.overcast);
				weatherView.setBackground(drawable);
				ShowupdateTime.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherT.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherWindPower.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherFouthDay.setTextColor(this.getResources().getColor(
						R.color.white));
			}
			
			updateTime = "ʱ䣺 " + info.getUpdateTime();
			FourthDayT = "¶ȣ" + info.getFourthDayT();
			weatherFourthDay = info.getWeatherFourthDay();
			FourthDayWindPower = "" + info.getFourthDayWindPower();
			
			Icon1.setImageResource(ParseIcon.parseIcon(info.getFourthDayIcon1()));
			Icon2.setImageResource(ParseIcon.parseIcon(info.getFourthDayIcon2()));
			ShowupdateTime.setText(updateTime);
			ShowWeatherFouthDay.setText(weatherFourthDay);
			ShowWeatherT.setText(FourthDayT);
			ShowWeatherWindPower.setText(FourthDayWindPower);
		}
		return parentView;
	}
}
