package cn.ccy.test_weather.ui;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.ccy.test_weather.R;
import cn.ccy.test_weather.ShowWeatherView;
import cn.ccy.test_weather.utils.ParseIcon;
import cn.ccy.test_weather_model.WeatherDetail;

public class ThirdDayFragment extends Fragment {
	
	public static TextView ShowWeatherT;
	public static TextView ShowWeatherWindPower;
	public static TextView ShowWeatherThirdDay;
	public static TextView ShowupdateTime;
	public static ImageView Icon1;
	public static ImageView Icon2;

	private static String updateTime = "";
	WeatherDetail info;
	private static String weatherThirdDay = "";
	private static String ThirdDayT = "";
	private static String ThirdDayWindPower = "";

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		info = ShowWeatherView.wd;
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {

		View parentView = inflater.inflate(R.layout.third_day_fragment,
				container, false);
		LinearLayout weatherView = (LinearLayout) parentView
				.findViewById(R.id.weatherView3);
		ShowupdateTime = (TextView) parentView.findViewById(R.id.updateTime);
		ShowWeatherThirdDay = (TextView) parentView
				.findViewById(R.id.weatherThirdDay);
		ShowWeatherT = (TextView) parentView.findViewById(R.id.ThirdDayT);
		ShowWeatherWindPower = (TextView) parentView
				.findViewById(R.id.ThirdDayWindPower);
		Icon1 = (ImageView) parentView.findViewById(R.id.Icon1);
		Icon2 = (ImageView) parentView.findViewById(R.id.Icon2);

		Resources resources = this.getResources();
		if (info != null) {
			if (info.getWeatherThirdDay().indexOf("") != -1) {
				Drawable drawable = resources.getDrawable(R.drawable.rain);
				weatherView.setBackground(drawable);
				ShowupdateTime.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherT.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherWindPower.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherThirdDay.setTextColor(this.getResources().getColor(
						R.color.white));

			} else if (info.getWeatherThirdDay().indexOf("") != -1) {
				Drawable drawable = resources.getDrawable(R.drawable.cloud);
				weatherView.setBackground(drawable);
				ShowupdateTime.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherT.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherWindPower.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherThirdDay.setTextColor(this.getResources().getColor(
						R.color.white));
			} else if (info.getWeatherThirdDay().indexOf("") != -1) {
				Drawable drawable = resources.getDrawable(R.drawable.sunny);
				weatherView.setBackground(drawable);
				ShowupdateTime.setTextColor(this.getResources().getColor(
						R.color.sunny));
				ShowWeatherT.setTextColor(this.getResources().getColor(
						R.color.sunny));
				ShowWeatherWindPower.setTextColor(this.getResources().getColor(
						R.color.sunny));
				ShowWeatherThirdDay.setTextColor(this.getResources().getColor(
						R.color.sunny));

			} else if (info.getWeatherThirdDay().indexOf("") != -1) {
				Drawable drawable = resources.getDrawable(R.drawable.overcast);
				weatherView.setBackground(drawable);
				ShowupdateTime.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherT.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherWindPower.setTextColor(this.getResources().getColor(
						R.color.white));
				ShowWeatherThirdDay.setTextColor(this.getResources().getColor(
						R.color.white));
			}
			
			updateTime = "ʱ䣺 " + info.getUpdateTime();
			ThirdDayT = "¶ȣ" + info.getThirdDayT();
			weatherThirdDay = info.getWeatherThirdDay();
			ThirdDayWindPower = "" + info.getThirdDayWindPower();
			
			Icon1.setImageResource(ParseIcon.parseIcon(info.getThirdDayIcon1()));
			Icon2.setImageResource(ParseIcon.parseIcon(info.getThirdDayIcon2()));
			ShowupdateTime.setText(updateTime);
			ShowWeatherThirdDay.setText(weatherThirdDay);
			ShowWeatherT.setText(ThirdDayT);
			ShowWeatherWindPower.setText(ThirdDayWindPower);
		}
		return parentView;
	}
}
