package cn.ccy.test_weather.ui;

import java.util.List;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.support.v4.view.ViewPager;
import android.support.v4.view.ViewPager.OnPageChangeListener;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import android.widget.LinearLayout.LayoutParams;
import cn.ccy.test_weather.MainActivity;
import cn.ccy.test_weather.R;
import cn.ccy.test_weather.adapter.MyPageAdapter;
import cn.ccy.test_weather.utils.PageUtil;

public class WelcomeFirst extends Activity implements OnPageChangeListener {
	private ViewPager vp_guide;
	private List<View> pageList;
	/** ײָʾԲ */
	private LinearLayout layout_dotView;
	private LinearLayout layout_buttonView;
	private ImageView[] imgDots;
	/** ͳҳ */
	private int dotCount;
	private Intent intent;
	private int count;
	private Button goin;
	Bundle b;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_guide_page);
		intent = getIntent();
		b = intent.getExtras();
		count = b.getInt("Count");
		System.out.println("#########"+count);
		initView();
		initDots();
		setPage();
	}

	private void initView() {
		layout_dotView = (LinearLayout) findViewById(R.id.layout_dotView);
		goin = (Button) findViewById(R.id.goin);
		goin.setOnClickListener(new GoinOnClickListener());
		layout_buttonView = (LinearLayout) findViewById(R.id.layout_buttonView);
		layout_buttonView.setVisibility(View.INVISIBLE);
		vp_guide = (ViewPager) findViewById(R.id.vp_guide);
		vp_guide.setOnPageChangeListener(this);
		pageList = PageUtil.getPageList(this);
		dotCount = pageList.size();
	}

	/** õײԲ */
	private void initDots() {
		imgDots = new ImageView[dotCount];
		for (int i = 0; i < dotCount; i++) {
			ImageView dotView = new ImageView(this);
			if (i == 0) {
				dotView.setBackgroundResource(R.drawable.dot_white);
			} else {
				dotView.setBackgroundResource(R.drawable.dot_gray);
			}
			imgDots[i] = dotView;

			// Բ㲼ֲ
			LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(
					LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
			params.setMargins(7, 0, 7, 0);
			dotView.setLayoutParams(params);
			layout_dotView.addView(dotView);
		}
	}

	private void setPage() {
		vp_guide.setAdapter(new MyPageAdapter(pageList));
		if (PageUtil.isCycle) {
			/*
			 * ˴õǰҳʾλ,100(ʲô,΢) ʵѭ,ȻƵ,һûɶ
			 */
			vp_guide.setCurrentItem(100);
		}
	}

	@Override
	public void onPageSelected(int arg0) {
		if (PageUtil.isCycle) {
			arg0 = arg0 % dotCount;
		}
		for (int i = 0; i < dotCount; i++) {
			if (i == arg0) {
				imgDots[i].setBackgroundResource(R.drawable.dot_white);
			} else {
				imgDots[i].setBackgroundResource(R.drawable.dot_gray);
			}
		}
		if (arg0 == 3)
			layout_buttonView.setVisibility(View.VISIBLE);
		else
			layout_buttonView.setVisibility(View.INVISIBLE);
	}

	@Override
	public void onPageScrollStateChanged(int arg0) {

	}

	@Override
	public void onPageScrolled(int arg0, float arg1, int arg2) {

	}
	
	class GoinOnClickListener implements View.OnClickListener {

		@Override
		public void onClick(View v) {
			System.out.println(" on clivk  Count == " + count);
			if (count == 0 && note_Intent(WelcomeFirst.this)) {
				Intent i = new Intent(WelcomeFirst.this, MainActivity.class);
				startActivity(i);
				finish();
			}

		}
	}
	public boolean note_Intent(Context context) {  
	    ConnectivityManager con = (ConnectivityManager) context  
	        .getSystemService(Context.CONNECTIVITY_SERVICE);  
	    NetworkInfo networkinfo = con.getActiveNetworkInfo();  
	    if (networkinfo == null || !networkinfo.isAvailable()) {  
	    // ǰ粻   
	        Toast.makeText(context.getApplicationContext(), "粻ãInternet",  
	        Toast.LENGTH_SHORT).show();  
	        return false;  
	    }  

	    return true;
	}
}
