package cn.ccy.test_weather.utils;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

import org.ksoap2.SoapEnvelope;
import org.ksoap2.serialization.SoapObject;
import org.ksoap2.serialization.SoapSerializationEnvelope;
import org.ksoap2.transport.HttpTransportSE;
import org.xmlpull.v1.XmlPullParserException;

import cn.ccy.test_weather.MainActivity;

public class GetWeatherService {
	// Web Serviceռ
	static final String SERVICE_NS = "http://WebXml.com.cn/";
	// Web ServiceṩURL
	static final String SERVICE_URL = "http://webservice.webxml.com.cn/WebServices/WeatherWS.asmx";
	public static SoapObject getWeatherByCity(String cityName) throws IOException, XmlPullParserException
	{

		final String methodName = "getWeather";
		final HttpTransportSE ht = new HttpTransportSE(SERVICE_URL);
		ht.debug = true;
		final SoapSerializationEnvelope envelope = 
			new SoapSerializationEnvelope(SoapEnvelope.VER11);
		SoapObject soapObject = new SoapObject(SERVICE_NS, methodName);
		soapObject.addProperty("theCityCode", cityName);
		envelope.bodyOut = soapObject;
		// .NetṩWeb ServiceֽϺõļ
		envelope.dotNet = true;
		
		ht.call(SERVICE_NS + methodName, envelope);
		SoapObject result = (SoapObject) envelope.bodyIn;
		SoapObject detail = (SoapObject) result.getProperty(
				methodName + "Result");
		MainActivity.handler.sendEmptyMessage(0x1233);
		return detail;
	}
}
