package cn.ccy.text_weather.services;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

import org.ksoap2.SoapEnvelope;
import org.ksoap2.serialization.SoapObject;
import org.ksoap2.serialization.SoapSerializationEnvelope;
import org.ksoap2.transport.HttpTransportSE;

import cn.ccy.test_weather.utils.ParseProvinceOrCity;

// ʡݻȡб
public class GetCityService {
	// Web Serviceռ
	static final String SERVICE_NS = "http://WebXml.com.cn/";
	// Web ServiceṩURL
	static final String SERVICE_URL = "http://webservice.webxml.com.cn/WebServices/WeatherWS.asmx";

	public static List<String> getCityListByProvince(String province) {
		// õķ
		final String methodName = "getSupportCityString";
		// HttpTransportSE
		final HttpTransportSE ht = new HttpTransportSE(SERVICE_URL);
		ht.debug = true;
		// ʹSOAP1.1Э鴴Envelop
		final SoapSerializationEnvelope envelope = new SoapSerializationEnvelope(
				SoapEnvelope.VER11);
		// ʵSoapObject
		SoapObject soapObject = new SoapObject(SERVICE_NS, methodName);
		// һ
		soapObject.addProperty("theRegionCode", province);
		envelope.bodyOut = soapObject;
		// .NetṩWeb ServiceֽϺõļ
		envelope.dotNet = true;
		FutureTask<List<String>> task = new FutureTask<List<String>>(
				new Callable<List<String>>() {
					@Override
					public List<String> call() throws Exception {
						// Web Service
						ht.call(SERVICE_NS + methodName, envelope);
						if (envelope.getResponse() != null) {
							// ȡӦصSOAPϢ
							SoapObject result = (SoapObject) envelope.bodyIn;
							SoapObject detail = (SoapObject) result.getProperty(methodName + "Result");
							// ӦSOAPϢ
							return ParseProvinceOrCity
									.parseProvinceOrCity(detail);
						}
						return null;
					}
				});
		new Thread(task).start();
		try {
			return task.get();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

}
