/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rebound;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.view.Choreographer;
import com.facebook.rebound.SpringLooper;

public abstract class AndroidSpringLooperFactory {
    public static SpringLooper createSpringLooper() {
        if (Build.VERSION.SDK_INT >= 16) {
            return ChoreographerAndroidSpringLooper.create();
        }
        return LegacyAndroidSpringLooper.create();
    }

    @TargetApi(value=16)
    private static class ChoreographerAndroidSpringLooper
    extends SpringLooper {
        private final Choreographer mChoreographer;
        private final Choreographer.FrameCallback mFrameCallback;
        private boolean mStarted;

        public static ChoreographerAndroidSpringLooper create() {
            return new ChoreographerAndroidSpringLooper(Choreographer.getInstance());
        }

        public ChoreographerAndroidSpringLooper(Choreographer choreographer) {
            this.mChoreographer = choreographer;
            this.mFrameCallback = new Choreographer.FrameCallback(){

                public void doFrame(long frameTimeNanos) {
                    if (!ChoreographerAndroidSpringLooper.this.mStarted || ChoreographerAndroidSpringLooper.this.mSpringSystem == null) {
                        return;
                    }
                    ChoreographerAndroidSpringLooper.this.mSpringSystem.loop();
                    ChoreographerAndroidSpringLooper.this.mChoreographer.postFrameCallback(ChoreographerAndroidSpringLooper.this.mFrameCallback);
                }
            };
        }

        @Override
        public void start() {
            this.mStarted = true;
            this.mChoreographer.removeFrameCallback(this.mFrameCallback);
            this.mChoreographer.postFrameCallback(this.mFrameCallback);
        }

        @Override
        public void stop() {
            this.mStarted = false;
            this.mChoreographer.removeFrameCallback(this.mFrameCallback);
        }
    }

    private static class LegacyAndroidSpringLooper
    extends SpringLooper {
        private final Handler mHandler;
        private final Runnable mLooperRunnable;
        private boolean mStarted;

        public static SpringLooper create() {
            return new LegacyAndroidSpringLooper(new Handler());
        }

        public LegacyAndroidSpringLooper(Handler handler) {
            this.mHandler = handler;
            this.mLooperRunnable = new Runnable(){

                @Override
                public void run() {
                    if (!LegacyAndroidSpringLooper.this.mStarted || LegacyAndroidSpringLooper.this.mSpringSystem == null) {
                        return;
                    }
                    LegacyAndroidSpringLooper.this.mSpringSystem.loop();
                    LegacyAndroidSpringLooper.this.mHandler.post(LegacyAndroidSpringLooper.this.mLooperRunnable);
                }
            };
        }

        @Override
        public void start() {
            this.mStarted = true;
            this.mHandler.removeCallbacks(this.mLooperRunnable);
            this.mHandler.post(this.mLooperRunnable);
        }

        @Override
        public void stop() {
            this.mStarted = false;
            this.mHandler.removeCallbacks(this.mLooperRunnable);
        }
    }
}

