/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rebound;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ReentrantCallback<CallbackClass>
implements Iterable<CallbackClass> {
    private final Set<CallbackClass> mListeners = new HashSet<CallbackClass>();
    private Set<CallbackClass> mReturnSet = null;

    public synchronized Set<CallbackClass> getListeners() {
        if (this.mReturnSet == null) {
            this.mReturnSet = Collections.unmodifiableSet(this.mListeners);
        }
        return this.mReturnSet;
    }

    @Override
    public synchronized Iterator<CallbackClass> iterator() {
        if (this.mReturnSet == null) {
            this.mReturnSet = Collections.unmodifiableSet(this.mListeners);
        }
        return this.mReturnSet.iterator();
    }

    public synchronized void addListener(CallbackClass listener) {
        this.mListeners.add(listener);
        this.mReturnSet = null;
    }

    public synchronized void removeListener(CallbackClass listener) {
        this.mListeners.remove(listener);
        this.mReturnSet = null;
    }

    public synchronized int count() {
        return this.mListeners.size();
    }

    public synchronized void clear() {
        this.mListeners.clear();
        this.mReturnSet = null;
    }
}

