/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidannotations.annotations.EActivity;
import org.androidannotations.exception.ProcessingException;
import org.androidannotations.exception.VersionMismatchException;
import org.androidannotations.generation.CodeModelGenerator;
import org.androidannotations.handler.AnnotationHandlers;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.AndroidManifestFinder;
import org.androidannotations.helper.ErrorHelper;
import org.androidannotations.helper.Option;
import org.androidannotations.helper.OptionsHelper;
import org.androidannotations.logger.Level;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerContext;
import org.androidannotations.logger.LoggerFactory;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.model.AnnotationElementsHolder;
import org.androidannotations.model.ModelExtractor;
import org.androidannotations.process.ModelProcessor;
import org.androidannotations.process.ModelValidator;
import org.androidannotations.process.TimeStats;
import org.androidannotations.rclass.AndroidRClassFinder;
import org.androidannotations.rclass.CoumpoundRClass;
import org.androidannotations.rclass.IRClass;
import org.androidannotations.rclass.ProjectRClassFinder;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class AndroidAnnotationProcessor
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AndroidAnnotationProcessor.class);
    private final Properties properties = new Properties();
    private final Properties propertiesApi = new Properties();
    private final TimeStats timeStats = new TimeStats();
    private final ErrorHelper errorHelper = new ErrorHelper();
    private AnnotationHandlers annotationHandlers;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        LoggerContext loggerContext = LoggerContext.getInstance();
        loggerContext.setProcessingEnv(processingEnv);
        try {
            this.loadPropertyFile();
            this.loadApiPropertyFile();
        }
        catch (Exception e) {
            LOGGER.error("Can't load API or core properties files", e, new Object[0]);
        }
        LOGGER.info("Initialize AndroidAnnotations {} with options {}", this.getAAProcessorVersion(), processingEnv.getOptions());
        this.annotationHandlers = new AnnotationHandlers(processingEnv);
    }

    private void checkApiAndCoreVersions() throws VersionMismatchException {
        String coreVersion;
        String apiVersion = this.getAAApiVersion();
        if (!apiVersion.equals(coreVersion = this.getAAProcessorVersion())) {
            LOGGER.error("AndroidAnnotation version for API ({}) and core ({}) doesn't match. Please check your classpath", apiVersion, coreVersion);
            throw new VersionMismatchException("AndroidAnnotation version for API (" + apiVersion + ") and core (" + coreVersion + ") doesn't match. Please check your classpath");
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.timeStats.clear();
        this.timeStats.start("Whole Processing");
        Set<? extends Element> rootElements = roundEnv.getRootElements();
        if (LOGGER.isLoggable(Level.TRACE)) {
            LOGGER.trace("Start processing for {} annotations {} on {} elements {}", annotations.size(), annotations, rootElements.size(), rootElements);
        } else {
            LOGGER.info("Start processing for {} annotations on {} elements", annotations.size(), rootElements.size());
        }
        try {
            this.checkApiAndCoreVersions();
            this.processThrowing(annotations, roundEnv);
        }
        catch (ProcessingException e) {
            this.handleException(annotations, roundEnv, e);
        }
        catch (Exception e) {
            this.handleException(annotations, roundEnv, new ProcessingException(e, null));
        }
        this.timeStats.stop("Whole Processing");
        this.timeStats.logStats();
        LOGGER.info("Finish processing", new Object[0]);
        LoggerContext.getInstance().close();
        return true;
    }

    private void loadPropertyFile() throws FileNotFoundException {
        String filename = "androidannotations.properties";
        try {
            URL url = this.getClass().getClassLoader().getResource(filename);
            this.properties.load(url.openStream());
        }
        catch (Exception e) {
            LOGGER.error("Core property file {} couldn't be parse", new Object[0]);
            throw new FileNotFoundException("Core property file " + filename + " couldn't be parsed.");
        }
    }

    private void loadApiPropertyFile() throws FileNotFoundException {
        String filename = "androidannotations-api.properties";
        try {
            URL url = EActivity.class.getClassLoader().getResource(filename);
            this.propertiesApi.load(url.openStream());
        }
        catch (Exception e) {
            LOGGER.error("API property file {} couldn't be parse", new Object[0]);
            throw new FileNotFoundException("API property file " + filename + " couldn't be parsed. Please check your classpath and verify that AA-API's version is at least 3.0");
        }
    }

    private String getAAProcessorVersion() {
        return this.properties.getProperty("version", "3.0+");
    }

    private String getAAApiVersion() {
        return this.propertiesApi.getProperty("version", "unknown");
    }

    private void processThrowing(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws ProcessingException, Exception {
        if (this.nothingToDo(annotations, roundEnv)) {
            return;
        }
        AnnotationElementsHolder extractedModel = this.extractAnnotations(annotations, roundEnv);
        Option<AndroidManifest> androidManifestOption = this.extractAndroidManifest();
        if (androidManifestOption.isAbsent()) {
            return;
        }
        AndroidManifest androidManifest = androidManifestOption.get();
        LOGGER.info("AndroidManifest.xml found: {}", androidManifest);
        Option<IRClass> rClassOption = this.findRClasses(androidManifest);
        if (rClassOption.isAbsent()) {
            return;
        }
        IRClass rClass = rClassOption.get();
        AndroidSystemServices androidSystemServices = new AndroidSystemServices();
        this.annotationHandlers.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        AnnotationElements validatedModel = this.validateAnnotations(extractedModel);
        ModelProcessor.ProcessResult processResult = this.processAnnotations(validatedModel);
        this.generateSources(processResult);
    }

    private boolean nothingToDo(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return roundEnv.processingOver() || annotations.size() == 0;
    }

    private AnnotationElementsHolder extractAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.timeStats.start("Extract Annotations");
        ModelExtractor modelExtractor = new ModelExtractor();
        AnnotationElementsHolder extractedModel = modelExtractor.extract(annotations, this.getSupportedAnnotationTypes(), roundEnv);
        this.timeStats.stop("Extract Annotations");
        return extractedModel;
    }

    private Option<AndroidManifest> extractAndroidManifest() {
        this.timeStats.start("Extract Manifest");
        AndroidManifestFinder finder = new AndroidManifestFinder(this.processingEnv);
        Option<AndroidManifest> manifest = finder.extractAndroidManifest();
        this.timeStats.stop("Extract Manifest");
        return manifest;
    }

    private Option<IRClass> findRClasses(AndroidManifest androidManifest) throws IOException {
        this.timeStats.start("Find R Classes");
        ProjectRClassFinder rClassFinder = new ProjectRClassFinder(this.processingEnv);
        Option<IRClass> rClass = rClassFinder.find(androidManifest);
        AndroidRClassFinder androidRClassFinder = new AndroidRClassFinder(this.processingEnv);
        Option<IRClass> androidRClass = androidRClassFinder.find();
        if (rClass.isAbsent() || androidRClass.isAbsent()) {
            return Option.absent();
        }
        CoumpoundRClass coumpoundRClass = new CoumpoundRClass(rClass.get(), androidRClass.get());
        this.timeStats.stop("Find R Classes");
        return Option.of(coumpoundRClass);
    }

    private AnnotationElements validateAnnotations(AnnotationElementsHolder extractedModel) throws ProcessingException, Exception {
        this.timeStats.start("Validate Annotations");
        ModelValidator modelValidator = new ModelValidator(this.annotationHandlers);
        AnnotationElements validatedAnnotations = modelValidator.validate(extractedModel);
        this.timeStats.stop("Validate Annotations");
        return validatedAnnotations;
    }

    private ModelProcessor.ProcessResult processAnnotations(AnnotationElements validatedModel) throws Exception {
        this.timeStats.start("Process Annotations");
        this.annotationHandlers.setValidatedModel(validatedModel);
        ModelProcessor modelProcessor = new ModelProcessor(this.processingEnv, this.annotationHandlers);
        ModelProcessor.ProcessResult processResult = modelProcessor.process(validatedModel);
        this.timeStats.stop("Process Annotations");
        return processResult;
    }

    private void generateSources(ModelProcessor.ProcessResult processResult) throws IOException {
        this.timeStats.start("Generate Sources");
        LOGGER.info("Number of files generated by AndroidAnnotations: {}", processResult.codeModel.countArtifacts());
        CodeModelGenerator modelGenerator = new CodeModelGenerator(this.processingEnv.getFiler(), this.getAAProcessorVersion());
        modelGenerator.generate(processResult);
        this.timeStats.stop("Generate Sources");
    }

    private void handleException(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, ProcessingException e) {
        String errorMessage = this.errorHelper.getErrorMessage(this.processingEnv, e, this.getAAProcessorVersion());
        Iterator<? extends TypeElement> iterator = annotations.iterator();
        if (iterator.hasNext()) {
            Element element = roundEnv.getElementsAnnotatedWith(iterator.next()).iterator().next();
            LOGGER.error("Something went wront : {}", element, errorMessage);
        } else {
            LOGGER.error("Something went wront : {}", errorMessage);
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.annotationHandlers.getSupportedAnnotationTypes();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return OptionsHelper.getOptionsConstants();
    }
}

