/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import org.androidannotations.handler.AfterInjectHandler;
import org.androidannotations.handler.AfterTextChangeHandler;
import org.androidannotations.handler.AfterViewsHandler;
import org.androidannotations.handler.AnnotationHandler;
import org.androidannotations.handler.AppHandler;
import org.androidannotations.handler.BackgroundHandler;
import org.androidannotations.handler.BeanHandler;
import org.androidannotations.handler.BeforeTextChangeHandler;
import org.androidannotations.handler.CheckedChangeHandler;
import org.androidannotations.handler.ClickHandler;
import org.androidannotations.handler.CustomTitleHandler;
import org.androidannotations.handler.EActivityHandler;
import org.androidannotations.handler.EApplicationHandler;
import org.androidannotations.handler.EBeanHandler;
import org.androidannotations.handler.EFragmentHandler;
import org.androidannotations.handler.EIntentServiceHandler;
import org.androidannotations.handler.EProviderHandler;
import org.androidannotations.handler.EReceiverHandler;
import org.androidannotations.handler.EServiceHandler;
import org.androidannotations.handler.EViewGroupHandler;
import org.androidannotations.handler.EViewHandler;
import org.androidannotations.handler.ExtraHandler;
import org.androidannotations.handler.FocusChangeHandler;
import org.androidannotations.handler.FragmentArgHandler;
import org.androidannotations.handler.FragmentByIdHandler;
import org.androidannotations.handler.FragmentByTagHandler;
import org.androidannotations.handler.FromHtmlHandler;
import org.androidannotations.handler.FullscreenHandler;
import org.androidannotations.handler.GeneratingAnnotationHandler;
import org.androidannotations.handler.HierarchyViewerSupportHandler;
import org.androidannotations.handler.HttpsClientHandler;
import org.androidannotations.handler.InstanceStateHandler;
import org.androidannotations.handler.ItemClickHandler;
import org.androidannotations.handler.ItemLongClickHandler;
import org.androidannotations.handler.ItemSelectHandler;
import org.androidannotations.handler.LongClickHandler;
import org.androidannotations.handler.NoTitleHandler;
import org.androidannotations.handler.NonConfigurationInstanceHandler;
import org.androidannotations.handler.OnActivityResultHandler;
import org.androidannotations.handler.OptionsItemHandler;
import org.androidannotations.handler.OptionsMenuHandler;
import org.androidannotations.handler.OptionsMenuItemHandler;
import org.androidannotations.handler.OrmLiteDaoHandler;
import org.androidannotations.handler.PrefHandler;
import org.androidannotations.handler.ProduceHandler;
import org.androidannotations.handler.ResHandler;
import org.androidannotations.handler.RoboGuiceHandler;
import org.androidannotations.handler.RootContextHanlder;
import org.androidannotations.handler.SeekBarProgressChangeHandler;
import org.androidannotations.handler.SeekBarTouchStartHandler;
import org.androidannotations.handler.SeekBarTouchStopHandler;
import org.androidannotations.handler.ServiceActionHandler;
import org.androidannotations.handler.SharedPrefHandler;
import org.androidannotations.handler.SubscribeHandler;
import org.androidannotations.handler.SystemServiceHandler;
import org.androidannotations.handler.TextChangeHandler;
import org.androidannotations.handler.TouchHandler;
import org.androidannotations.handler.TraceHandler;
import org.androidannotations.handler.TransactionalHandler;
import org.androidannotations.handler.UiThreadHandler;
import org.androidannotations.handler.ViewByIdHandler;
import org.androidannotations.handler.WindowFeatureHandler;
import org.androidannotations.handler.rest.DeleteHandler;
import org.androidannotations.handler.rest.GetHandler;
import org.androidannotations.handler.rest.HeadHandler;
import org.androidannotations.handler.rest.OptionsHandler;
import org.androidannotations.handler.rest.PostHandler;
import org.androidannotations.handler.rest.PutHandler;
import org.androidannotations.handler.rest.RestHandler;
import org.androidannotations.handler.rest.RestServiceHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.OptionsHelper;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.model.AndroidRes;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.ProcessHolder;
import org.androidannotations.rclass.IRClass;

public class AnnotationHandlers {
    private List<AnnotationHandler<? extends GeneratedClassHolder>> annotationHandlers = new ArrayList<AnnotationHandler<? extends GeneratedClassHolder>>();
    private List<GeneratingAnnotationHandler<? extends GeneratedClassHolder>> generatingAnnotationHandlers = new ArrayList<GeneratingAnnotationHandler<? extends GeneratedClassHolder>>();
    private List<AnnotationHandler<? extends GeneratedClassHolder>> decoratingAnnotationHandlers = new ArrayList<AnnotationHandler<? extends GeneratedClassHolder>>();
    private Set<String> supportedAnnotationNames;
    private OptionsHelper optionsHelper;

    public AnnotationHandlers(ProcessingEnvironment processingEnvironment) {
        this.optionsHelper = new OptionsHelper(processingEnvironment);
        this.add(new EApplicationHandler(processingEnvironment));
        this.add(new EActivityHandler(processingEnvironment));
        this.add(new EProviderHandler(processingEnvironment));
        this.add(new EReceiverHandler(processingEnvironment));
        this.add(new EServiceHandler(processingEnvironment));
        this.add(new EIntentServiceHandler(processingEnvironment));
        this.add(new EFragmentHandler(processingEnvironment));
        this.add(new EBeanHandler(processingEnvironment));
        this.add(new EViewGroupHandler(processingEnvironment));
        this.add(new EViewHandler(processingEnvironment));
        this.add(new SharedPrefHandler(processingEnvironment));
        this.add(new PrefHandler(processingEnvironment));
        this.add(new RoboGuiceHandler(processingEnvironment));
        this.add(new ViewByIdHandler(processingEnvironment));
        this.add(new FragmentByIdHandler(processingEnvironment));
        this.add(new FragmentByTagHandler(processingEnvironment));
        this.add(new FromHtmlHandler(processingEnvironment));
        this.add(new ClickHandler(processingEnvironment));
        this.add(new LongClickHandler(processingEnvironment));
        this.add(new TouchHandler(processingEnvironment));
        this.add(new FocusChangeHandler(processingEnvironment));
        this.add(new CheckedChangeHandler(processingEnvironment));
        this.add(new ItemClickHandler(processingEnvironment));
        this.add(new ItemSelectHandler(processingEnvironment));
        this.add(new ItemLongClickHandler(processingEnvironment));
        for (AndroidRes androidRes : AndroidRes.values()) {
            this.add(new ResHandler(androidRes, processingEnvironment));
        }
        this.add(new TransactionalHandler(processingEnvironment));
        this.add(new ExtraHandler(processingEnvironment));
        this.add(new FragmentArgHandler(processingEnvironment));
        this.add(new SystemServiceHandler(processingEnvironment));
        this.add(new RestHandler(processingEnvironment));
        this.add(new GetHandler(processingEnvironment));
        this.add(new PostHandler(processingEnvironment));
        this.add(new PutHandler(processingEnvironment));
        this.add(new DeleteHandler(processingEnvironment));
        this.add(new HeadHandler(processingEnvironment));
        this.add(new OptionsHandler(processingEnvironment));
        this.add(new AppHandler(processingEnvironment));
        this.add(new OptionsMenuHandler(processingEnvironment));
        this.add(new OptionsMenuItemHandler(processingEnvironment));
        this.add(new OptionsItemHandler(processingEnvironment));
        this.add(new NoTitleHandler(processingEnvironment));
        this.add(new CustomTitleHandler(processingEnvironment));
        this.add(new FullscreenHandler(processingEnvironment));
        this.add(new RestServiceHandler(processingEnvironment));
        this.add(new OrmLiteDaoHandler(processingEnvironment));
        this.add(new RootContextHanlder(processingEnvironment));
        this.add(new NonConfigurationInstanceHandler(processingEnvironment));
        this.add(new BeanHandler(processingEnvironment));
        this.add(new BeforeTextChangeHandler(processingEnvironment));
        this.add(new TextChangeHandler(processingEnvironment));
        this.add(new AfterTextChangeHandler(processingEnvironment));
        this.add(new SeekBarProgressChangeHandler(processingEnvironment));
        this.add(new SeekBarTouchStartHandler(processingEnvironment));
        this.add(new SeekBarTouchStopHandler(processingEnvironment));
        this.add(new ServiceActionHandler(processingEnvironment));
        this.add(new SubscribeHandler(processingEnvironment));
        this.add(new ProduceHandler(processingEnvironment));
        this.add(new InstanceStateHandler(processingEnvironment));
        this.add(new HttpsClientHandler(processingEnvironment));
        this.add(new OnActivityResultHandler(processingEnvironment));
        this.add(new HierarchyViewerSupportHandler(processingEnvironment));
        this.add(new WindowFeatureHandler(processingEnvironment));
        this.add(new AfterInjectHandler(processingEnvironment));
        this.add(new AfterViewsHandler(processingEnvironment));
        if (this.optionsHelper.shouldLogTrace()) {
            this.add(new TraceHandler(processingEnvironment));
        }
        this.add(new UiThreadHandler(processingEnvironment));
        this.add(new BackgroundHandler(processingEnvironment));
    }

    private void add(AnnotationHandler<? extends GeneratedClassHolder> annotationHandler) {
        this.annotationHandlers.add(annotationHandler);
        this.decoratingAnnotationHandlers.add(annotationHandler);
    }

    private void add(GeneratingAnnotationHandler<? extends GeneratedClassHolder> annotationHandler) {
        this.annotationHandlers.add(annotationHandler);
        this.generatingAnnotationHandlers.add(annotationHandler);
    }

    public List<AnnotationHandler<? extends GeneratedClassHolder>> get() {
        return this.annotationHandlers;
    }

    public List<GeneratingAnnotationHandler<? extends GeneratedClassHolder>> getGenerating() {
        return this.generatingAnnotationHandlers;
    }

    public List<AnnotationHandler<? extends GeneratedClassHolder>> getDecorating() {
        return this.decoratingAnnotationHandlers;
    }

    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        for (AnnotationHandler<? extends GeneratedClassHolder> annotationHandler : this.annotationHandlers) {
            annotationHandler.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        }
    }

    public void setValidatedModel(AnnotationElements validatedModel) {
        for (AnnotationHandler<? extends GeneratedClassHolder> annotationHandler : this.annotationHandlers) {
            annotationHandler.setValidatedModel(validatedModel);
        }
    }

    public void setProcessHolder(ProcessHolder processHolder) {
        for (AnnotationHandler<? extends GeneratedClassHolder> annotationHandler : this.annotationHandlers) {
            annotationHandler.setProcessHolder(processHolder);
        }
    }

    public Set<String> getSupportedAnnotationTypes() {
        if (this.supportedAnnotationNames == null) {
            HashSet<String> annotationNames = new HashSet<String>();
            for (AnnotationHandler<? extends GeneratedClassHolder> annotationHandler : this.annotationHandlers) {
                annotationNames.add(annotationHandler.getTarget());
            }
            this.supportedAnnotationNames = Collections.unmodifiableSet(annotationNames);
        }
        return this.supportedAnnotationNames;
    }
}

