/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JMethod;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.FragmentByTag;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public class FragmentByTagHandler
extends BaseAnnotationHandler<EComponentWithViewSupportHolder> {
    private IdAnnotationHelper annotationHelper;

    public FragmentByTagHandler(ProcessingEnvironment processingEnvironment) {
        super(FragmentByTag.class, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.annotationHelper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validatedElements, valid);
        this.validatorHelper.extendsFragment(element, valid);
        this.validatorHelper.isNotPrivate(element, valid);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) {
        TypeMirror elementType = element.asType();
        String typeQualifiedName = ((Object)elementType).toString();
        TypeMirror nativeFragmentType = this.annotationHelper.typeElementFromQualifiedName("android.app.Fragment").asType();
        boolean isNativeFragment = this.annotationHelper.isSubtype(elementType, nativeFragmentType);
        JMethod findFragmentByTag = isNativeFragment ? holder.getFindNativeFragmentByTag() : holder.getFindSupportFragmentByTag();
        String fieldName = element.getSimpleName().toString();
        FragmentByTag annotation = element.getAnnotation(FragmentByTag.class);
        String tagValue = annotation.value();
        if (tagValue.equals("")) {
            tagValue = fieldName;
        }
        JBlock methodBody = holder.getOnViewChangedBody();
        methodBody.assign(JExpr.ref(fieldName), JExpr.cast(this.refClass(typeQualifiedName), JExpr.invoke(findFragmentByTag).arg(JExpr.lit(tagValue))));
    }
}

