/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCast;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.androidannotations.annotations.HttpsClient;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.process.ProcessHolder;
import org.androidannotations.rclass.IRClass;
import org.androidannotations.rclass.IRInnerClass;

public class HttpsClientHandler
extends BaseAnnotationHandler<EComponentHolder> {
    public HttpsClientHandler(ProcessingEnvironment processingEnvironment) {
        super(HttpsClient.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        this.validatorHelper.annotationParameterIsOptionalValidResId(element, IRClass.Res.RAW, "keyStore", valid);
        this.validatorHelper.annotationParameterIsOptionalValidResId(element, IRClass.Res.RAW, "trustStore", valid);
        this.validatorHelper.isNotPrivate(element, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        JFieldRef rawIdRef;
        HttpsClient annotation = element.getAnnotation(HttpsClient.class);
        int trustStoreRawId = annotation.trustStore();
        String trustStorePwd = annotation.trustStorePwd();
        int keyStoreRawId = annotation.keyStore();
        String keyStorePwd = annotation.keyStorePwd();
        boolean allowAllHostnames = annotation.allowAllHostnames();
        boolean useCustomTrustStore = -1 != trustStoreRawId;
        boolean useCustomKeyStore = -1 != keyStoreRawId;
        String fieldName = element.getSimpleName().toString();
        JBlock methodBody = holder.getInitBody();
        ProcessHolder.Classes classes = this.classes();
        JDefinedClass jAnonClass = this.codeModel().anonymousClass(classes.DEFAULT_HTTP_CLIENT);
        JMethod method = jAnonClass.method(2, classes.CLIENT_CONNECTION_MANAGER, "createClientConnectionManager");
        method.annotate(Override.class);
        JTryBlock jTryBlock = method.body()._try();
        JVar jVarTrusted = null;
        JVar jVarKeystore = null;
        if (useCustomKeyStore) {
            jVarKeystore = jTryBlock.body().decl(classes.KEY_STORE, "keystore");
            jVarKeystore.init(classes.KEY_STORE.staticInvoke("getInstance").arg("BKS"));
        }
        if (useCustomTrustStore || useCustomKeyStore) {
            jVarTrusted = jTryBlock.body().decl(classes.KEY_STORE, "trusted");
            jVarTrusted.init(classes.KEY_STORE.staticInvoke("getInstance").arg("BKS"));
        }
        JVar jVarRes = null;
        JVar jVarTrstFile = null;
        JVar jVarKeyFile = null;
        if (useCustomKeyStore || useCustomTrustStore) {
            jVarRes = jTryBlock.body().decl(classes.RESOURCES, "res", JExpr.invoke("getResources"));
        }
        IRInnerClass rInnerClass = this.rClass.get(IRClass.Res.RAW);
        if (useCustomKeyStore) {
            rawIdRef = rInnerClass.getIdStaticRef(keyStoreRawId, this.processHolder);
            JInvocation jInvRawKey = jVarRes.invoke("openRawResource").arg(rawIdRef);
            jVarKeyFile = jTryBlock.body().decl(classes.INPUT_STREAM, "inKeystore", jInvRawKey);
        }
        if (useCustomTrustStore) {
            rawIdRef = rInnerClass.getIdStaticRef(trustStoreRawId, this.processHolder);
            JInvocation jInvRawTrust = jVarRes.invoke("openRawResource").arg(rawIdRef);
            jVarTrstFile = jTryBlock.body().decl(classes.INPUT_STREAM, "inTrustStore", jInvRawTrust);
        } else if (useCustomKeyStore) {
            jVarTrstFile = jTryBlock.body().decl(classes.INPUT_STREAM, "inTrustStore", JExpr._new(classes.FILE_INPUT_STREAM).arg("/system/etc/security/cacerts.bks"));
        }
        if (useCustomKeyStore || useCustomTrustStore) {
            JTryBlock jTryLoad = jTryBlock.body()._try();
            if (useCustomKeyStore) {
                jTryLoad.body().add(JExpr.invoke((JExpression)jVarKeystore, "load").arg(jVarKeyFile).arg(JExpr.invoke(JExpr.lit(keyStorePwd), "toCharArray")));
            }
            jTryLoad.body().add(JExpr.invoke((JExpression)jVarTrusted, "load").arg(jVarTrstFile).arg(JExpr.invoke(JExpr.lit(trustStorePwd), "toCharArray")));
            JBlock jFinally = jTryLoad._finally();
            if (useCustomKeyStore) {
                jFinally.add(JExpr.invoke((JExpression)jVarKeyFile, "close"));
            }
            jFinally.add(JExpr.invoke((JExpression)jVarTrstFile, "close"));
        }
        if (null == jVarKeystore && null == jVarTrusted) {
            JVar jVarCcm = jTryBlock.body().decl(classes.CLIENT_CONNECTION_MANAGER, "ccm");
            jVarCcm.init(JExpr._super().invoke("createClientConnectionManager"));
            if (allowAllHostnames) {
                JCast jCast = JExpr.cast(classes.SSL_SOCKET_FACTORY, jVarCcm.invoke("getSchemeRegistry").invoke("getScheme").arg("https").invoke("getSocketFactory"));
                jTryBlock.body().add(jCast.invoke("setHostnameVerifier").arg(classes.SSL_SOCKET_FACTORY.staticRef("ALLOW_ALL_HOSTNAME_VERIFIER")));
            }
            jTryBlock.body()._return(jVarCcm);
        } else {
            JVar jVarSslFact = jTryBlock.body().decl(classes.SSL_SOCKET_FACTORY, "newSslSocketFactory");
            jVarSslFact.init(JExpr._new(classes.SSL_SOCKET_FACTORY).arg(null == jVarKeystore ? JExpr._null() : jVarKeystore).arg(keyStorePwd).arg(jVarTrusted));
            if (allowAllHostnames) {
                jTryBlock.body().add(JExpr.invoke((JExpression)jVarSslFact, "setHostnameVerifier").arg(classes.SSL_SOCKET_FACTORY.staticRef("ALLOW_ALL_HOSTNAME_VERIFIER")));
            }
            JVar jVarSchemeReg = jTryBlock.body().decl(classes.SCHEME_REGISTRY, "registry");
            jVarSchemeReg.init(JExpr._new(classes.SCHEME_REGISTRY));
            jTryBlock.body().add(JExpr.invoke((JExpression)jVarSchemeReg, "register").arg(JExpr._new(classes.SCHEME).arg("https").arg(jVarSslFact).arg(JExpr.lit(443))));
            JVar jVarCcm = jTryBlock.body().decl(classes.CLIENT_CONNECTION_MANAGER, "ccm");
            jVarCcm.init(JExpr._new(classes.SINGLE_CLIENT_CONN_MANAGER).arg(JExpr.invoke("getParams")).arg(jVarSchemeReg));
            jTryBlock.body()._return(jVarCcm);
        }
        JCatchBlock jCatchBlock = jTryBlock._catch(classes.EXCEPTION);
        JVar jVarExceptionParam = jCatchBlock.param("e");
        jCatchBlock.body().add(jVarExceptionParam.invoke("printStackTrace"));
        jCatchBlock.body()._return(JExpr._super().invoke("createClientConnectionManager"));
        methodBody.assign(JExpr.ref(fieldName), JExpr._new(jAnonClass));
    }
}

