/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.ItemLongClick;
import org.androidannotations.handler.AbstractListenerHandler;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class ItemLongClickHandler
extends AbstractListenerHandler {
    public ItemLongClickHandler(ProcessingEnvironment processingEnvironment) {
        super(ItemLongClick.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        super.validate(element, validatedElements, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoidOrBoolean(executableElement, valid);
        this.validatorHelper.param.zeroOrOneParameter(executableElement, valid);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        boolean returnMethodResult;
        boolean bl = returnMethodResult = returnType.getKind() != TypeKind.VOID;
        if (returnMethodResult) {
            listenerMethodBody._return(call);
        } else {
            listenerMethodBody.add(call);
            listenerMethodBody._return(JExpr.TRUE);
        }
    }

    @Override
    protected void processParameters(JMethod listenerMethod, JInvocation call, List<? extends VariableElement> parameters) {
        boolean hasItemParameter = parameters.size() == 1;
        JClass narrowAdapterViewClass = this.classes().ADAPTER_VIEW.narrow(this.codeModel().wildcard());
        JVar onItemClickParentParam = listenerMethod.param(narrowAdapterViewClass, "parent");
        listenerMethod.param(this.classes().VIEW, "view");
        JVar onItemClickPositionParam = listenerMethod.param(this.codeModel().INT, "position");
        listenerMethod.param(this.codeModel().LONG, "id");
        if (hasItemParameter) {
            VariableElement parameter = parameters.get(0);
            TypeMirror parameterType = parameter.asType();
            if (parameterType.getKind() == TypeKind.INT) {
                call.arg(onItemClickPositionParam);
            } else {
                String parameterTypeQualifiedName = ((Object)parameterType).toString();
                call.arg(JExpr.cast(this.refClass(parameterTypeQualifiedName), JExpr.invoke((JExpression)onItemClickParentParam, "getAdapter").invoke("getItem").arg(onItemClickPositionParam)));
            }
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, this.codeModel().BOOLEAN, "onItemLongClick");
    }

    @Override
    protected String getSetterName() {
        return "setOnItemLongClickListener";
    }

    @Override
    protected JClass getListenerClass() {
        return this.classes().ON_ITEM_LONG_CLICK_LISTENER;
    }

    @Override
    protected JType getViewClass() {
        return this.classes().ADAPTER_VIEW.narrow(this.codeModel().wildcard());
    }
}

