/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.OnActivityResult;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.holder.HasOnActivityResult;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class OnActivityResultHandler
extends BaseAnnotationHandler<HasOnActivityResult> {
    public OnActivityResultHandler(ProcessingEnvironment processingEnvironment) {
        super(OnActivityResult.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragment(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.doesntThrowException(element, valid);
        OnActivityResult onResultAnnotation = element.getAnnotation(OnActivityResult.class);
        this.validatorHelper.annotationValuePositiveAndInAShort(element, valid, onResultAnnotation.value());
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, valid);
        this.validatorHelper.hasOnResultMethodParameters(executableElement, valid);
    }

    @Override
    public void process(Element element, HasOnActivityResult holder) throws Exception {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int intentParameterPosition = -1;
        int resultCodeParameterPosition = -1;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameter.asType();
            if ("android.content.Intent".equals(((Object)parameterType).toString())) {
                intentParameterPosition = i;
                continue;
            }
            if (!parameterType.getKind().equals((Object)TypeKind.INT) && !CanonicalNameConstants.INTEGER.equals(((Object)parameterType).toString())) continue;
            resultCodeParameterPosition = i;
        }
        int requestCode = executableElement.getAnnotation(OnActivityResult.class).value();
        JBlock onActivityResultCase = holder.getOnActivityResultCaseBlock(requestCode);
        JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
        JInvocation onResultInvocation = onActivityResultCase.invoke((JExpression)activityRef, methodName);
        for (int i = 0; i < parameters.size(); ++i) {
            if (i == intentParameterPosition) {
                JVar intentParameter = holder.getOnActivityResultDataParam();
                onResultInvocation.arg(intentParameter);
                continue;
            }
            if (i != resultCodeParameterPosition) continue;
            JVar resultCodeParameter = holder.getOnActivityResultResultCodeParam();
            onResultInvocation.arg(resultCodeParameter);
        }
    }
}

