/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JMethod;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class ProduceHandler
extends BaseAnnotationHandler<EComponentHolder> {
    private final TargetAnnotationHelper annotationHelper;
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public ProduceHandler(ProcessingEnvironment processingEnvironment) {
        super("com.squareup.otto.Produce", processingEnvironment);
        this.annotationHelper = new TargetAnnotationHelper(this.processingEnv, this.getTarget());
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        if (!this.annotationHelper.enclosingElementHasEnhancedComponentAnnotation(element)) {
            valid.invalidate();
            return;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(executableElement, validatedElements, valid);
        this.validatorHelper.returnTypeIsNotVoid(executableElement, valid);
        this.validatorHelper.isPublic(element, valid);
        this.validatorHelper.doesntThrowException(executableElement, valid);
        this.validatorHelper.isNotFinal(element, valid);
        this.validatorHelper.param.zeroParameter(executableElement, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        JMethod delegatingMethod = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        delegatingMethod.annotate(this.refClass("com.squareup.otto.Produce"));
    }
}

