/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.res.HtmlRes;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AndroidRes;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public class ResHandler
extends BaseAnnotationHandler<EComponentHolder> {
    private AndroidRes androidRes;
    private IdAnnotationHelper annotationHelper;

    public ResHandler(AndroidRes androidRes, ProcessingEnvironment processingEnvironment) {
        super(androidRes.getAnnotationClass(), processingEnvironment);
        this.androidRes = androidRes;
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.annotationHelper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        TypeMirror fieldTypeMirror = element.asType();
        this.validatorHelper.allowedType(element, valid, fieldTypeMirror, this.androidRes.getAllowedTypes());
        this.validatorHelper.resIdsExist(element, this.androidRes.getRInnerClass(), IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
        this.validatorHelper.isNotPrivate(element, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        String fieldName = element.getSimpleName().toString();
        IRClass.Res resInnerClass = this.androidRes.getRInnerClass();
        JFieldRef idRef = this.annotationHelper.extractOneAnnotationFieldRef(this.processHolder, element, resInnerClass, true);
        JBlock methodBody = holder.getInitBody();
        TypeMirror fieldTypeMirror = element.asType();
        String fieldType = ((Object)fieldTypeMirror).toString();
        if ("android.view.animation.Animation".equals(fieldType)) {
            methodBody.assign(JExpr.ref(fieldName), this.classes().ANIMATION_UTILS.staticInvoke("loadAnimation").arg(holder.getContextRef()).arg(idRef));
        } else {
            String resourceMethodName = this.androidRes.getResourceMethodName();
            if (element.getAnnotation(HtmlRes.class) != null) {
                methodBody.assign(JExpr.ref(fieldName), this.classes().HTML.staticInvoke("fromHtml").arg(JExpr.invoke((JExpression)holder.getResourcesRef(), resourceMethodName).arg(idRef)));
            } else {
                methodBody.assign(JExpr.ref(fieldName), JExpr.invoke((JExpression)holder.getResourcesRef(), resourceMethodName).arg(idRef));
            }
        }
    }
}

