/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.annotations.RoboGuice;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.EActivityHolder;
import org.androidannotations.holder.RoboGuiceHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class RoboGuiceHandler
extends BaseAnnotationHandler<EActivityHolder> {
    private APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public RoboGuiceHandler(ProcessingEnvironment processingEnvironment) {
        super(RoboGuice.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.hasEActivity(element, validatedElements, valid);
        this.validatorHelper.hasRoboGuiceJars(element, valid);
    }

    @Override
    public void process(Element element, EActivityHolder holder) {
        RoboGuiceHolder roboGuiceHolder = holder.getRoboGuiceHolder();
        holder.getGeneratedClass()._implements(this.classes().INJECTOR_PROVIDER);
        JFieldVar scope = roboGuiceHolder.getScopeField();
        JFieldVar eventManager = roboGuiceHolder.getEventManagerField();
        JMethod getInjector = roboGuiceHolder.getGetInjector();
        this.listenerFields(element, holder);
        this.beforeCreateMethod(holder, scope, eventManager, getInjector);
        this.afterSetContentView(holder, scope, eventManager);
        this.onRestartMethod(roboGuiceHolder, scope, eventManager);
        this.onStartMethod(roboGuiceHolder, scope, eventManager);
        this.onResumeMethod(roboGuiceHolder, scope, eventManager);
        this.onPauseMethod(roboGuiceHolder, eventManager);
        this.onNewIntentMethod(roboGuiceHolder, scope, eventManager);
        this.onStopMethod(roboGuiceHolder, scope, eventManager);
        this.onDestroyMethod(roboGuiceHolder, scope, eventManager);
        this.onConfigurationChangedMethod(roboGuiceHolder, eventManager);
        this.onContentChangedMethod(roboGuiceHolder, eventManager);
        this.onActivityResultMethod(roboGuiceHolder, scope, eventManager);
    }

    private void listenerFields(Element element, EActivityHolder holder) {
        List<String> listenerClasses = this.extractListenerClasses(element);
        if (listenerClasses.size() > 0) {
            int i = 1;
            for (String listenerClassName : listenerClasses) {
                JClass listenerClass = this.refClass(listenerClassName);
                JFieldVar listener = holder.getGeneratedClass().field(4, listenerClass, "listener" + i + "_");
                listener.annotate(SuppressWarnings.class).param("value", "unused");
                listener.annotate(this.classes().INJECT);
                ++i;
            }
        }
    }

    private List<String> extractListenerClasses(Element activityElement) {
        List<? extends AnnotationMirror> annotationMirrors = activityElement.getAnnotationMirrors();
        String annotationName = RoboGuice.class.getName();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"value".equals(entry.getKey().getSimpleName().toString())) continue;
                AnnotationValue action = entry.getValue();
                List values = (List)action.getValue();
                ArrayList<String> listenerClasses = new ArrayList<String>();
                for (Object value : values) {
                    listenerClasses.add(value.toString());
                }
                return listenerClasses;
            }
        }
        return new ArrayList<String>(0);
    }

    private void beforeCreateMethod(EActivityHolder holder, JFieldVar scope, JFieldVar eventManager, JMethod getInjector) {
        JBlock body = holder.getInitBody();
        JVar injector = body.decl(this.classes().INJECTOR, "injector_", JExpr.invoke(getInjector));
        body.assign(scope, JExpr.invoke((JExpression)injector, "getInstance").arg(this.classes().CONTEXT_SCOPE.dotclass()));
        body.invoke((JExpression)scope, "enter").arg(JExpr._this());
        body.invoke((JExpression)injector, "injectMembers").arg(JExpr._this());
        body.assign(eventManager, JExpr.invoke((JExpression)injector, "getInstance").arg(this.classes().EVENT_MANAGER.dotclass()));
        this.fireEvent(eventManager, body, this.classes().ON_CREATE_EVENT, holder.getInitSavedInstanceParam());
    }

    private void afterSetContentView(EActivityHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JBlock onViewChanged = holder.getOnViewChangedBody();
        onViewChanged.invoke((JExpression)scope, "injectViews");
        this.fireEvent(eventManager, onViewChanged, this.classes().ON_CONTENT_VIEW_AVAILABLE_EVENT, new JExpression[0]);
    }

    private void onRestartMethod(RoboGuiceHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JBlock onRestartBeforeSuperBlock = holder.getOnRestartBeforeSuperBlock();
        onRestartBeforeSuperBlock.invoke((JExpression)scope, "enter").arg(JExpr._this());
        JBlock onRestartAfterSuperBlock = holder.getOnRestartAfterSuperBlock();
        this.fireEvent(eventManager, onRestartAfterSuperBlock, this.classes().ON_RESTART_EVENT, new JExpression[0]);
    }

    private void onStartMethod(RoboGuiceHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JBlock onStartBeforeSuperBlock = holder.getOnStartBeforeSuperBlock();
        onStartBeforeSuperBlock.invoke((JExpression)scope, "enter").arg(JExpr._this());
        JBlock onStartAfterSuperBlock = holder.getOnStartAfterSuperBlock();
        this.fireEvent(eventManager, onStartAfterSuperBlock, this.classes().ON_START_EVENT, new JExpression[0]);
    }

    private void onResumeMethod(RoboGuiceHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JBlock onResumeBeforeSuperBlock = holder.getOnResumeBeforeSuperBlock();
        onResumeBeforeSuperBlock.invoke((JExpression)scope, "enter").arg(JExpr._this());
        JBlock onResumeAfterSuperBlock = holder.getOnResumeAfterSuperBlock();
        this.fireEvent(eventManager, onResumeAfterSuperBlock, this.classes().ON_RESUME_EVENT, new JExpression[0]);
    }

    private void onPauseMethod(RoboGuiceHolder holder, JFieldVar eventManager) {
        JBlock onPauseAfterSuperBlock = holder.getOnPauseAfterSuperBlock();
        this.fireEvent(eventManager, onPauseAfterSuperBlock, this.classes().ON_PAUSE_EVENT, new JExpression[0]);
    }

    private void onNewIntentMethod(RoboGuiceHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JBlock onNewIntentAfterSuperBlock = holder.getOnNewIntentAfterSuperBlock();
        onNewIntentAfterSuperBlock.invoke((JExpression)scope, "enter").arg(JExpr._this());
        this.fireEvent(eventManager, onNewIntentAfterSuperBlock, this.classes().ON_NEW_INTENT_EVENT, new JExpression[0]);
    }

    private void onStopMethod(RoboGuiceHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JBlock onStopBlock = new JBlock(false, false);
        onStopBlock.invoke((JExpression)scope, "enter").arg(JExpr._this());
        JTryBlock tryBlock = onStopBlock._try();
        this.fireEvent(eventManager, tryBlock.body(), this.classes().ON_STOP_EVENT, new JExpression[0]);
        JBlock finallyBody = tryBlock._finally();
        finallyBody.invoke((JExpression)scope, "exit").arg(JExpr._this());
        finallyBody.invoke(JExpr._super(), "onStop");
        JMethod onStop = holder.getOnStop();
        this.codeModelHelper.replaceSuperCall(onStop, onStopBlock);
    }

    private void onDestroyMethod(RoboGuiceHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JBlock onDestroyBlock = new JBlock(false, false);
        onDestroyBlock.invoke((JExpression)scope, "enter").arg(JExpr._this());
        JTryBlock tryBlock = onDestroyBlock._try();
        this.fireEvent(eventManager, tryBlock.body(), this.classes().ON_DESTROY_EVENT, new JExpression[0]);
        JBlock finallyBody = tryBlock._finally();
        finallyBody.invoke((JExpression)eventManager, "clear").arg(JExpr._this());
        finallyBody.invoke((JExpression)scope, "exit").arg(JExpr._this());
        finallyBody.invoke((JExpression)scope, "dispose").arg(JExpr._this());
        finallyBody.invoke(JExpr._super(), "onDestroy");
        JMethod onDestroy = holder.getOnDestroy();
        this.codeModelHelper.replaceSuperCall(onDestroy, onDestroyBlock);
    }

    private void onConfigurationChangedMethod(RoboGuiceHolder holder, JFieldVar eventManager) {
        JVar currentConfig = holder.getCurrentConfig();
        JBlock onConfigurationChangedAfterSuperBlock = holder.getOnConfigurationChangedAfterSuperBlock();
        JVar newConfig = holder.getNewConfig();
        this.fireEvent(eventManager, onConfigurationChangedAfterSuperBlock, this.classes().ON_CONFIGURATION_CHANGED_EVENT, currentConfig, newConfig);
    }

    private void onContentChangedMethod(RoboGuiceHolder holder, JFieldVar eventManager) {
        JBlock onContentChangedAfterSuperBlock = holder.getOnContentChangedAfterSuperBlock();
        this.fireEvent(eventManager, onContentChangedAfterSuperBlock, this.classes().ON_CONTENT_CHANGED_EVENT, new JExpression[0]);
    }

    private void onActivityResultMethod(RoboGuiceHolder holder, JFieldVar scope, JFieldVar eventManager) {
        JBlock onActivityResultAfterSuperBlock = holder.getOnActivityResultAfterSuperBlock();
        JVar requestCode = holder.getRequestCode();
        JVar resultCode = holder.getResultCode();
        JVar data = holder.getData();
        onActivityResultAfterSuperBlock.invoke((JExpression)scope, "enter").arg(JExpr._this());
        JTryBlock tryBlock = onActivityResultAfterSuperBlock._try();
        this.fireEvent(eventManager, tryBlock.body(), this.classes().ON_ACTIVITY_RESULT_EVENT, requestCode, resultCode, data);
        JBlock finallyBody = tryBlock._finally();
        finallyBody.invoke((JExpression)scope, "exit").arg(JExpr._this());
    }

    private void fireEvent(JFieldVar eventManager, JBlock body, JClass eventClass, JExpression ... eventArguments) {
        JInvocation newEvent = JExpr._new(eventClass);
        for (JExpression eventArgument : eventArguments) {
            newEvent.arg(eventArgument);
        }
        body.invoke((JExpression)eventManager, "fire").arg(newEvent);
    }
}

