/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.androidannotations.annotations.ServiceAction;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.holder.EIntentServiceHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class ServiceActionHandler
extends BaseAnnotationHandler<EIntentServiceHolder> {
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();
    private AnnotationHelper annotationHelper;

    public ServiceActionHandler(ProcessingEnvironment processingEnvironment) {
        super(ServiceAction.class, processingEnvironment);
        this.annotationHelper = new AnnotationHelper(processingEnvironment);
    }

    @Override
    protected void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEIntentService(element, validatedElements, valid);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, valid);
        this.validatorHelper.isNotPrivate(element, valid);
    }

    @Override
    public void process(Element element, EIntentServiceHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        String methodName = element.getSimpleName().toString();
        ServiceAction annotation = element.getAnnotation(ServiceAction.class);
        String extraKey = annotation.value();
        if (extraKey.isEmpty()) {
            extraKey = methodName;
        }
        JFieldVar actionKeyField = this.createStaticActionField(holder, extraKey, methodName);
        this.addActionInOnHandleIntent(holder, executableElement, methodName, actionKeyField);
        this.addActionToIntentBuilder(holder, executableElement, methodName, actionKeyField);
    }

    private JFieldVar createStaticActionField(EIntentServiceHolder holder, String extraKey, String methodName) {
        String staticFieldName = CaseHelper.camelCaseToUpperSnakeCase("action", methodName, null);
        return holder.getGeneratedClass().field(25, this.classes().STRING, staticFieldName, JExpr.lit(extraKey));
    }

    private void addActionInOnHandleIntent(EIntentServiceHolder holder, ExecutableElement executableElement, String methodName, JFieldVar actionKeyField) {
        JInvocation actionCondition = actionKeyField.invoke("equals").arg(holder.getOnHandleIntentIntentAction());
        JBlock callActionBlock = holder.getOnHandleIntentBody()._if(actionCondition)._then();
        JInvocation callActionInvocation = JExpr._super().invoke(methodName);
        List<? extends VariableElement> methodParameters = executableElement.getParameters();
        if (methodParameters.size() > 0) {
            JVar extras = callActionBlock.decl(this.classes().BUNDLE, "extras");
            extras.init(holder.getOnHandleIntentIntent().invoke("getExtras"));
            JBlock extrasNotNullBlock = callActionBlock._if(extras.ne(JExpr._null()))._then();
            for (VariableElement variableElement : methodParameters) {
                String paramName = variableElement.getSimpleName().toString();
                String extraParamName = paramName + "Extra";
                JFieldVar paramVar = this.getStaticExtraField(holder, paramName);
                JClass extraParamClass = this.codeModelHelper.typeMirrorToJClass(variableElement.asType(), holder);
                BundleHelper bundleHelper = new BundleHelper(this.annotationHelper, variableElement);
                JExpressionImpl getExtraExpression = JExpr.invoke((JExpression)extras, bundleHelper.getMethodNameToRestore()).arg(paramVar);
                if (bundleHelper.restoreCallNeedCastStatement()) {
                    JMethod onHandleIntentMethod;
                    getExtraExpression = JExpr.cast(extraParamClass, getExtraExpression);
                    if (bundleHelper.restoreCallNeedsSuppressWarning() && (onHandleIntentMethod = holder.getOnHandleIntentMethod()).annotations().size() == 0) {
                        onHandleIntentMethod.annotate(SuppressWarnings.class).param("value", "unchecked");
                    }
                }
                JVar extraField = extrasNotNullBlock.decl(extraParamClass, extraParamName, getExtraExpression);
                callActionInvocation.arg(extraField);
            }
            extrasNotNullBlock.add(callActionInvocation);
        } else {
            callActionBlock.add(callActionInvocation);
        }
        callActionBlock._return();
    }

    private void addActionToIntentBuilder(EIntentServiceHolder holder, ExecutableElement executableElement, String methodName, JFieldVar actionKeyField) {
        JMethod method = holder.getIntentBuilderClass().method(1, holder.getIntentBuilderClass(), methodName);
        JBlock body = method.body();
        body.invoke((JExpression)holder.getIntentField(), "setAction").arg(actionKeyField);
        List<? extends VariableElement> methodParameters = executableElement.getParameters();
        if (methodParameters.size() > 0) {
            for (VariableElement variableElement : methodParameters) {
                String paramName = variableElement.getSimpleName().toString();
                JClass parameterClass = this.codeModelHelper.typeMirrorToJClass(variableElement.asType(), holder);
                JFieldVar paramVar = this.getStaticExtraField(holder, paramName);
                JVar methodParam = method.param(parameterClass, paramName);
                JMethod putExtraMethod = holder.getIntentBuilder().getPutExtraMethod(variableElement.asType(), paramName, paramVar);
                body.invoke(putExtraMethod).arg(methodParam);
            }
        }
        body._return(JExpr._this());
    }

    private JFieldVar getStaticExtraField(EIntentServiceHolder holder, String extraName) {
        String staticFieldName = CaseHelper.camelCaseToUpperSnakeCase(null, extraName, "Extra");
        JFieldVar staticExtraField = holder.getGeneratedClass().fields().get(staticFieldName);
        if (staticExtraField == null) {
            staticExtraField = holder.getGeneratedClass().field(25, this.classes().STRING, staticFieldName, JExpr.lit(extraName));
        }
        return staticExtraField;
    }
}

