/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.SystemService;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class SystemServiceHandler
extends BaseAnnotationHandler<EComponentHolder> {
    public SystemServiceHandler(ProcessingEnvironment processingEnvironment) {
        super(SystemService.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        this.validatorHelper.androidService(this.androidSystemServices, element, valid);
        this.validatorHelper.isNotPrivate(element, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        String fieldName = element.getSimpleName().toString();
        TypeMirror serviceType = element.asType();
        String fieldTypeQualifiedName = ((Object)serviceType).toString();
        JFieldRef serviceRef = this.androidSystemServices.getServiceConstant(serviceType, holder);
        JBlock methodBody = holder.getInitBody();
        methodBody.assign(JExpr.ref(fieldName), JExpr.cast(this.refClass(fieldTypeQualifiedName), holder.getContextRef().invoke("getSystemService").arg(serviceRef)));
    }
}

