/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.Touch;
import org.androidannotations.handler.AbstractListenerHandler;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class TouchHandler
extends AbstractListenerHandler {
    public TouchHandler(ProcessingEnvironment processingEnvironment) {
        super(Touch.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        super.validate(element, validatedElements, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoidOrBoolean(executableElement, valid);
        this.validatorHelper.param.hasOneMotionEventOrTwoMotionEventViewParameters(executableElement, valid);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        boolean returnMethodResult;
        boolean bl = returnMethodResult = returnType.getKind() != TypeKind.VOID;
        if (returnMethodResult) {
            listenerMethodBody._return(call);
        } else {
            listenerMethodBody.add(call);
            listenerMethodBody._return(JExpr.TRUE);
        }
    }

    @Override
    protected void processParameters(JMethod listenerMethod, JInvocation call, List<? extends VariableElement> parameters) {
        JVar viewParam = listenerMethod.param(this.classes().VIEW, "view");
        JVar eventParam = listenerMethod.param(this.classes().MOTION_EVENT, "event");
        boolean hasItemParameter = parameters.size() == 2;
        VariableElement first = parameters.get(0);
        String firstType = ((Object)first.asType()).toString();
        if (firstType.equals("android.view.MotionEvent")) {
            call.arg(eventParam);
        } else {
            call.arg(viewParam);
        }
        if (hasItemParameter) {
            VariableElement second = parameters.get(1);
            String secondType = ((Object)second.asType()).toString();
            if (secondType.equals("android.view.MotionEvent")) {
                call.arg(eventParam);
            } else {
                call.arg(viewParam);
            }
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, this.codeModel().BOOLEAN, "onTouch");
    }

    @Override
    protected String getSetterName() {
        return "setOnTouchListener";
    }

    @Override
    protected JClass getListenerClass() {
        return this.classes().VIEW_ON_TOUCH_LISTENER;
    }
}

